/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;

public abstract class BufferedStreamConverter
implements Cloneable,
StreamConverter {
    private Stack bufferedStack;
    private Map bufferedMap;
    private int bufferSize;

    public void setBufferSize(int size) {
        this.bufferSize = size;
        if (size <= 0) {
            this.bufferedStack = null;
            this.bufferedMap = null;
        } else {
            this.bufferedStack = new Stack();
            this.bufferedMap = Collections.synchronizedMap(new HashMap(size));
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream convertToStream(Object obj) throws ConvertException {
        byte[] bytes;
        if (this.bufferSize > 0 && (bytes = (byte[])this.bufferedMap.get(obj)) != null) {
            return new ByteArrayInputStream(bytes);
        }
        bytes = null;
        if (this.bufferSize > 0) {
            Object object = obj;
            synchronized (object) {
                bytes = (byte[])this.bufferedMap.get(obj);
                if (bytes == null) {
                    bytes = this.convertToByteArray(obj);
                }
                this.bufferedMap.put(obj, bytes);
            }
            object = this.bufferedStack;
            synchronized (object) {
                this.bufferedStack.push(obj);
                while (this.bufferedStack.size() > this.bufferSize) {
                    this.bufferedMap.remove(this.bufferedStack.pop());
                }
            }
        }
        bytes = this.convertToByteArray(obj);
        return bytes == null ? null : new ByteArrayInputStream(bytes);
    }

    protected abstract byte[] convertToByteArray(Object var1) throws ConvertException;
}

