/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.Connection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.MethodArrayEditor;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.GenericsServiceProxy;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.util.ClassMappingTree;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class ServiceManagerFactoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 5668270241695101050L;
    protected static final String INIT_PARAM_NAME_SERVICE_PATHS = "ServicePaths";
    protected static final String INIT_PARAM_NAME_CHECK_LOAD_MNG_CMP = "CheckLoadManagerCompleted";
    protected static final String INIT_PARAM_NAME_CHECK_LOAD_MNG_CMP_BY = "CheckLoadManagerCompletedBy";
    protected static final String INIT_PARAM_NAME_VALIDATE = "Validate";
    protected static final String INIT_PARAM_NAME_CONSOLE_ENABLED = "ConsoleEnabled";
    protected static final String INIT_PARAM_NAME_ATTR_SET_ENABLED = "AttributeSetEnabled";
    protected static final String INIT_PARAM_NAME_METHOD_CALL_ENABLED = "MethodCallEnabled";
    protected static final String INIT_PARAM_NAME_IGNORE_METHODS = "IgnoreMethods";
    protected static final String INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME = "JSONConverterServiceName";
    protected static final String INIT_PARAM_NAME_UNICODE_ESCAPE = "UnicodeEscape";
    private static final String ATTRIBUTE_READ_ONLY = "r";
    private static final String ATTRIBUTE_WRITE_ONLY = "w";
    private static final String ATTRIBUTE_READ_AND_WRITE = "rw";
    private static Method[] DEFAULT_IGNORE_METHODS;
    private ClassMappingTree ignoreMethodMap;
    private BeanJSONConverter jsonConverter;
    private StringStreamConverter toStringConverter;

    public synchronized void init() throws ServletException {
        Method[] ignoreMethods;
        int i;
        int i2;
        ServiceName jsonConverterServiceName = this.getJSONConverterServiceName();
        this.jsonConverter = jsonConverterServiceName == null ? new BeanJSONConverter() : (BeanJSONConverter)ServiceManagerFactory.getServiceObject(jsonConverterServiceName);
        this.jsonConverter.setCharacterEncodingToStream("UTF-8");
        this.jsonConverter.setUnicodeEscape(this.isUnicodeEscape());
        this.toStringConverter = new StringStreamConverter(2);
        this.toStringConverter.setCharacterEncodingToObject("UTF-8");
        String[] servicePaths = this.getServicePaths();
        boolean isValidate = this.isValidate();
        if (servicePaths != null && servicePaths.length != 0) {
            for (i2 = 0; i2 < servicePaths.length; ++i2) {
                ServiceManagerFactory.loadManager(servicePaths[i2], true, isValidate);
            }
        }
        if (this.isCheckLoadManagerCompleted()) {
            String[] managerNames = this.getCheckLoadManagerCompletedBy();
            if (managerNames == null || managerNames.length == 0) {
                ServiceManagerFactory.checkLoadManagerCompleted();
            } else {
                for (i = 0; i < managerNames.length; ++i) {
                    ServiceManagerFactory.checkLoadManagerCompletedBy(managerNames[i]);
                }
            }
        }
        if (DEFAULT_IGNORE_METHODS != null) {
            this.ignoreMethodMap = new ClassMappingTree();
            for (i2 = 0; i2 < DEFAULT_IGNORE_METHODS.length; ++i2) {
                this.ignoreMethodMap.add(DEFAULT_IGNORE_METHODS[i2].getDeclaringClass(), DEFAULT_IGNORE_METHODS[i2]);
            }
        }
        if ((ignoreMethods = this.getIgnoreMethods()) != null && ignoreMethods.length != 0) {
            if (this.ignoreMethodMap == null) {
                this.ignoreMethodMap = new ClassMappingTree();
            }
            for (i = 0; i < ignoreMethods.length; ++i) {
                this.ignoreMethodMap.add(ignoreMethods[i].getDeclaringClass(), ignoreMethods[i]);
            }
        }
    }

    private boolean isConsoleEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CONSOLE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isAttributeSetEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_ATTR_SET_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isMethodCallEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_METHOD_CALL_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private String getServicePath(String path) {
        ServletContext context = this.getServletConfig().getServletContext();
        String result = context.getRealPath(path);
        if (result == null) {
            result = path;
        }
        return result;
    }

    private String[] getServicePaths() {
        ServletConfig config = this.getServletConfig();
        String servicePathString = config.getInitParameter(INIT_PARAM_NAME_SERVICE_PATHS);
        if (servicePathString == null) {
            return null;
        }
        StringArrayEditor editor = new StringArrayEditor();
        editor.setAsText(servicePathString);
        String[] servicePaths = (String[])editor.getValue();
        for (int i = 0; i < servicePaths.length; ++i) {
            servicePaths[i] = this.getServicePath(servicePaths[i]);
        }
        return servicePaths;
    }

    private boolean isCheckLoadManagerCompleted() {
        ServletConfig config = this.getServletConfig();
        String isCheck = config.getInitParameter(INIT_PARAM_NAME_CHECK_LOAD_MNG_CMP);
        return isCheck == null ? false : Boolean.valueOf(isCheck);
    }

    private boolean isValidate() {
        ServletConfig config = this.getServletConfig();
        String isValidate = config.getInitParameter(INIT_PARAM_NAME_VALIDATE);
        return isValidate == null ? false : Boolean.valueOf(isValidate);
    }

    private String[] getCheckLoadManagerCompletedBy() {
        ServletConfig config = this.getServletConfig();
        String managerNames = config.getInitParameter(INIT_PARAM_NAME_CHECK_LOAD_MNG_CMP_BY);
        StringArrayEditor editor = new StringArrayEditor();
        editor.setAsText(managerNames);
        return (String[])editor.getValue();
    }

    private Method[] getIgnoreMethods() {
        ServletConfig config = this.getServletConfig();
        String ignoreMethodsStr = config.getInitParameter(INIT_PARAM_NAME_IGNORE_METHODS);
        if (ignoreMethodsStr == null) {
            return null;
        }
        MethodArrayEditor editor = new MethodArrayEditor();
        editor.setAsText(ignoreMethodsStr);
        return (Method[])editor.getValue();
    }

    private ServiceName getJSONConverterServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isUnicodeEscape() {
        ServletConfig config = this.getServletConfig();
        String isEscape = config.getInitParameter(INIT_PARAM_NAME_UNICODE_ESCAPE);
        return isEscape == null ? true : Boolean.valueOf(isEscape);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isConsoleEnabled()) {
            resp.sendError(406);
            return;
        }
        req.setCharacterEncoding("UTF-8");
        String action = req.getParameter("action");
        String responseType = req.getParameter("responseType");
        if (action == null) {
            this.processIndexResponse(req, resp, responseType);
        } else if (action.equals("manager")) {
            this.processManagerResponse(req, resp, responseType);
        } else if (action.equals("service")) {
            this.processServiceResponse(req, resp, responseType);
        } else if (action.equals("set")) {
            if (!this.isAttributeSetEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processSetAttributeResponse(req, resp, responseType);
        } else if (action.equals("get")) {
            this.processGetAttributeResponse(req, resp, responseType);
        } else if (action.equals("call")) {
            if (!this.isMethodCallEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processCallOperationResponse(req, resp, responseType);
        } else {
            resp.sendError(404);
        }
    }

    protected void processIndexResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            ServiceManager[] managers = ServiceManagerFactory.findManagers();
            Object[] managerNames = new String[managers.length];
            for (int i = 0; i < managers.length; ++i) {
                managerNames[i] = managers[i].getServiceName();
            }
            Arrays.sort(managerNames);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(managerNames)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus ServiceManagerFactory</title></head>");
            buf.append("<body>");
            buf.append("<b>Service definition paths</b><br>");
            buf.append("<ul>");
            Collection loaderSet = ServiceManagerFactory.getLoaders();
            Object[] serviceURLs = new String[loaderSet.size()];
            Iterator loaders = loaderSet.iterator();
            int count = 0;
            while (loaders.hasNext()) {
                ServiceLoader loader = (ServiceLoader)loaders.next();
                serviceURLs[count++] = loader.getServiceURL().toString();
            }
            Arrays.sort(serviceURLs);
            for (int i = 0; i < serviceURLs.length; ++i) {
                Object fileName = serviceURLs[i];
                int index = ((String)fileName).lastIndexOf(47);
                if (index != -1) {
                    fileName = ((String)fileName).substring(index + 1);
                }
                buf.append("<li>").append("<a href=\"").append((String)serviceURLs[i]).append("\">").append((String)fileName).append("</a>").append("</li>");
            }
            buf.append("</ul>");
            buf.append("<p>");
            buf.append("<b>Service managers</b><br>");
            buf.append("<ul>");
            ServiceManager[] managers = ServiceManagerFactory.findManagers();
            Object[] managerNames = new String[managers.length];
            for (int i = 0; i < managers.length; ++i) {
                managerNames[i] = managers[i].getServiceName();
            }
            Arrays.sort(managerNames);
            StringBuffer url = new StringBuffer();
            for (int i = 0; i < managerNames.length; ++i) {
                url.setLength(0);
                url.append(this.getCurrentPath(req)).append("?action=manager&name=").append((String)managerNames[i]);
                buf.append("<li>");
                buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                buf.append((String)managerNames[i]).append("</a>");
                buf.append("</li>");
            }
            buf.append("</ul>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    private String getCurrentPath(HttpServletRequest req) {
        String path = req.getServletPath();
        if (path.endsWith("/")) {
            return "." + (req.getPathInfo() == null ? "" : req.getPathInfo());
        }
        return "." + path;
    }

    protected void processManagerResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String managerName = req.getParameter("name");
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            ArrayList<String> serviceNameList = new ArrayList<String>();
            if (managerName == null) {
                ServiceManager[] managers = ServiceManagerFactory.findManagers();
                for (int i = 0; i < managers.length; ++i) {
                    ServiceManager manager = managers[i];
                    Iterator names = manager.serviceNameSet().iterator();
                    while (names.hasNext()) {
                        String serviceNameStr = (String)names.next();
                        serviceNameList.add(new ServiceName(manager.getServiceName(), serviceNameStr).toString());
                    }
                }
            } else {
                ServiceManager manager = ServiceManagerFactory.findManager(managerName);
                if (manager == null) {
                    resp.sendError(404);
                    return;
                }
                Iterator names = manager.serviceNameSet().iterator();
                while (names.hasNext()) {
                    String serviceNameStr = (String)names.next();
                    serviceNameList.add(new ServiceName(managerName, serviceNameStr).toString());
                }
            }
            Collections.sort(serviceNameList);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(serviceNameList)));
        } else {
            if (managerName == null) {
                resp.sendError(400);
                return;
            }
            ServiceManager manager = ServiceManagerFactory.findManager(managerName);
            if (manager == null) {
                resp.sendError(404);
                return;
            }
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus ServiceManager ").append(managerName).append("</title></head>");
            buf.append("<body>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("<hr>");
            buf.append("<b>ServiceManager name : </b>").append(managerName);
            buf.append("<b>Services</b><br>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>class</th></tr>");
            Set serviceNameSet = manager.serviceNameSet();
            Object[] serviceNames = new ServiceName[serviceNameSet.size()];
            Iterator nameItr = manager.serviceNameSet().iterator();
            int count = 0;
            while (nameItr.hasNext()) {
                String serviceNameStr = (String)nameItr.next();
                serviceNames[count++] = new ServiceName(managerName, serviceNameStr);
            }
            Arrays.sort(serviceNames);
            StringBuffer url = new StringBuffer();
            for (int i = 0; i < serviceNames.length; ++i) {
                Object serviceName = serviceNames[i];
                url.setLength(0);
                url.append(this.getCurrentPath(req)).append("?action=service&name=").append(URLEncoder.encode(((ServiceName)serviceName).toString(), "UTF-8"));
                buf.append("<tr>");
                buf.append("<td><a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                buf.append(((ServiceName)serviceName).getServiceName()).append("</a></td><td>&nbsp;").append(this.getTargetObject(ServiceManagerFactory.getService((ServiceName)serviceName)).getClass().getName()).append("</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    private Object getTargetObject(Service service) {
        Object targetObj = service;
        if (service instanceof GenericsServiceProxy) {
            targetObj = ServiceManagerFactory.getServiceObject(service.getServiceManagerName(), service.getServiceName());
        }
        return targetObj;
    }

    protected void processServiceResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = null;
        try {
            service = ServiceManagerFactory.getService(serviceName);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        if (service == null) {
            resp.sendError(404);
            return;
        }
        Class<?> targetClass = this.getTargetObject(service).getClass();
        Method[] methods = targetClass.getMethods();
        Map attributeMap = this.getAttributes(methods);
        Object[] attributeNames = attributeMap.keySet().toArray(new String[attributeMap.size()]);
        Arrays.sort(attributeNames);
        HashMap<MethodSignature, Method> methodMap = new HashMap<MethodSignature, Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (this.isIgnoreMethod(methods[i]) || this.isAttributeMethod(methods[i])) continue;
            methodMap.put(new MethodSignature(methods[i]), methods[i]);
        }
        Object[] sigs = methodMap.keySet().toArray(new MethodSignature[methodMap.size()]);
        Arrays.sort(sigs);
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            String getAttributeStr = req.getParameter("getAttribute");
            boolean isGetAttribute = getAttributeStr != null && Boolean.valueOf(getAttributeStr) != false;
            LinkedHashMap<String, Object> serviceMap = new LinkedHashMap<String, Object>();
            serviceMap.put("className", targetClass.getName());
            ArrayList attributeList = new ArrayList();
            for (int i = 0; i < attributeNames.length; ++i) {
                LinkedHashMap<String, Object> attribute = new LinkedHashMap<String, Object>();
                Object attributeName = attributeNames[i];
                AttributeMethod attrMethod = (AttributeMethod)attributeMap.get(attributeName);
                String attrType = this.getAttributeType(attrMethod);
                attribute.put("name", attributeName);
                attribute.put("accessType", attrType);
                attribute.put("type", attrMethod.getType().getName());
                if (isGetAttribute && !attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                    String attrValue = this.getAttributeValue(service, attrMethod);
                    attribute.put("value", attrValue);
                }
                attributeList.add(attribute);
            }
            serviceMap.put("attributes", attributeList);
            ArrayList<String> operationList = new ArrayList<String>();
            for (int i = 0; i < sigs.length; ++i) {
                operationList.add(((MethodSignature)sigs[i]).toString());
            }
            serviceMap.put("operations", operationList);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(serviceMap)));
        } else {
            int i;
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus Service ").append(serviceNameStr).append("</title></head>");
            buf.append("<body>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("/");
            StringBuffer url = new StringBuffer();
            url.append(this.getCurrentPath(req)).append("?action=manager&name=").append(serviceName.getServiceManagerName());
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">ServiceManager</a>");
            buf.append("<hr>");
            buf.append("<b>Service name : </b>").append(serviceNameStr);
            buf.append("<p>");
            buf.append("<b>Service class : </b>").append(targetClass);
            buf.append("<p>");
            buf.append("<b>Attributes</b><br>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>r/w</th><th>type</th><th>value</th><th>apply</th></tr>");
            for (i = 0; i < attributeNames.length; ++i) {
                String attrValue;
                Object attributeName = attributeNames[i];
                AttributeMethod attrMethod = (AttributeMethod)attributeMap.get(attributeName);
                String attrType = this.getAttributeType(attrMethod);
                buf.append("<form name=\"").append((String)attributeName).append("\" action=\"").append(this.getCurrentPath(req)).append("\" method=\"POST\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"set\">");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\">");
                if (attrType.equals(ATTRIBUTE_READ_AND_WRITE) || attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                    MethodSignature signature = new MethodSignature(attrMethod.getSetter());
                    buf.append("<input type=\"hidden\" name=\"method\" value=\"").append(signature).append("\">");
                }
                buf.append("<tr>");
                buf.append("<td>").append((String)attributeName).append("</td>");
                buf.append("<td>").append(attrType).append("</td>");
                buf.append("<td>").append(attrMethod.getType().getName()).append("</td>");
                buf.append("<td>");
                if (attrType.equals(ATTRIBUTE_READ_AND_WRITE)) {
                    attrValue = this.getAttributeValue(service, attrMethod);
                    buf.append("<textarea name=\"value\" cols=\"40\" rows=\"2\">").append(attrValue).append("</textarea>");
                } else if (attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                    buf.append("<textarea name=\"value\" cols=\"40\" rows=\"2\">").append("</textarea>");
                } else {
                    attrValue = this.getAttributeValue(service, attrMethod);
                    buf.append("<textarea name=\"value\" readonly cols=\"40\" rows=\"2\">").append(attrValue).append("</textarea>");
                }
                buf.append("</td>");
                buf.append("<td>");
                if (attrType.equals(ATTRIBUTE_READ_AND_WRITE) || attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                    buf.append("<input type=\"submit\" value=\"apply\">");
                } else {
                    buf.append("\u3000");
                }
                buf.append("</td>");
                buf.append("</tr>");
                buf.append("</form>");
            }
            buf.append("</table>");
            buf.append("<p>");
            buf.append("<b>Methods</b><br>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr bgcolor=\"#cccccc\"><th rowspan=\"2\">method</th><th colspan=\"2\">arguments</th><th rowspan=\"2\">call</th></tr>");
            buf.append("<tr bgcolor=\"#cccccc\"><th>value</th><th>type</th></tr>");
            for (i = 0; i < sigs.length; ++i) {
                int j;
                int max;
                buf.append("<form name=\"").append(sigs[i]).append("\" action=\"").append(this.getCurrentPath(req)).append("\" method=\"POST\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"call\">");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\">");
                buf.append("<input type=\"hidden\" name=\"method\" value=\"").append(sigs[i]).append("\">");
                buf.append("<tr>");
                buf.append("<td>").append(sigs[i]).append("</td>");
                buf.append("<td>");
                Class<?>[] paramTypes = ((Method)methodMap.get(sigs[i])).getParameterTypes();
                if (paramTypes.length == 0) {
                    buf.append("\u3000");
                } else {
                    max = paramTypes.length;
                    for (j = 0; j < max; ++j) {
                        buf.append("<textarea name=\"args\" cols=\"40\" rows=\"2\"></textarea>");
                        if (j == max - 1) continue;
                        buf.append("<br>");
                    }
                }
                buf.append("</td>");
                buf.append("<td>");
                if (paramTypes.length == 0) {
                    buf.append("\u3000");
                } else {
                    max = paramTypes.length;
                    for (j = 0; j < max; ++j) {
                        buf.append("<input type=\"text\" name=\"argTypes\">");
                        if (j == max - 1) continue;
                        buf.append("<br>");
                    }
                }
                buf.append("</td>");
                buf.append("<td>").append("<input type=\"submit\" value=\"call\">").append("</td>");
                buf.append("</tr>");
                buf.append("</form>");
            }
            buf.append("</table>");
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("/");
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">ServiceManager</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processGetAttributeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = null;
        try {
            service = ServiceManagerFactory.getService(serviceName);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        if (service == null) {
            resp.sendError(404);
            return;
        }
        String attributeName = req.getParameter("attribute");
        if (attributeName == null) {
            resp.sendError(400);
            return;
        }
        AttributeMethod attrMethod = this.getAttribute(this.getTargetObject(service).getClass(), attributeName);
        if (attrMethod == null || this.getAttributeType(attrMethod).equals(ATTRIBUTE_WRITE_ONLY)) {
            resp.sendError(404);
            return;
        }
        StringBuffer buf = new StringBuffer();
        if (!"json".equals(responseType)) {
            resp.sendError(404);
            return;
        }
        resp.setContentType("application/json;charset=UTF-8");
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("value", this.getAttributeValue(service, attrMethod));
        buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(json)));
        resp.getWriter().println(buf.toString());
    }

    protected void processSetAttributeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = null;
        try {
            service = ServiceManagerFactory.getService(serviceName);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        if (service == null) {
            resp.sendError(404);
            return;
        }
        String method = req.getParameter("method");
        String attributeValueStr = req.getParameter("value");
        String result = null;
        if (method == null) {
            String attributeName = req.getParameter("attribute");
            if (attributeName == null) {
                resp.sendError(400);
                return;
            }
            AttributeMethod attrMethod = this.getAttribute(this.getTargetObject(service).getClass(), attributeName);
            if (attrMethod == null || this.getAttributeType(attrMethod).equals(ATTRIBUTE_READ_ONLY)) {
                resp.sendError(404);
                return;
            }
            result = this.setAttributeValue(service, attrMethod.getSetter(), attributeValueStr);
        } else {
            result = this.setAttributeValue(service, method, attributeValueStr);
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("result", result);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(json)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus Set Attribute</title></head>");
            buf.append("<body>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("/");
            StringBuffer url = new StringBuffer();
            url.append(this.getCurrentPath(req)).append("?action=manager&name=").append(serviceName.getServiceManagerName());
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">ServiceManager</a>");
            buf.append("/");
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8"));
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">Service</a>");
            buf.append("<hr>");
            buf.append("<pre>").append(result).append("</pre>");
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("/");
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=manager&name=").append(serviceName.getServiceManagerName());
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">ServiceManager</a>");
            buf.append("/");
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8"));
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">Service</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processCallOperationResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = null;
        try {
            service = ServiceManagerFactory.getService(serviceName);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        if (service == null) {
            resp.sendError(404);
            return;
        }
        String methodStr = req.getParameter("method");
        String[] argsStr = req.getParameterValues("args");
        String[] argTypesStr = req.getParameterValues("argTypes");
        if (methodStr == null) {
            resp.sendError(400);
            return;
        }
        Object ret = null;
        Exception exception = null;
        Method method = null;
        try {
            Object targetObj = this.getTargetObject(service);
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            MethodSignature signature = new MethodSignature(methodStr);
            method = signature.getMethod(targetObj);
            Class<?>[] paramTypes = method.getParameterTypes();
            Object[] params = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> editType = paramTypes[i];
                if (argTypesStr[i] != null && argTypesStr[i].length() != 0) {
                    try {
                        editType = Class.forName(argTypesStr[i], true, loader);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (argsStr[i] == null || argsStr[i].equals("null")) {
                    params[i] = null;
                    continue;
                }
                PropertyEditor propEditor = this.findEditor(service, editType);
                if (propEditor == null) {
                    if (paramTypes[i].equals(class$java$lang$Object == null ? ServiceManagerFactoryServlet.class$("java.lang.Object") : class$java$lang$Object)) {
                        params[i] = argsStr[i];
                        continue;
                    }
                    throw new IllegalArgumentException("PropertyEditor for " + paramTypes[i] + " not found.");
                }
                if (argsStr.length > i) {
                    propEditor.setAsText(argsStr[i]);
                    params[i] = propEditor.getValue();
                    continue;
                }
                params[i] = null;
            }
            ret = method.invoke(targetObj, params);
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            StringWriter result = new StringWriter();
            PrintWriter writer = new PrintWriter(result);
            if (exception == null) {
                writer.print("Success!!");
            } else {
                writer.println("Failed!!");
                exception.printStackTrace(writer);
            }
            json.put("result", result.toString());
            json.put("return", ret);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(json)));
        } else {
            StringWriter result = new StringWriter();
            PrintWriter writer = new PrintWriter(result);
            if (exception == null) {
                writer.println("Success!!");
                Class<?> retType = method.getReturnType();
                if (!retType.equals(Void.TYPE)) {
                    PropertyEditor propEditor = this.findEditor(service, retType);
                    if (propEditor == null) {
                        writer.println(ret);
                    } else {
                        propEditor.setValue(ret);
                        writer.println(propEditor.getValue());
                    }
                }
            } else {
                writer.println("Failed!!");
                exception.printStackTrace(writer);
            }
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus Call Method</title></head>");
            buf.append("<body>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("/");
            StringBuffer url = new StringBuffer();
            url.append(this.getCurrentPath(req)).append("?action=manager&name=").append(serviceName.getServiceManagerName());
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">ServiceManager</a>");
            buf.append("/");
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8"));
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">Service</a>");
            buf.append("<hr>");
            buf.append("<pre>").append(result).append("</pre>");
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">ServiceManagerFactory</a>");
            buf.append("/");
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=manager&name=").append(serviceName.getServiceManagerName());
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">ServiceManager</a>");
            buf.append("/");
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8"));
            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">Service</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    private String setAttributeValue(Service service, Method method, String value) {
        Object targetObj = this.getTargetObject(service);
        try {
            Class<?>[] paramTypes = method.getParameterTypes();
            PropertyEditor editor = this.findEditor(service, paramTypes[0]);
            Object[] params = null;
            if (editor == null) {
                return "Failed!! PropertyEditor " + paramTypes[0] + " not found.";
            }
            if (value == null || value.equals("null")) {
                params = new Object[]{null};
            } else {
                editor.setAsText(value);
                params = new Object[]{editor.getValue()};
            }
            method.invoke(targetObj, params);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            return sw.toString();
        }
        return "Success!!";
    }

    private String setAttributeValue(Service service, String methodStr, String value) {
        Object targetObj = this.getTargetObject(service);
        try {
            MethodSignature signature = new MethodSignature(methodStr);
            Method method = signature.getMethod(targetObj);
            return this.setAttributeValue(service, method, value);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            return sw.toString();
        }
    }

    private PropertyEditor findEditor(Service service, Class type) {
        PropertyEditor editor = null;
        if (service instanceof ServiceManager) {
            ServiceLoader loader;
            Iterator loaders = ((ServiceManager)service).getServiceLoaders().iterator();
            while (loaders.hasNext() && (editor = (loader = (ServiceLoader)loaders.next()).findEditor(type)) == null) {
            }
        } else {
            ServiceMetaData metaData = null;
            try {
                metaData = ServiceManagerFactory.getServiceMetaData(service.getServiceManagerName(), service.getServiceName());
            }
            catch (ServiceNotFoundException e) {
                // empty catch block
            }
            if (metaData == null) {
                editor = NimbusPropertyEditorManager.findEditor(type);
            } else {
                ServiceLoader loader = metaData.getServiceLoader();
                editor = loader.findEditor(type);
            }
        }
        return editor;
    }

    private String getAttributeValue(Service service, AttributeMethod method) {
        Object targetObj = this.getTargetObject(service);
        String result = null;
        try {
            Object val = method.getGetter().invoke(targetObj, (Object[])null);
            if (val == null) {
                return null;
            }
            PropertyEditor editor = this.findEditor(service, method.getGetter().getReturnType());
            if (editor == null) {
                return val.toString();
            }
            editor.setValue(val);
            result = editor.getAsText();
            if (result == null) {
                return null;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (ServiceNotFoundException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        return result;
    }

    private AttributeMethod getAttribute(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        return (AttributeMethod)this.getAttributes(methods).get(name);
    }

    private Map getAttributes(Method[] methods) {
        HashMap<String, AttributeMethod> result = new HashMap<String, AttributeMethod>();
        for (int i = 0; i < methods.length; ++i) {
            if (this.isIgnoreMethod(methods[i])) continue;
            String methodName = methods[i].getName();
            Class<?> retType = methods[i].getReturnType();
            Class[] paramTypes = methods[i].getParameterTypes();
            if (!this.isAttributeMethod(methods[i])) continue;
            boolean isAttributeSet = false;
            boolean isAttributeGet = false;
            isAttributeSet = this.isAttributeSetMethod(methodName, retType, paramTypes);
            if (!isAttributeSet && !(isAttributeGet = this.isAttributeGetMethod(methodName, retType, paramTypes))) {
                isAttributeGet = this.isAttributeIsMethod(methodName, retType, paramTypes);
            }
            if (!isAttributeSet && !isAttributeGet) continue;
            String attrName = this.getAttributeName(methodName);
            AttributeMethod attrMethod = null;
            if (result.containsKey(attrName)) {
                attrMethod = (AttributeMethod)result.get(attrName);
            } else {
                attrMethod = new AttributeMethod();
                result.put(attrName, attrMethod);
            }
            if (isAttributeSet) {
                attrMethod.setSetter(methods[i]);
                continue;
            }
            attrMethod.setGetter(methods[i]);
        }
        return result;
    }

    private boolean isAttributeMethod(Method method) {
        Class[] paramTypes;
        Class<?> retType;
        String methodName = method.getName();
        return this.isAttributeGetMethod(methodName, retType = method.getReturnType(), paramTypes = method.getParameterTypes()) || this.isAttributeIsMethod(methodName, retType, paramTypes) || this.isAttributeSetMethod(methodName, retType, paramTypes);
    }

    private boolean isAttributeGetMethod(String methodName, Class retType, Class[] paramTypes) {
        return methodName.startsWith("get") && methodName.length() > 3 && !retType.equals(Void.TYPE) && paramTypes.length == 0;
    }

    private boolean isAttributeIsMethod(String methodName, Class retType, Class[] paramTypes) {
        return methodName.startsWith("is") && methodName.length() > 2 && retType.equals(Boolean.TYPE) && paramTypes.length == 0;
    }

    private boolean isAttributeSetMethod(String methodName, Class retType, Class[] paramTypes) {
        return methodName.startsWith("set") && methodName.length() > 3 && retType.equals(Void.TYPE) && paramTypes.length == 1;
    }

    private String getAttributeName(String methodName) {
        int length = methodName.length();
        if (methodName.startsWith("get") && length > 3) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("is") && length > 2) {
            return methodName.substring(2);
        }
        if (methodName.startsWith("set") && length > 3) {
            return methodName.substring(3);
        }
        return null;
    }

    private String getAttributeType(AttributeMethod method) {
        boolean hasGetter;
        boolean hasSetter = method.getSetter() != null;
        boolean bl = hasGetter = method.getGetter() != null;
        if (hasSetter && hasGetter) {
            return ATTRIBUTE_READ_AND_WRITE;
        }
        if (hasSetter) {
            return ATTRIBUTE_WRITE_ONLY;
        }
        return ATTRIBUTE_READ_ONLY;
    }

    private boolean isIgnoreMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(Object.class)) {
            return true;
        }
        if (this.ignoreMethodMap == null) {
            return false;
        }
        List ignoreMethods = this.ignoreMethodMap.getValueList(declaringClass);
        if (ignoreMethods == null || ignoreMethods.size() == 0) {
            return false;
        }
        int imax = ignoreMethods.size();
        for (int i = 0; i < imax; ++i) {
            Method ignoreMethod = (Method)ignoreMethods.get(i);
            if (ignoreMethod.equals(method)) {
                return true;
            }
            if (!ignoreMethod.getName().equals(method.getName()) || ignoreMethod.getParameterTypes().length != method.getParameterTypes().length || !ignoreMethod.getReturnType().equals(method.getReturnType())) continue;
            Class<?>[] ignoreParamTypes = ignoreMethod.getParameterTypes();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (ignoreParamTypes.length == 0) {
                return true;
            }
            boolean isMatch = true;
            for (int j = 0; j < ignoreParamTypes.length; ++j) {
                if (ignoreParamTypes[j].equals(paramTypes[j])) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        String[] servicePaths = this.getServicePaths();
        if (servicePaths != null && servicePaths.length != 0) {
            int i = servicePaths.length;
            while (--i >= 0) {
                ServiceManagerFactory.unloadManager(servicePaths[i]);
            }
        }
    }

    static {
        ArrayList<Method> methods = new ArrayList<Method>();
        try {
            methods.add(Semaphore.class.getMethod("getResource", null));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(Semaphore.class.getMethod("getResource", Integer.TYPE));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(Semaphore.class.getMethod("getResource", Long.TYPE));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(Semaphore.class.getMethod("getResource", Long.TYPE, Integer.TYPE));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(Semaphore.class.getMethod("getResource", Long.TYPE, Integer.TYPE, Long.TYPE));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(ResourceFactory.class.getMethod("makeResource", String.class));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(ConnectionFactory.class.getMethod("getConnection", null));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(JMSConnectionFactory.class.getMethod("getConnection", null));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(JMSConnectionFactory.class.getMethod("getConnection", String.class, String.class));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(JMSSessionFactory.class.getMethod("getSession", null));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(JMSSessionFactory.class.getMethod("getSession", Boolean.TYPE, Integer.TYPE));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(JMSSessionFactory.class.getMethod("getSession", Connection.class));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(JMSSessionFactory.class.getMethod("getSession", Connection.class, Boolean.TYPE, Integer.TYPE));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            methods.add(ResourceFactory.class.getMethod("makeResource", String.class));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (methods.size() != 0) {
            DEFAULT_IGNORE_METHODS = methods.toArray(new Method[methods.size()]);
        }
    }

    private class MethodSignature
    implements Comparable {
        private String methodName;
        private Class[] paramTypes;

        public MethodSignature(Method method) {
            this.methodName = method.getName();
            this.paramTypes = method.getParameterTypes();
        }

        public MethodSignature(String method) throws IllegalArgumentException, ClassNotFoundException {
            String tmp = method;
            int index = tmp.indexOf(40);
            if (index == -1 || index == 0 || index == tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            this.methodName = tmp.substring(0, index);
            if ((index = (tmp = tmp.substring(index + 1)).indexOf(41)) == -1 || index != tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            if (index == 0) {
                this.paramTypes = null;
            } else {
                tmp = tmp.substring(0, index);
                StringTokenizer tokens = new StringTokenizer(tmp, ",");
                ArrayList<Class<Boolean>> paramTypeList = new ArrayList<Class<Boolean>>();
                NimbusClassLoader loader = NimbusClassLoader.getInstance();
                while (tokens.hasMoreTokens()) {
                    String paramTypeStr = tokens.nextToken().trim();
                    if (paramTypeStr.length() == 0) {
                        throw new IllegalArgumentException("Invalid method : " + method);
                    }
                    Class<Serializable> paramType = null;
                    paramType = paramTypeStr.equals("boolean") ? Boolean.TYPE : (paramTypeStr.equals("byte") ? Byte.TYPE : (paramTypeStr.equals("char") ? Character.TYPE : (paramTypeStr.equals("short") ? Short.TYPE : (paramTypeStr.equals("int") ? Integer.TYPE : (paramTypeStr.equals("long") ? Long.TYPE : (paramTypeStr.equals("float") ? Float.TYPE : (paramTypeStr.equals("double") ? Double.TYPE : Class.forName(paramTypeStr, true, loader))))))));
                    paramTypeList.add(paramType);
                }
                this.paramTypes = paramTypeList.toArray(new Class[paramTypeList.size()]);
            }
        }

        public Method getMethod(Object obj) throws NoSuchMethodException {
            return obj.getClass().getMethod(this.methodName, this.paramTypes);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof MethodSignature) {
                MethodSignature comp = (MethodSignature)o;
                if (!this.methodName.equals(comp.methodName)) {
                    return false;
                }
                if (this.paramTypes == comp.paramTypes) {
                    return true;
                }
                if (this.paramTypes == null && comp.paramTypes != null || this.paramTypes != null && comp.paramTypes == null || this.paramTypes.length != comp.paramTypes.length) {
                    return false;
                }
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    if (this.paramTypes[i].equals(comp.paramTypes[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.methodName.hashCode();
            if (this.paramTypes != null) {
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    hashCode += this.paramTypes[i].hashCode();
                }
            }
            return hashCode;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.methodName);
            buf.append('(');
            if (this.paramTypes != null) {
                int max = this.paramTypes.length;
                for (int i = 0; i < max; ++i) {
                    buf.append(this.paramTypes[i].getName());
                    if (i == max - 1) continue;
                    buf.append(',');
                }
            }
            buf.append(')');
            return buf.toString();
        }

        public int compareTo(Object obj) {
            if (obj instanceof MethodSignature) {
                MethodSignature sig = (MethodSignature)obj;
                if (this.methodName.equals(sig.methodName)) {
                    if (this.paramTypes == null) {
                        if (sig.paramTypes == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (sig.paramTypes == null) {
                        return 1;
                    }
                    if (this.paramTypes.length == sig.paramTypes.length) {
                        for (int i = 0; i < this.paramTypes.length; ++i) {
                            int ret = this.paramTypes[i].getName().compareTo(sig.paramTypes[i].getName());
                            if (ret == 0) continue;
                            return ret;
                        }
                        return 0;
                    }
                    return this.paramTypes.length > sig.paramTypes.length ? 1 : -1;
                }
                return this.methodName.compareTo(sig.methodName);
            }
            return -1;
        }
    }

    private class AttributeMethod {
        private Method getterMethod;
        private Method setterMethod;
        private Class attributeType;

        private AttributeMethod() {
        }

        public void setGetter(Method getter) {
            this.getterMethod = getter;
            if (getter != null && this.attributeType == null) {
                this.attributeType = getter.getReturnType();
            }
        }

        public Method getGetter() {
            return this.getterMethod;
        }

        public void setSetter(Method setter) {
            this.setterMethod = setter;
            if (setter != null && this.attributeType == null) {
                this.attributeType = setter.getParameterTypes()[0];
            }
        }

        public Method getSetter() {
            return this.setterMethod;
        }

        public Class getType() {
            return this.attributeType;
        }
    }
}

