/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sequence;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.sequence.NumberSequenceServiceMBean;
import jp.ossc.nimbus.service.sequence.Sequence;

public class NumberSequenceService
extends ServiceBase
implements Sequence,
NumberSequenceServiceMBean {
    private static final long serialVersionUID = 7700067543446331974L;
    private long initialValue;
    private long minValue;
    private long maxValue;
    private long incrementValue = 1L;
    private long currentValue;
    private String format;
    private NumberFormat numberFormat;
    private NumberFormat currentFormat;

    public void setInitialValue(long value) {
        this.initialValue = value;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public void setMinValue(long value) {
        this.minValue = value;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(long value) {
        this.maxValue = value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setIncrementValue(long value) {
        this.incrementValue = value;
    }

    public long getIncrementValue() {
        return this.incrementValue;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setNumberFormat(NumberFormat format) {
        this.numberFormat = format;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public synchronized long getCurrentValue() {
        return this.currentValue;
    }

    public void startService() throws Exception {
        if (this.minValue > this.maxValue) {
            throw new IllegalArgumentException("MinValue > MaxValue");
        }
        if (this.incrementValue >= 0L && (this.initialValue > this.maxValue || this.initialValue < this.minValue && this.initialValue + this.incrementValue < this.minValue) || this.incrementValue < 0L && (this.initialValue < this.minValue || this.initialValue > this.maxValue && this.initialValue + this.incrementValue > this.maxValue)) {
            throw new IllegalArgumentException("InitialValue is illegal : " + this.initialValue);
        }
        if (this.numberFormat != null) {
            this.currentFormat = this.numberFormat;
        } else if (this.format != null) {
            this.currentFormat = new DecimalFormat(this.format);
        }
        this.currentValue = this.initialValue;
    }

    public synchronized String increment() {
        this.currentValue = this.incrementValue >= 0L ? (this.currentValue < this.maxValue ? (this.currentValue += this.incrementValue) : (this.initialValue < this.minValue ? this.initialValue + this.incrementValue : this.minValue)) : (this.currentValue > this.minValue ? (this.currentValue += this.incrementValue) : (this.initialValue > this.maxValue ? this.initialValue + this.incrementValue : this.maxValue));
        if (this.currentFormat != null) {
            return this.currentFormat.format(this.currentValue);
        }
        return String.valueOf(this.currentValue);
    }

    public String getInitial() {
        long inital = 0L;
        inital = this.incrementValue >= 0L ? (this.initialValue < this.minValue ? this.initialValue + this.incrementValue : this.initialValue) : (this.initialValue > this.maxValue ? this.initialValue + this.incrementValue : this.initialValue);
        if (this.currentFormat != null) {
            return this.currentFormat.format(inital);
        }
        return String.valueOf(inital);
    }

    public synchronized void reset() {
        this.currentValue = this.initialValue;
    }

    public synchronized String getCurrent() {
        if (this.currentFormat != null) {
            return this.currentFormat.format(this.currentValue);
        }
        return String.valueOf(this.currentValue);
    }
}

