/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scp.ganymed;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.scp.SCPClient;
import jp.ossc.nimbus.service.scp.SCPException;

public class SCPClientImpl
implements SCPClient {
    private int connectionTimeout;
    private int keyExchangeTimeout;
    private Boolean isTcpNoDelay;
    private String[] serverHostKeyAlgorithms;
    private File homeDir;
    private Connection connection;
    private ch.ethz.ssh2.SCPClient scpClient;

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setKeyExchangeTimeout(int timeout) {
        this.keyExchangeTimeout = timeout;
    }

    public int getKeyExchangeTimeout() {
        return this.keyExchangeTimeout;
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.isTcpNoDelay = noDelay ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isTcpNoDelay() {
        return this.isTcpNoDelay == null ? false : this.isTcpNoDelay;
    }

    public void setServerHostKeyAlgorithms(String[] algos) {
        this.serverHostKeyAlgorithms = algos;
    }

    public String[] getServerHostKeyAlgorithms() {
        return this.serverHostKeyAlgorithms;
    }

    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public void connect(String user, String host, String password) throws SCPException {
        this.connect(user, host, 22, password);
    }

    public void connect(String user, String host, int port, String password) throws SCPException {
        if (this.connection != null) {
            throw new SCPException("It is already connected!");
        }
        this.connection = new Connection(host, port);
        try {
            if (this.isTcpNoDelay != null) {
                this.connection.setTCPNoDelay(this.isTcpNoDelay.booleanValue());
            }
            if (this.serverHostKeyAlgorithms != null) {
                this.connection.setServerHostKeyAlgorithms(this.serverHostKeyAlgorithms);
            }
            this.connection.connect(null, this.connectionTimeout, this.keyExchangeTimeout);
            if (!this.connection.authenticateWithPassword(user, password)) {
                throw new SCPException("It failed to authenticate!");
            }
            this.scpClient = this.connection.createSCPClient();
        }
        catch (IOException e) {
            this.scpClient = null;
            this.connection.close();
            this.connection = null;
            throw new SCPException("It failed to connect!", e);
        }
    }

    public void connect(String user, String host, File pemFile, String passphrase) throws SCPException {
        this.connect(user, host, 22, pemFile, passphrase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String user, String host, int port, File pemFile, String passphrase) throws SCPException {
        String pem;
        block15: {
            if (this.connection != null) {
                throw new SCPException("It is already connected!");
            }
            if (!pemFile.exists()) {
                throw new SCPException("The pemFile not exists! path=" + pemFile);
            }
            FileInputStream fis = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            pem = null;
            try {
                try {
                    fis = new FileInputStream(pemFile);
                    int length = 0;
                    byte[] buf = new byte[1024];
                    while ((length = fis.read(buf)) != -1) {
                        baos.write(buf, 0, length);
                    }
                    pem = new String(baos.toByteArray());
                }
                catch (IOException e) {
                    throw new SCPException("It failed to read pemFile! path=" + pemFile, e);
                }
                Object var12_13 = null;
                if (fis == null) break block15;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            fis.close();
        }
        this.connection = new Connection(host, port);
        try {
            if (this.isTcpNoDelay != null) {
                this.connection.setTCPNoDelay(this.isTcpNoDelay.booleanValue());
            }
            if (this.serverHostKeyAlgorithms != null) {
                this.connection.setServerHostKeyAlgorithms(this.serverHostKeyAlgorithms);
            }
            this.connection.connect(null, this.connectionTimeout, this.keyExchangeTimeout);
            if (!this.connection.authenticateWithPublicKey(user, pem.toCharArray(), passphrase)) {
                throw new SCPException("It failed to authenticate!");
            }
            this.scpClient = this.connection.createSCPClient();
            return;
        }
        catch (IOException e) {
            this.scpClient = null;
            this.connection.close();
            this.connection = null;
            throw new SCPException("It failed to authenticate!", e);
        }
    }

    public File get(String remote) throws SCPException {
        if (this.connection == null) {
            throw new SCPException("Connection is not established!");
        }
        if (this.scpClient == null) {
            throw new SCPException("It is not authenticated!");
        }
        File localFile = null;
        try {
            File file = new File(remote);
            String name = file.getName();
            localFile = this.homeDir == null ? new File(name) : new File(this.homeDir, name);
            this.scpClient.get(remote, this.homeDir == null ? "." : this.homeDir.getPath());
        }
        catch (IOException e) {
            throw new SCPException("It failed to get! file=" + remote, e);
        }
        return localFile;
    }

    public File get(String remote, String local) throws SCPException {
        if (this.connection == null) {
            throw new SCPException("Connection is not established!");
        }
        if (this.scpClient == null) {
            throw new SCPException("It is not authenticated!");
        }
        File localFile = null;
        try {
            localFile = new File(local);
            if (this.homeDir != null && !localFile.isAbsolute()) {
                localFile = new File(this.homeDir, local);
            }
            String targetDir = localFile.getParentFile() == null ? "." : localFile.getParentFile().getPath();
            this.scpClient.get(remote, targetDir);
            File remoteFile = new File(remote);
            String name = remoteFile.getName();
            File getFile = new File(targetDir, name);
            if (!getFile.equals(localFile) && !getFile.renameTo(localFile)) {
                getFile.delete();
                throw new SCPException("Can not write to directory! dir=" + targetDir);
            }
        }
        catch (IOException e) {
            throw new SCPException("It failed to get! file=" + remote, e);
        }
        return localFile;
    }

    public File[] mget(String remote) throws SCPException {
        return this.mget(remote, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] mget(String remote, String localDir) throws SCPException {
        if (remote == null || remote.length() == 0) {
            throw new SCPException("Path is null.");
        }
        if (localDir == null) {
            localDir = ".";
        }
        File localDirFile = new File(localDir);
        if (this.homeDir != null && !localDirFile.isAbsolute()) {
            localDirFile = new File(this.homeDir, localDir);
        }
        ArrayList<File> localFiles = new ArrayList<File>();
        Session session = null;
        String cmd = "scp -f " + remote;
        File localFile = null;
        try {
            session = this.connection.openSession();
            session.execCommand(cmd);
            byte[] buf = new byte[1024];
            BufferedOutputStream os = new BufferedOutputStream(session.getStdin(), 512);
            BufferedInputStream is = new BufferedInputStream(session.getStdout(), 40000);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            while (true) {
                int c;
                if ((c = this.checkAck(is)) == -1) {
                    if (localFiles.size() == 0) {
                        throw new IOException("Remote SCP terminated unexpectedly.");
                    }
                    break;
                }
                if (c != 67) {
                    break;
                }
                ((InputStream)is).read(buf, 0, 5);
                long fileSize = 0L;
                while (true) {
                    if (((InputStream)is).read(buf, 0, 1) < 0) {
                        throw new SCPException("Unexpected EOF.");
                    }
                    if (buf[0] == 32) break;
                    fileSize = fileSize * 10L + (long)(buf[0] - 48);
                }
                String fileName = null;
                int i = 0;
                while (true) {
                    ((InputStream)is).read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                fileName = new String(buf, 0, i);
                buf[0] = 0;
                ((OutputStream)os).write(buf, 0, 1);
                ((OutputStream)os).flush();
                localFile = new File(localDirFile, fileName);
                localFiles.add(localFile);
                FileOutputStream fos = new FileOutputStream(localFile);
                try {
                    int readLen = 0;
                    do {
                        readLen = (long)buf.length < fileSize ? buf.length : (int)fileSize;
                        if ((readLen = ((InputStream)is).read(buf, 0, readLen)) < 0) {
                            throw new SCPException("Unexpected EOF.");
                        }
                        fos.write(buf, 0, readLen);
                    } while ((fileSize -= (long)readLen) != 0L);
                }
                finally {
                    fos.close();
                    fos = null;
                }
                this.checkAck(is);
                localFile = null;
                buf[0] = 0;
                ((OutputStream)os).write(buf, 0, 1);
                ((OutputStream)os).flush();
            }
        }
        catch (IOException e) {
            throw new SCPException("It failed to mget! from=" + remote + ", to=" + (localFile == null ? localDirFile : localFile), e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return localFiles.toArray(new File[localFiles.size()]);
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            throw new IOException("Remote SCP error: " + sb.toString());
        }
        return b;
    }

    public void put(String local) throws SCPException {
        if (this.connection == null) {
            throw new SCPException("Connection is not established!");
        }
        if (this.scpClient == null) {
            throw new SCPException("It is not authenticated!");
        }
        File localFile = null;
        try {
            localFile = new File(local);
            if (this.homeDir != null && !localFile.isAbsolute()) {
                localFile = new File(this.homeDir, local);
            }
            if (!localFile.exists()) {
                throw new SCPException("File not exists! path=" + local);
            }
            this.scpClient.put(localFile.getPath(), ".");
        }
        catch (IOException e) {
            throw new SCPException("It failed to put! file=" + localFile, e);
        }
    }

    public void put(String local, String remote) throws SCPException {
        this.put(local, remote, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String local, String remote, String mode) throws SCPException {
        if (this.connection == null) {
            throw new SCPException("Connection is not established!");
        }
        if (this.scpClient == null) {
            throw new SCPException("It is not authenticated!");
        }
        File localFile = null;
        try {
            ByteArrayOutputStream baos;
            File remoteFile;
            block17: {
                localFile = new File(local);
                if (this.homeDir != null && !localFile.isAbsolute()) {
                    localFile = new File(this.homeDir, local);
                }
                if (!localFile.exists()) {
                    throw new SCPException("File not exists! path=" + local);
                }
                remoteFile = new File(remote);
                if (localFile.getName().equals(remoteFile.getName())) {
                    if (mode == null) {
                        this.scpClient.put(localFile.getPath(), remoteFile.getParentFile() == null ? "." : remoteFile.getParentFile().getPath());
                        return;
                    }
                    this.scpClient.put(localFile.getPath(), remoteFile.getParentFile() == null ? "." : remoteFile.getParentFile().getPath(), mode);
                    return;
                }
                FileInputStream fis = null;
                baos = new ByteArrayOutputStream();
                try {
                    try {
                        fis = new FileInputStream(localFile);
                        int length = 0;
                        byte[] buf = new byte[1024];
                        while ((length = fis.read(buf)) != -1) {
                            baos.write(buf, 0, length);
                        }
                        Object var11_12 = null;
                        if (fis == null) break block17;
                    }
                    catch (IOException e) {
                        throw new SCPException("It failed to read path=" + localFile, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                fis.close();
            }
            if (mode == null) {
                this.scpClient.put(baos.toByteArray(), remoteFile.getName(), remoteFile.getParentFile() == null ? "." : remoteFile.getParentFile().getPath());
                return;
            }
            this.scpClient.put(baos.toByteArray(), remoteFile.getName(), remoteFile.getParentFile() == null ? "." : remoteFile.getParentFile().getPath(), mode);
            return;
        }
        catch (IOException e) {
            throw new SCPException("It failed to put! file=" + localFile, e);
        }
    }

    public void mput(String local) throws SCPException {
        this.mput(local, ".");
    }

    public void mput(String local, String remoteDir) throws SCPException {
        this.mput(local, remoteDir, null);
    }

    public void mput(String local, String remoteDir, String mode) throws SCPException {
        if (this.connection == null) {
            throw new SCPException("Connection is not established!");
        }
        if (this.scpClient == null) {
            throw new SCPException("It is not authenticated!");
        }
        RecurciveSearchFile rsf = new RecurciveSearchFile(".");
        File[] localFiles = rsf.listAllTreeFiles(local);
        try {
            for (int i = 0; i < localFiles.length; ++i) {
                if (mode == null) {
                    this.scpClient.put(localFiles[i].getPath(), remoteDir);
                    continue;
                }
                this.scpClient.put(localFiles[i].getPath(), remoteDir, mode);
            }
        }
        catch (IOException e) {
            throw new SCPException("It failed to mput! local=" + local, e);
        }
    }

    public void close() throws SCPException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.scpClient = null;
    }
}

