/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scp.ClusterSCPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.scp.SCPClient;
import jp.ossc.nimbus.service.scp.SCPClientFactory;
import jp.ossc.nimbus.service.scp.SCPException;

public class ClusterSCPClientFactoryService
extends ServiceBase
implements SCPClientFactory,
ClusterSCPClientFactoryServiceMBean {
    private static final long serialVersionUID = 8518162690689754186L;
    private ServiceName[] scpClientFactoryServiceNames;
    private SCPClientFactory[] scpClientFactories;
    private int clusterMode = 1;
    private String connectErrorMessageId = "CSCP_00001";
    private String skipMessageId = "CSCP_00002";

    public void setSCPClientFactoryServiceNames(ServiceName[] names) {
        this.scpClientFactoryServiceNames = names;
    }

    public ServiceName[] getSCPClientFactoryServiceNames() {
        return this.scpClientFactoryServiceNames;
    }

    public void setClusterMode(int mode) throws IllegalArgumentException {
        switch (this.clusterMode) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
        this.clusterMode = mode;
    }

    public int getClusterMode() {
        return this.clusterMode;
    }

    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    public String getConnectErrorMessageId() {
        return this.connectErrorMessageId;
    }

    public void setSkipMessageId(String id) {
        this.skipMessageId = id;
    }

    public String getSkipMessageId() {
        return this.skipMessageId;
    }

    public void startService() throws Exception {
        if (this.scpClientFactoryServiceNames == null || this.scpClientFactoryServiceNames.length == 0) {
            throw new IllegalArgumentException("SCPClientFactoryServiceNames is null.");
        }
        this.scpClientFactories = new SCPClientFactory[this.scpClientFactoryServiceNames.length];
        for (int i = 0; i < this.scpClientFactoryServiceNames.length; ++i) {
            this.scpClientFactories[i] = (SCPClientFactory)ServiceManagerFactory.getServiceObject(this.scpClientFactoryServiceNames[i]);
        }
    }

    public SCPClient createSCPClient() throws SCPException {
        return new ClusterSCPClient(this.clusterMode);
    }

    private class ClusterSCPClient
    implements SCPClient {
        private final int clusterMode;
        private SCPClient client;
        private List clients;
        private List noConnectedClients;

        public ClusterSCPClient(int mode) throws SCPException {
            this.clusterMode = mode;
            block2 : switch (this.clusterMode) {
                case 1: {
                    int imax = ClusterSCPClientFactoryService.this.scpClientFactories.length;
                    for (int i = 0; i < imax; ++i) {
                        try {
                            this.client = ClusterSCPClientFactoryService.this.scpClientFactories[i].createSCPClient();
                            break block2;
                        }
                        catch (SCPException e) {
                            if (i == imax - 1) {
                                throw e;
                            }
                            if (ClusterSCPClientFactoryService.this.connectErrorMessageId == null) continue;
                            ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.connectErrorMessageId, ClusterSCPClientFactoryService.this.scpClientFactories[i], (Throwable)e);
                            continue;
                        }
                    }
                    break;
                }
                case 2: {
                    this.clients = new ArrayList();
                    this.noConnectedClients = new ArrayList();
                    int imax = ClusterSCPClientFactoryService.this.scpClientFactories.length;
                    for (int i = 0; i < imax; ++i) {
                        try {
                            this.clients.add(ClusterSCPClientFactoryService.this.scpClientFactories[i].createSCPClient());
                            continue;
                        }
                        catch (SCPException e) {
                            ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.connectErrorMessageId, ClusterSCPClientFactoryService.this.scpClientFactories[i], (Throwable)e);
                            this.noConnectedClients.add(ClusterSCPClientFactoryService.this.scpClientFactories[i]);
                        }
                    }
                    if (this.clients.size() != 0) break;
                    throw new SCPException("I could not connect all the cluster members.");
                }
            }
        }

        public void connect(String user, String host, String password) throws SCPException {
            throw new UnsupportedOperationException();
        }

        public void connect(String user, String host, int port, String password) throws SCPException {
            throw new UnsupportedOperationException();
        }

        public void connect(String user, String host, File pemFile, String passphrase) throws SCPException {
            throw new UnsupportedOperationException();
        }

        public void connect(String user, String host, int port, File pemFile, String passphrase) throws SCPException {
            throw new UnsupportedOperationException();
        }

        public File get(String path) throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.get(path);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SCPClient client = (SCPClient)this.clients.get(i);
                try {
                    return client.get(path);
                }
                catch (SCPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        public File get(String remote, String local) throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.get(remote, local);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SCPClient client = (SCPClient)this.clients.get(i);
                try {
                    return client.get(remote, local);
                }
                catch (SCPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        public File[] mget(String remote) throws SCPException {
            return this.mget(remote, null);
        }

        public File[] mget(String remote, String localDir) throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.mget(remote, localDir);
                }
            }
            ArrayList<File> resultList = null;
            HashSet<File> resultSet = new HashSet<File>();
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SCPClient client = (SCPClient)this.clients.get(i);
                try {
                    File[] results = client.mget(remote, localDir);
                    for (int j = 0; j < results.length; ++j) {
                        File result = results[j];
                        if (resultSet.contains(result)) continue;
                        resultSet.add(result);
                        if (resultList == null) {
                            resultList = new ArrayList<File>();
                        }
                        resultList.add(result);
                    }
                    continue;
                }
                catch (SCPException e) {
                    if (i != imax - 1 || resultList != null) continue;
                    throw e;
                }
            }
            if (resultList == null) {
                return null;
            }
            Collections.sort(resultList);
            return resultList.toArray(new File[resultList.size()]);
        }

        public void put(String path) throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.put(path);
                    break;
                }
                case 2: {
                    SCPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SCPClient client = (SCPClient)this.clients.get(i);
                        try {
                            client.put(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SCPException e) {
                            if (ClusterSCPClientFactoryService.this.skipMessageId != null) {
                                ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.skipMessageId, new Object[]{client, "put"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSCPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "put"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void put(String local, String remote) throws SCPException {
            this.put(local, remote, null);
        }

        public void put(String local, String remote, String mode) throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.put(local, remote, mode);
                    break;
                }
                case 2: {
                    SCPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SCPClient client = (SCPClient)this.clients.get(i);
                        try {
                            client.put(local, remote, mode);
                            isSuccess = true;
                            continue;
                        }
                        catch (SCPException e) {
                            if (ClusterSCPClientFactoryService.this.skipMessageId != null) {
                                ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.skipMessageId, new Object[]{client, "put"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSCPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "put"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void mput(String local) throws SCPException {
            this.mput(local, ".");
        }

        public void mput(String local, String remoteDir) throws SCPException {
            this.mput(local, remoteDir, null);
        }

        public void mput(String local, String remoteDir, String mode) throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.mput(local, remoteDir, mode);
                    break;
                }
                case 2: {
                    SCPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SCPClient client = (SCPClient)this.clients.get(i);
                        try {
                            client.mput(local, remoteDir, mode);
                            isSuccess = true;
                            continue;
                        }
                        catch (SCPException e) {
                            if (ClusterSCPClientFactoryService.this.skipMessageId != null) {
                                ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.skipMessageId, new Object[]{client, "mput"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSCPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSCPClientFactoryService.this.getLogger().write(ClusterSCPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "mput"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void close() throws SCPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.close();
                    break;
                }
                case 2: {
                    SCPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SCPClient client = (SCPClient)this.clients.get(i);
                        try {
                            client.close();
                            continue;
                        }
                        catch (SCPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }
    }
}

