/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorStopException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.scheduler2.AbstractScheduleExecutorService;
import jp.ossc.nimbus.service.scheduler2.BeanFlowScheduleExecutorServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleExecutor;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;

public class BeanFlowScheduleExecutorService
extends AbstractScheduleExecutorService
implements ScheduleExecutor,
BeanFlowScheduleExecutorServiceMBean {
    private static final long serialVersionUID = 4412763751084029798L;
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected Map monitors;
    protected long controlStateChangingWaitInterval = 500L;
    protected long controlStateChangingWaitTimeout = -1L;

    public BeanFlowScheduleExecutorService() {
        this.type = "BEANFLOW";
    }

    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setControlStateChangingWaitInterval(long interval) {
        this.controlStateChangingWaitInterval = interval;
    }

    public long getControlStateChangingWaitInterval() {
        return this.controlStateChangingWaitInterval;
    }

    public void setControlStateChangingWaitTimeout(long timeout) {
        this.controlStateChangingWaitTimeout = timeout;
    }

    public long getControlStateChangingWaitTimeout() {
        return this.controlStateChangingWaitTimeout;
    }

    public void createService() throws Exception {
        this.monitors = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvokerFactory is null.");
        }
    }

    public void stopService() throws Exception {
        this.monitors.clear();
    }

    public void destroyService() throws Exception {
        this.monitors = null;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    protected void checkPreExecute(Schedule schedule) throws Exception {
        if (!this.beanFlowInvokerFactory.containsFlow(schedule.getTaskName())) {
            throw new IllegalArgumentException("BeanFlow is not found : " + schedule.getTaskName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schedule executeInternal(Schedule schedule) throws Throwable {
        BeanFlowInvoker invoker = this.getBeanFlowInvoker(schedule);
        BeanFlowMonitor monitor = null;
        Schedule result = schedule;
        try {
            monitor = invoker.createMonitor();
            this.monitors.put(schedule.getId(), monitor);
            Object ret = invoker.invokeFlow(schedule, monitor);
            if (ret instanceof Schedule) {
                result = (Schedule)ret;
            } else if (ret != null) {
                schedule.setOutput(ret);
            }
        }
        catch (BeanFlowMonitorStopException e) {
            result.setOutput(e);
            result.setState(7);
        }
        finally {
            this.monitors.remove(schedule.getId());
        }
        return result;
    }

    protected BeanFlowInvoker getBeanFlowInvoker(Schedule schedule) throws Throwable {
        return this.beanFlowInvokerFactory.createFlow(schedule.getTaskName());
    }

    public boolean controlState(String id, int cntrolState) throws ScheduleStateControlException {
        BeanFlowMonitor monitor = (BeanFlowMonitor)this.monitors.get(id);
        if (monitor == null) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        switch (cntrolState) {
            case 2: {
                if (monitor.isSuspend() || monitor.isEnd()) {
                    return false;
                }
                monitor.suspend();
                while (!monitor.isEnd() && !monitor.isSuspended()) {
                    if (this.controlStateChangingWaitTimeout > 0L && System.currentTimeMillis() - startTime > this.controlStateChangingWaitTimeout) {
                        throw new ScheduleStateControlException("State change timeout.");
                    }
                    try {
                        Thread.sleep(this.controlStateChangingWaitInterval);
                    }
                    catch (InterruptedException e) {
                        throw new ScheduleStateControlException(e);
                    }
                }
                if (monitor.isEnd()) {
                    return false;
                }
                this.getLogger().write("BFSE_00001", (Object)id);
                this.scheduleManager.changeState(id, 3, 6);
                break;
            }
            case 3: {
                if (!monitor.isSuspend()) {
                    return false;
                }
                monitor.resume();
                while (!monitor.isEnd() && monitor.isSuspended()) {
                    if (this.controlStateChangingWaitTimeout > 0L && System.currentTimeMillis() - startTime > this.controlStateChangingWaitTimeout) {
                        throw new ScheduleStateControlException("State change timeout.");
                    }
                    try {
                        Thread.sleep(this.controlStateChangingWaitInterval);
                    }
                    catch (InterruptedException e) {
                        throw new ScheduleStateControlException(e);
                    }
                }
                this.getLogger().write("BFSE_00002", (Object)id);
                if (monitor.isEnd()) {
                    return false;
                }
                this.scheduleManager.changeState(id, 6, 3);
                break;
            }
            case 4: {
                if (monitor.isStop()) {
                    return false;
                }
                monitor.stop();
                if (monitor.isSuspend()) {
                    monitor.resume();
                }
                while (!monitor.isEnd() && !monitor.isStopped()) {
                    if (this.controlStateChangingWaitTimeout > 0L && System.currentTimeMillis() - startTime > this.controlStateChangingWaitTimeout) {
                        throw new ScheduleStateControlException("State change timeout.");
                    }
                    try {
                        Thread.sleep(this.controlStateChangingWaitInterval);
                    }
                    catch (InterruptedException e) {
                        throw new ScheduleStateControlException(e);
                    }
                }
                if (monitor.isEnd() && !monitor.isStopped()) {
                    return false;
                }
                this.scheduleManager.changeState(id, 3, 7);
            }
        }
        return true;
    }
}

