/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.queue.DefaultQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class DefaultQueueService
extends ServiceBase
implements Queue,
CacheRemoveListener,
DefaultQueueServiceMBean,
Serializable {
    private static final long serialVersionUID = 4603365298600666516L;
    protected static final EmptyElement EMPTY = new EmptyElement();
    protected List queueElements;
    protected int initialCapacity = -1;
    protected int capacityIncrement = -1;
    protected ServiceName cacheServiceName;
    protected Cache cache;
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected SynchronizeMonitor pushMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor peekMonitor = new WaitSynchronizeMonitor();
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;
    protected long maxDepth = 0L;
    protected boolean isSafeGetOrder = true;
    protected Class synchronizeMonitorClass = WaitSynchronizeMonitor.class;

    public void setSynchronizeMonitorClass(Class clazz) {
        this.synchronizeMonitorClass = clazz;
    }

    public Class getSynchronizeMonitorClass() {
        return this.synchronizeMonitorClass;
    }

    public void setInitialCapacity(int initial) {
        this.initialCapacity = initial;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public void setCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    public ServiceName getCacheServiceName() {
        return this.cacheServiceName;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    public boolean isSafeGetOrder() {
        return this.isSafeGetOrder;
    }

    public void setSafeGetOrder(boolean isSafe) {
        this.isSafeGetOrder = isSafe;
    }

    public void startService() throws Exception {
        if (!WaitSynchronizeMonitor.class.equals(this.synchronizeMonitorClass)) {
            this.pushMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.getMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.peekMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
        }
        this.accept();
        if (this.queueElements == null) {
            this.queueElements = this.initialCapacity >= 0 ? (this.capacityIncrement >= 0 ? new Vector(this.initialCapacity, this.capacityIncrement) : Collections.synchronizedList(new ArrayList(this.initialCapacity))) : Collections.synchronizedList(new ArrayList());
        }
        if (this.cacheServiceName != null) {
            this.cache = (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName);
        }
    }

    public void stopService() throws Exception {
        this.release();
    }

    public void destroyService() throws Exception {
        this.queueElements.clear();
        this.queueElements = null;
        this.cache = null;
    }

    public void push(Object item) {
        this.push(item, -1L);
    }

    public boolean push(Object item, long timeout) {
        return this.pushElement(item, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushElement(Object element, long timeout) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        if (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            try {
                if (timeout == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (timeout < 0L) {
                    this.pushMonitor.initAndWaitMonitor();
                } else if (!this.pushMonitor.initAndWaitMonitor(timeout)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.pushMonitor.releaseMonitor();
            }
        }
        if (this.cache == null) {
            this.queueElements.add(element);
        } else {
            CachedReference ref = this.cache.add(element);
            if (ref != null) {
                ref.addCacheRemoveListener(this);
                this.queueElements.add(ref);
            } else {
                this.queueElements.add(element);
            }
        }
        int size = this.size();
        if ((long)size > this.maxDepth) {
            this.maxDepth = size;
        }
        ++this.count;
        ++this.countDelta;
        this.lastPushedTime = System.currentTimeMillis();
        this.peekMonitor.notifyAllMonitor();
        if (this.isSafeGetOrder) {
            this.getMonitor.notifyMonitor();
        } else {
            this.getMonitor.notifyAllMonitor();
        }
        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
            this.pushMonitor.notifyMonitor();
        }
        return true;
    }

    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        Object var6_4;
        block32: {
            Object object;
            block31: {
                Object var7_9;
                block30: {
                    long processTime = 0L;
                    try {
                        Object ret;
                        if (isRemove) {
                            this.getMonitor.initMonitor();
                        } else {
                            this.peekMonitor.initMonitor();
                        }
                        while (!this.fourceEndFlg) {
                            long proc;
                            block29: {
                                if (this.size() > 0) {
                                    if (!isRemove || !this.isSafeGetOrder || this.getMonitor.isFirst()) {
                                        ret = this.getQueueElement(isRemove);
                                        if (ret == EMPTY) continue;
                                        if (isRemove) {
                                            this.getMonitor.releaseMonitor();
                                        }
                                        if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                                            if (this.isSafeGetOrder) {
                                                this.getMonitor.notifyMonitor();
                                            } else {
                                                this.getMonitor.notifyAllMonitor();
                                            }
                                        }
                                        if (isRemove && this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
                                            this.pushMonitor.notifyMonitor();
                                        }
                                        Object object2 = ret;
                                        Object var11_11 = null;
                                        if (isRemove) {
                                            this.getMonitor.releaseMonitor();
                                            return object2;
                                        }
                                        this.peekMonitor.releaseMonitor();
                                        return object2;
                                    }
                                    if (this.getMonitor.isWait()) {
                                        this.getMonitor.notifyMonitor();
                                    }
                                }
                                if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                                proc = 0L;
                                if (timeOutMs >= 0L) {
                                    proc = System.currentTimeMillis();
                                }
                                try {
                                    long curSleepTime;
                                    long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                                    if (curSleepTime <= 0L || this.size() != 0 && isRemove && (!this.isSafeGetOrder || this.getMonitor.isFirst())) break block29;
                                    if (isRemove) {
                                        this.getMonitor.initAndWaitMonitor(curSleepTime);
                                    } else {
                                        this.peekMonitor.initAndWaitMonitor(curSleepTime);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Object var9_17 = null;
                                    Object var11_12 = null;
                                    if (isRemove) {
                                        this.getMonitor.releaseMonitor();
                                        return var9_17;
                                    }
                                    this.peekMonitor.releaseMonitor();
                                    return var9_17;
                                }
                            }
                            if (timeOutMs < 0L) continue;
                            proc = System.currentTimeMillis() - proc;
                            processTime += proc;
                        }
                        if (this.fourceEndFlg) {
                            ret = this.getQueueElement(isRemove);
                            if (ret == EMPTY) {
                                var7_9 = null;
                                break block30;
                            }
                            object = ret;
                            break block31;
                        }
                        if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                            if (this.isSafeGetOrder) {
                                this.getMonitor.notifyMonitor();
                            } else {
                                this.getMonitor.notifyAllMonitor();
                            }
                        }
                        var6_4 = null;
                        break block32;
                    }
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        if (isRemove) {
                            this.getMonitor.releaseMonitor();
                            throw throwable;
                        }
                        this.peekMonitor.releaseMonitor();
                        throw throwable;
                    }
                }
                Object var11_13 = null;
                if (isRemove) {
                    this.getMonitor.releaseMonitor();
                    return var7_9;
                }
                this.peekMonitor.releaseMonitor();
                return var7_9;
            }
            Object var11_14 = null;
            if (isRemove) {
                this.getMonitor.releaseMonitor();
                return object;
            }
            this.peekMonitor.releaseMonitor();
            return object;
        }
        Object var11_15 = null;
        if (isRemove) {
            this.getMonitor.releaseMonitor();
            return var6_4;
        }
        this.peekMonitor.releaseMonitor();
        return var6_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.queueElements == null) {
            return null;
        }
        List list = this.queueElements;
        synchronized (list) {
            if (this.queueElements == null) {
                return null;
            }
            if (this.size() == 0) {
                return EMPTY;
            }
            Object element = null;
            element = isRemove ? this.queueElements.remove(0) : this.queueElements.get(0);
            if (element == null) {
                return null;
            }
            if (this.cache == null) {
                return element;
            }
            if (element instanceof CachedReference) {
                CachedReference ref = element;
                Object obj = ref.get();
                if (isRemove) {
                    this.cache.remove(ref);
                }
                return obj;
            }
            return element;
        }
    }

    public Object get() {
        return this.get(-1L);
    }

    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    public Object peek() {
        return this.peek(-1L);
    }

    public Object remove(Object item) {
        Object removed;
        block3: {
            block2: {
                removed = null;
                if (this.cache != null) break block2;
                if (!this.queueElements.remove(item)) break block3;
                removed = item;
                break block3;
            }
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (element instanceof CachedReference) {
                    CachedReference ref = (CachedReference)element;
                    Object obj = ref.get(this, false);
                    if ((item != null || obj != null) && (item == null || !item.equals(obj))) continue;
                    this.cache.remove(ref);
                    removed = obj;
                    break;
                }
                if ((item != null || element != null) && (item == null || !item.equals(element))) continue;
                if (!this.queueElements.remove(element)) break;
                removed = element;
                break;
            }
        }
        return removed;
    }

    public void clear() {
        if (this.cache == null) {
            this.queueElements.clear();
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (!(element instanceof CachedReference)) continue;
                CachedReference ref = (CachedReference)element;
                this.cache.remove(ref);
            }
            this.queueElements.clear();
        }
    }

    public int size() {
        if (this.queueElements == null) {
            return 0;
        }
        return this.queueElements.size();
    }

    public void accept() {
        this.fourceEndFlg = false;
    }

    public void release() {
        this.fourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
            Thread.yield();
        }
        this.peekMonitor.notifyAllMonitor();
        Thread.yield();
        while (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
            Thread.yield();
        }
    }

    public List elements() {
        if (this.queueElements == null) {
            return new ArrayList();
        }
        return new ArrayList(this.queueElements);
    }

    public void removed(CachedReference ref) {
        if (this.queueElements == null) {
            return;
        }
        this.queueElements.remove(ref);
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    public long getDepth() {
        return this.size();
    }

    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    public long getMaxDepth() {
        return this.maxDepth;
    }

    protected static class EmptyElement {
        protected EmptyElement() {
        }
    }
}

