/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ClusterClientConnectionImpl;
import jp.ossc.nimbus.service.publish.ClusterConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.RemoteClientConnectionFactory;
import jp.ossc.nimbus.service.repository.Repository;

public class ClusterConnectionFactoryService
extends ServiceBase
implements ClientConnectionFactory,
ClusterConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 5192146255493285628L;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private ServiceName clientConnectionFactoryServiceName;
    private ClientConnectionFactory clientConnectionFactory;
    private ServiceName jndiRepositoryServiceName;
    private String jndiName = "publish/ClientConnectionFactory";
    private int rmiPort;
    private String clientConnectErrorMessageId = "PCCF_00001";
    private String clientReconnectMessageId = "PCCF_00003";
    private String clientNoConnectErrorMessageId = "PCCF_00004";
    private boolean isDistribute;
    private boolean isMultiple;
    private boolean isReceiveOwnMessage;
    private boolean isFlexibleConnect;
    private long failoverBufferTime;
    private Repository jndiRepository;

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setClientConnectionFactoryServiceName(ServiceName name) {
        this.clientConnectionFactoryServiceName = name;
    }

    public ServiceName getClientConnectionFactoryServiceName() {
        return this.clientConnectionFactoryServiceName;
    }

    public void setClientConnectErrorMessageId(String id) {
        this.clientConnectErrorMessageId = id;
    }

    public String getClientConnectErrorMessageId() {
        return this.clientConnectErrorMessageId;
    }

    public void setClientReconnectMessageId(String id) {
        this.clientReconnectMessageId = id;
    }

    public String getClientReconnectMessageId() {
        return this.clientReconnectMessageId;
    }

    public void setClientNoConnectErrorMessageId(String id) {
        this.clientNoConnectErrorMessageId = id;
    }

    public String getClientNoConnectErrorMessageId() {
        return this.clientNoConnectErrorMessageId;
    }

    public void setDistribute(boolean isDistribute) {
        this.isDistribute = isDistribute;
    }

    public boolean isDistribute() {
        return this.isDistribute;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public void setReceiveOwnMessage(boolean isReceive) {
        this.isReceiveOwnMessage = isReceive;
    }

    public boolean isReceiveOwnMessage() {
        return this.isReceiveOwnMessage;
    }

    public void setFlexibleConnect(boolean isFlexible) {
        this.isFlexibleConnect = isFlexible;
    }

    public boolean isFlexibleConnect() {
        return this.isFlexibleConnect;
    }

    public void setFailoverBufferTime(long time) {
        this.failoverBufferTime = time;
    }

    public long getFailoverBufferTime() {
        return this.failoverBufferTime;
    }

    public void setClusterService(ClusterService cluster) {
        this.cluster = cluster;
    }

    public ClusterService getClusterService() {
        return this.cluster;
    }

    public void setClientConnectionFactory(ClientConnectionFactory factory) {
        this.clientConnectionFactory = factory;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.clientConnectionFactory;
    }

    public void startService() throws Exception {
        if (this.jndiRepositoryServiceName == null) {
            throw new IllegalArgumentException("JndiRepositoryServiceName is null.");
        }
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
        }
        if (this.cluster == null) {
            throw new IllegalArgumentException("ClusterService is null.");
        }
        if (this.cluster.isJoin()) {
            throw new IllegalArgumentException("ClusterService already join.");
        }
        if (this.clientConnectionFactoryServiceName != null) {
            this.clientConnectionFactory = (ClientConnectionFactory)ServiceManagerFactory.getServiceObject(this.clientConnectionFactoryServiceName);
        }
        if (this.clientConnectionFactory == null) {
            throw new IllegalArgumentException("ClientConnectionFactory is null.");
        }
        this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        RemoteClientConnectionFactory remoteClientConnectionFactory = new RemoteClientConnectionFactory(this, this.rmiPort);
        ClientConnection cc = this.clientConnectionFactory.getClientConnection();
        if (cc == null) {
            throw new IllegalArgumentException("ClientConnection is null. factory=" + this.clientConnectionFactory);
        }
        ClusterOption option = new ClusterOption((ClientConnectionFactory)RemoteObject.toStub(remoteClientConnectionFactory), cc);
        this.cluster.setOption(option);
        if (!this.jndiRepository.register(this.jndiName, remoteClientConnectionFactory)) {
            throw new Exception("Could not register in jndiRepository.");
        }
        this.cluster.join();
    }

    public void stopService() throws Exception {
        this.cluster.leave();
        this.jndiRepository.unregister(this.jndiName);
    }

    public ClientConnection getClientConnection() throws ConnectionCreateException, RemoteException {
        ClusterClientConnectionImpl connection = new ClusterClientConnectionImpl(this.cluster);
        connection.setConnectErrorMessageId(this.clientConnectErrorMessageId);
        connection.setReconnectMessageId(this.clientReconnectMessageId);
        connection.setNoConnectErrorMessageId(this.clientNoConnectErrorMessageId);
        connection.setMultiple(this.isMultiple);
        connection.setReceiveOwnMessage(this.isReceiveOwnMessage);
        connection.setFlexibleConnect(this.isFlexibleConnect);
        connection.setDistribute(this.isDistribute);
        connection.setFailoverBufferTime(this.failoverBufferTime);
        return connection;
    }

    public int getClientCount() throws RemoteException {
        return this.clientConnectionFactory.getClientCount();
    }

    public static class ClusterOption
    implements Serializable {
        private static final long serialVersionUID = 5188173174307211941L;
        public final ClientConnectionFactory clusterClientConnectionFactory;
        public final ClientConnection clientConnection;

        public ClusterOption(ClientConnectionFactory factory, ClientConnection connection) {
            this.clusterClientConnectionFactory = factory;
            this.clientConnection = connection;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("clientConnection=").append(this.clientConnection);
            buf.append('}');
            return buf.toString();
        }
    }
}

