/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.performance;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.performance.CPUResourceUsageServiceMBean;
import jp.ossc.nimbus.service.performance.ResourceUsage;
import jp.ossc.nimbus.service.system.CpuTimes;
import jp.ossc.nimbus.service.system.OperationSystem;

public class CPUResourceUsageService
extends ServiceBase
implements ResourceUsage,
DaemonRunnable,
CPUResourceUsageServiceMBean {
    private static final long serialVersionUID = -2693011646692158213L;
    private ServiceName operationSystemServiceName;
    private OperationSystem operationSystem;
    private CpuTimes lastCpuTimesDelta;
    private CpuTimes lastCpuTimes;
    private long interval = 1000L;
    private Daemon cpuTimesChecker;

    public void setOperationSystemServiceName(ServiceName name) {
        this.operationSystemServiceName = name;
    }

    public ServiceName getOperationSystemServiceName() {
        return this.operationSystemServiceName;
    }

    public void setCpuTimesCheckInterval(long interval) {
        this.interval = interval;
    }

    public long getCpuTimesCheckInterval() {
        return this.interval;
    }

    public void setOperationSystem(OperationSystem os) {
        this.operationSystem = os;
    }

    public void startService() throws Exception {
        if (this.operationSystem == null && this.operationSystemServiceName == null) {
            throw new IllegalArgumentException("OperationSystem is null.");
        }
        if (this.operationSystemServiceName != null) {
            this.operationSystem = (OperationSystem)ServiceManagerFactory.getServiceObject(this.operationSystemServiceName);
        }
        this.cpuTimesChecker = new Daemon(this);
        this.cpuTimesChecker.setDaemon(true);
        this.cpuTimesChecker.setName("Nimbus CPUResourceUsage Checker " + this.getServiceNameObject());
        this.cpuTimesChecker.start();
    }

    public void stopService() throws Exception {
        if (this.cpuTimesChecker != null) {
            this.cpuTimesChecker.stopNoWait();
            this.cpuTimesChecker = null;
        }
    }

    public Comparable getUsage() {
        if (this.operationSystem == null) {
            return null;
        }
        CpuTimes cpuTimesDelta = this.operationSystem.getCpuTimesDelta(this.lastCpuTimes);
        if (this.lastCpuTimesDelta != null) {
            cpuTimesDelta.add(this.lastCpuTimesDelta);
        }
        return this.operationSystem == null ? null : ((double)cpuTimesDelta.getIdleRate() == 1.0 ? null : new Double(1.0 - (double)cpuTimesDelta.getIdleRate()));
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Throwable {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        this.lastCpuTimesDelta = this.operationSystem.getCpuTimesDelta(this.lastCpuTimes);
        this.lastCpuTimes = this.operationSystem.getCpuTimes();
    }

    public void garbage() {
    }
}

