/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.AbstractKeepAliveCheckerServiceMBean;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;

public abstract class AbstractKeepAliveCheckerService
extends ServiceBase
implements KeepAliveChecker,
AbstractKeepAliveCheckerServiceMBean {
    private static final long serialVersionUID = 7701584736922165397L;
    protected long checkInterval = -1L;
    protected long lastCheckTime = -1L;
    protected Daemon keepAliveChecker;
    protected String aliveLogMessageId = "KACS_00001";
    protected String deadLogMessageId = "KACS_00002";
    protected boolean isOutputAliveLogMessage = true;
    protected boolean isOutputDeadLogMessage = true;
    protected boolean isAlive = false;
    protected List keepAliveListeners;

    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
        if (this.checkInterval > 0L && this.keepAliveChecker != null && this.keepAliveChecker.isSusupend()) {
            this.keepAliveChecker.resume();
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setAliveLogMessageId(String id) {
        this.aliveLogMessageId = id;
    }

    public String getAliveLogMessageId() {
        return this.aliveLogMessageId;
    }

    public void setDeadLogMessageId(String id) {
        this.deadLogMessageId = id;
    }

    public String getDeadLogMessageId() {
        return this.deadLogMessageId;
    }

    public void setOutputAliveLogMessage(boolean isOutput) {
        this.isOutputAliveLogMessage = isOutput;
    }

    public boolean isOutputAliveLogMessage() {
        return this.isOutputAliveLogMessage;
    }

    public void setOutputDeadLogMessage(boolean isOutput) {
        this.isOutputDeadLogMessage = isOutput;
    }

    public boolean isOutputDeadLogMessage() {
        return this.isOutputDeadLogMessage;
    }

    public boolean isAlive() {
        if (this.checkInterval > 0L && this.lastCheckTime >= 0L) {
            return this.isAlive;
        }
        try {
            return this.checkAlive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void preCreateService() throws Exception {
        super.preCreateService();
        this.keepAliveListeners = new ArrayList();
    }

    public void postStartService() throws Exception {
        if (this.checkInterval > 0L) {
            try {
                this.isAlive = this.checkAlive();
            }
            catch (Exception e) {
                this.isAlive = false;
            }
            this.keepAliveChecker = new Daemon(new KeepAliveCheckerRunnable());
            this.keepAliveChecker.setName("Nimbus KeepAliveChecker " + this.getServiceNameObject());
            this.keepAliveChecker.start();
        }
        super.postStartService();
    }

    public void postStopService() throws Exception {
        if (this.keepAliveChecker != null) {
            this.keepAliveChecker.stop();
            this.keepAliveChecker = null;
        }
        super.postStopService();
    }

    public void postDestroyService() throws Exception {
        this.keepAliveListeners = null;
        super.postDestroyService();
    }

    public abstract boolean checkAlive() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeAlive() {
        if (this.isOutputAliveLogMessage() && this.getAliveLogMessageId() != null) {
            this.getLogger().write(this.getAliveLogMessageId(), this.getTargetInfo());
        }
        List list = this.keepAliveListeners;
        synchronized (list) {
            for (int i = 0; i < this.keepAliveListeners.size(); ++i) {
                ((KeepAliveListener)this.keepAliveListeners.get(i)).onRecover(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeDead(Exception exception) {
        if (this.isOutputDeadLogMessage() && this.getDeadLogMessageId() != null) {
            if (exception == null) {
                this.getLogger().write(this.getDeadLogMessageId(), this.getTargetInfo());
            } else {
                this.getLogger().write(this.getDeadLogMessageId(), this.getTargetInfo(), (Throwable)exception);
            }
        }
        List list = this.keepAliveListeners;
        synchronized (list) {
            for (int i = 0; i < this.keepAliveListeners.size(); ++i) {
                ((KeepAliveListener)this.keepAliveListeners.get(i)).onDead(this);
            }
        }
    }

    protected Object getTargetInfo() {
        return this.getServiceNameObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeepAliveListener() {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.clear();
        }
    }

    protected class KeepAliveCheckerRunnable
    implements DaemonRunnable {
        protected KeepAliveCheckerRunnable() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Exception {
            long sleepTime;
            if (AbstractKeepAliveCheckerService.this.checkInterval <= 0L) {
                ctrl.suspend();
            }
            long l = sleepTime = AbstractKeepAliveCheckerService.this.lastCheckTime < 0L ? 0L : AbstractKeepAliveCheckerService.this.checkInterval - (System.currentTimeMillis() - AbstractKeepAliveCheckerService.this.lastCheckTime);
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
            return null;
        }

        public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
            AbstractKeepAliveCheckerService.this.lastCheckTime = System.currentTimeMillis();
            boolean isPrevStatus = AbstractKeepAliveCheckerService.this.isAlive;
            Exception exception = null;
            try {
                AbstractKeepAliveCheckerService.this.isAlive = AbstractKeepAliveCheckerService.this.checkAlive();
            }
            catch (Exception e) {
                exception = e;
                AbstractKeepAliveCheckerService.this.isAlive = false;
            }
            if (isPrevStatus != AbstractKeepAliveCheckerService.this.isAlive) {
                if (AbstractKeepAliveCheckerService.this.isAlive) {
                    AbstractKeepAliveCheckerService.this.changeAlive();
                } else {
                    AbstractKeepAliveCheckerService.this.changeDead(exception);
                }
            }
        }

        public void garbage() {
        }
    }
}

