/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.editor.SimpleSafeJournalRequestJournalEditorServiceWithSQLSettingMBean;
import jp.ossc.nimbus.service.journal.editor.SimpleSafeRequestJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class SimpleSafeJournalRequestJournalEditorServiceWithSQLSetting
extends SimpleSafeRequestJournalEditorService
implements SimpleSafeJournalRequestJournalEditorServiceWithSQLSettingMBean {
    private static final long serialVersionUID = -4112494655642853654L;
    private boolean bOutputSql;
    private String mSqlKeyFormat = null;

    public void startService() throws Exception {
        super.startService();
        if (this.mSqlKeyFormat == null) {
            throw new IllegalArgumentException("SqlOmittingSqlKeyFormat be specified ");
        }
    }

    public void stopService() throws Exception {
        this.mSqlKeyFormat = null;
        super.stopService();
    }

    public void setOutputSql(boolean output) {
        this.bOutputSql = output;
    }

    public boolean getOutputSql() {
        return this.bOutputSql;
    }

    protected StringBuffer makeRecordsFormat(EditorFinder finder, JournalRecord[] records, StringBuffer buf) {
        int max = records.length;
        for (int i = 0; i < max; ++i) {
            if (!this.bOutputSql && this.isSqlRecKey(records[i].getKey())) continue;
            buf.append(records[i].toObject());
            if (i == max - 1) continue;
            buf.append(this.getLineSeparator());
        }
        return buf;
    }

    private boolean isSqlRecKey(String recStr) {
        if (recStr == null) {
            return false;
        }
        return recStr.indexOf(this.mSqlKeyFormat) != -1;
    }

    public void setSqlOmittingSqlKeyFormat(String format) {
        this.mSqlKeyFormat = format;
    }

    public String getSqlOmittingSqlKeyFormat() {
        return this.mSqlKeyFormat;
    }
}

