/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.RecordJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class RecordJournalEditorService
extends BlockJournalEditorServiceBase
implements RecordJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 823506812770313526L;
    protected static final String RECORD_SCHEMA_HEADER = "RecordSchema : ";
    protected static final String PROPERTIES_HEADER = "Properties : ";
    protected static final String DEFAULT_SECRET_STRING = "******";
    protected static final String PROPERTY_SEPARATOR = " = ";
    protected static final String CSV_SEPARATOR = ", ";
    protected static final String HEADER = "[Record]";
    protected boolean isOutputRecordSchema = false;
    protected boolean isOutputProperties = true;
    protected String secretString = "******";
    protected String[] secretProperties;
    protected Set secretPropertySet;
    protected String[] enabledProperties;
    protected Set enabledPropertySet;
    protected boolean isOutputCSVProperties;

    public RecordJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setOutputRecordSchema(boolean isOutput) {
        this.isOutputRecordSchema = isOutput;
    }

    public boolean isOutputRecordSchema() {
        return this.isOutputRecordSchema;
    }

    public void setOutputProperties(boolean isOutput) {
        this.isOutputProperties = isOutput;
    }

    public boolean isOutputProperties() {
        return this.isOutputProperties;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    public void setEnabledProperties(String[] names) {
        this.enabledProperties = names;
    }

    public String[] getEnabledProperties() {
        return this.enabledProperties;
    }

    public void setOutputCSVProperties(boolean isOutput) {
        this.isOutputCSVProperties = isOutput;
    }

    public boolean isOutputCSVProperties() {
        return this.isOutputCSVProperties;
    }

    public void createService() {
        this.secretPropertySet = new HashSet();
        this.enabledPropertySet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretProperties != null) {
            for (i = 0; i < this.secretProperties.length; ++i) {
                this.secretPropertySet.add(this.secretProperties[i]);
            }
        }
        if (this.enabledProperties != null) {
            for (i = 0; i < this.enabledProperties.length; ++i) {
                this.enabledPropertySet.add(this.enabledProperties[i]);
            }
        }
    }

    public void stopService() {
        this.secretPropertySet.clear();
        this.enabledPropertySet.clear();
    }

    public void destroyService() {
        this.secretPropertySet = null;
        this.enabledPropertySet = null;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        Record bean = (Record)value;
        boolean isMake = false;
        if (this.isOutputRecordSchema()) {
            this.makeRecordSchemaFormat(finder, key, bean, buf);
            isMake = true;
        }
        if (this.isOutputProperties()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makePropertiesFormat(finder, key, bean, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeRecordSchemaFormat(EditorFinder finder, Object key, Record bean, StringBuffer buf) {
        buf.append(RECORD_SCHEMA_HEADER);
        this.makeObjectFormat(finder, null, bean.getRecordSchema(), buf);
        return buf;
    }

    protected StringBuffer makePropertiesFormat(EditorFinder finder, Object key, Record bean, StringBuffer buf) {
        buf.append(PROPERTIES_HEADER);
        RecordSchema schema = bean.getRecordSchema();
        PropertySchema[] props = schema.getPropertySchemata();
        if (props == null || props.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        if (this.isOutputCSVProperties) {
            String name;
            int i;
            int max = props.length;
            for (i = 0; i < max; ++i) {
                name = props[i].getName();
                if (!this.enabledPropertySet.isEmpty() && !this.enabledPropertySet.contains(name)) continue;
                subBuf.append(name);
                if (i == max - 1) continue;
                subBuf.append(CSV_SEPARATOR);
            }
            subBuf.append(this.getLineSeparator());
            max = props.length;
            for (i = 0; i < max; ++i) {
                name = props[i].getName();
                if (!this.enabledPropertySet.isEmpty() && !this.enabledPropertySet.contains(name)) continue;
                if (this.secretPropertySet.contains(name)) {
                    subBuf.append(this.getSecretString());
                } else {
                    this.makeObjectFormat(finder, null, bean.getProperty(name), subBuf);
                }
                if (i == max - 1) continue;
                subBuf.append(CSV_SEPARATOR);
            }
        } else {
            int max = props.length;
            for (int i = 0; i < max; ++i) {
                String name = props[i].getName();
                if (!this.enabledPropertySet.isEmpty() && !this.enabledPropertySet.contains(name)) continue;
                subBuf.append(name);
                subBuf.append(PROPERTY_SEPARATOR);
                if (this.secretPropertySet.contains(name)) {
                    subBuf.append(this.getSecretString());
                } else {
                    this.makeObjectFormat(finder, null, bean.getProperty(name), subBuf);
                }
                if (i == max - 1) continue;
                subBuf.append(this.getLineSeparator());
            }
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

