/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.service.journal.editor.HttpSessionMapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpSessionMapJournalEditorService
extends MapJournalEditorServiceBase
implements HttpSessionMapJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 8651384368045906114L;
    private boolean isOutputId = true;
    private boolean isOutputCreationTime = true;
    private boolean isOutputLastAccessedTime = true;
    private boolean isOutputMaxInactiveInterval = false;
    private boolean isOutputAttributes = true;
    private boolean isOutputIsNew = true;
    private String[] secretAttributes;
    private Set secretAttributeSet;
    private String[] enabledAttributes;
    private Set enabledAttributeSet;

    public void setOutputId(boolean isOutput) {
        this.isOutputId = isOutput;
    }

    public boolean isOutputId() {
        return this.isOutputId;
    }

    public void setOutputCreationTime(boolean isOutput) {
        this.isOutputCreationTime = isOutput;
    }

    public boolean isOutputCreationTime() {
        return this.isOutputCreationTime;
    }

    public void setOutputLastAccessedTime(boolean isOutput) {
        this.isOutputLastAccessedTime = isOutput;
    }

    public boolean isOutputLastAccessedTime() {
        return this.isOutputLastAccessedTime;
    }

    public void setOutputMaxInactiveInterval(boolean isOutput) {
        this.isOutputMaxInactiveInterval = isOutput;
    }

    public boolean isOutputMaxInactiveInterval() {
        return this.isOutputMaxInactiveInterval;
    }

    public void setOutputIsNew(boolean isOutput) {
        this.isOutputIsNew = isOutput;
    }

    public boolean isOutputIsNew() {
        return this.isOutputIsNew;
    }

    public void setOutputAttributes(boolean isOutput) {
        this.isOutputAttributes = isOutput;
    }

    public boolean isOutputAttributes() {
        return this.isOutputAttributes;
    }

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void createService() {
        this.secretAttributeSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretAttributes != null) {
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null) {
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
    }

    public void stopService() {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
    }

    public void destroyService() {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
    }

    public Map toMap(EditorFinder finder, Object key, Object value) {
        HttpSession session = (HttpSession)value;
        HashMap result = new HashMap();
        if (this.isOutputId()) {
            this.makeIdFormat(finder, key, session, result);
        }
        if (this.isOutputCreationTime()) {
            this.makeCreationTimeFormat(finder, key, session, result);
        }
        if (this.isOutputLastAccessedTime()) {
            this.makeLastAccessedTimeFormat(finder, key, session, result);
        }
        if (this.isOutputMaxInactiveInterval()) {
            this.makeMaxInactiveIntervalFormat(finder, key, session, result);
        }
        if (this.isOutputIsNew()) {
            this.makeIsNewFormat(finder, key, session, result);
        }
        if (this.isOutputAttributes()) {
            this.makeAttributesFormat(finder, key, session, result);
        }
        return result;
    }

    protected Map makeIdFormat(EditorFinder finder, Object key, HttpSession session, Map map) {
        map.put("ID", session.getId());
        return map;
    }

    protected Map makeCreationTimeFormat(EditorFinder finder, Object key, HttpSession session, Map map) {
        map.put("CreationTime", new Date(session.getCreationTime()));
        return map;
    }

    protected Map makeLastAccessedTimeFormat(EditorFinder finder, Object key, HttpSession session, Map map) {
        map.put("LastAccessedTime", new Date(session.getLastAccessedTime()));
        return map;
    }

    protected Map makeMaxInactiveIntervalFormat(EditorFinder finder, Object key, HttpSession session, Map map) {
        map.put("MaxInactiveInterval", new Long(session.getMaxInactiveInterval()));
        return map;
    }

    protected Map makeIsNewFormat(EditorFinder finder, Object key, HttpSession session, Map map) {
        map.put("IsNew", session.isNew() ? Boolean.TRUE : Boolean.FALSE);
        return map;
    }

    protected Map makeAttributesFormat(EditorFinder finder, Object key, HttpSession session, Map map) {
        Enumeration attrNames = session.getAttributeNames();
        if (!attrNames.hasMoreElements()) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            if (this.secretAttributeSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, null, session.getAttribute(name)));
        }
        map.put("Attributes", this.makeObjectFormat(finder, key, subMap));
        return map;
    }
}

