/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.service.journal.editor.HttpServletRequestJSONJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ServletRequestJSONJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletRequestJSONJournalEditorService
extends ServletRequestJSONJournalEditorService
implements HttpServletRequestJSONJournalEditorServiceMBean {
    private static final long serialVersionUID = 2640185595372945106L;
    protected String[] secretHeaders;
    protected Set secretHeaderSet;
    protected String[] enabledHeaders;
    protected Set enabledHeaderSet;
    protected String[] disabledHeaders;
    protected Set disabledHeaderSet;
    protected String[] secretCookies;
    protected Set secretCookieSet;
    protected String[] enabledCookies;
    protected Set enabledCookieSet;
    protected String[] disabledCookies;
    protected Set disabledCookieSet;

    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setDisabledHeaders(String[] names) {
        this.disabledHeaders = names;
    }

    public String[] getDisabledHeaders() {
        return this.disabledHeaders;
    }

    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    public void setDisabledCookies(String[] names) {
        this.disabledCookies = names;
    }

    public String[] getDisabledCookies() {
        return this.disabledCookies;
    }

    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.secretHeaders != null && this.secretHeaders.length != 0) {
            this.secretHeaderSet = new HashSet(this.secretHeaders.length);
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null && this.enabledHeaders.length != 0) {
            this.enabledHeaderSet = new HashSet(this.enabledHeaders.length);
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.disabledHeaders != null && this.disabledHeaders.length != 0) {
            this.disabledHeaderSet = new HashSet(this.disabledHeaders.length);
            for (i = 0; i < this.disabledHeaders.length; ++i) {
                this.disabledHeaderSet.add(this.disabledHeaders[i]);
            }
        }
        if (this.secretCookies != null && this.secretCookies.length != 0) {
            this.secretCookieSet = new HashSet(this.secretCookies.length);
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null && this.enabledCookies.length != 0) {
            this.enabledCookieSet = new HashSet(this.enabledCookies.length);
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
        if (this.disabledCookies != null && this.disabledCookies.length != 0) {
            this.disabledCookieSet = new HashSet(this.disabledCookies.length);
            for (i = 0; i < this.disabledCookies.length; ++i) {
                this.disabledCookieSet.add(this.disabledCookies[i]);
            }
        }
    }

    protected boolean isOutputHeader(String name) {
        if (name != null && this.disabledHeaderSet != null && this.disabledHeaderSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledHeaderSet == null || this.enabledHeaderSet.contains(name);
    }

    protected boolean isSecretHeader(String name) {
        return name != null && this.secretHeaderSet != null && this.secretHeaderSet.contains(name);
    }

    protected boolean isOutputCookie(String name) {
        if (name != null && this.disabledCookieSet != null && this.disabledCookieSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledCookieSet == null || this.enabledCookieSet.contains(name);
    }

    protected boolean isSecretCookie(String name) {
        return name != null && this.secretCookieSet != null && this.secretCookieSet.contains(name);
    }

    protected StringBuffer appendUnknownValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        if (!(value instanceof HttpServletRequest)) {
            return super.appendUnknownValue(buf, finder, type, value);
        }
        HttpServletRequest request = (HttpServletRequest)value;
        buf.append("{");
        boolean isAppended = this.appendServletRequest(buf, finder, (ServletRequest)request, false);
        this.appendHttpServletRequest(buf, finder, request, isAppended);
        buf.append("}");
        return buf;
    }

    protected boolean appendHttpServletRequest(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        isAppended |= this.appendRequestURL(buf, finder, request, isAppended);
        isAppended |= this.appendRequestURI(buf, finder, request, isAppended);
        isAppended |= this.appendServletPath(buf, finder, request, isAppended);
        isAppended |= this.appendContextPath(buf, finder, request, isAppended);
        isAppended |= this.appendPathInfo(buf, finder, request, isAppended);
        isAppended |= this.appendPathTranslated(buf, finder, request, isAppended);
        isAppended |= this.appendQuery(buf, finder, request, isAppended);
        isAppended |= this.appendSessionId(buf, finder, request, isAppended);
        isAppended |= this.appendMethod(buf, finder, request, isAppended);
        isAppended |= this.appendAuthType(buf, finder, request, isAppended);
        isAppended |= this.appendRemoteUser(buf, finder, request, isAppended);
        isAppended |= this.appendUserPrincipal(buf, finder, request, isAppended);
        isAppended |= this.appendHeaders(buf, finder, request, isAppended);
        isAppended |= this.appendCookies(buf, finder, request, isAppended);
        return isAppended;
    }

    protected boolean appendRequestURL(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("RequestURL")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "RequestURL", request.getRequestURL());
            return true;
        }
        return false;
    }

    protected boolean appendRequestURI(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("RequestURI")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "RequestURI", request.getRequestURI());
            return true;
        }
        return false;
    }

    protected boolean appendServletPath(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("ServletPath")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "ServletPath", request.getServletPath());
            return true;
        }
        return false;
    }

    protected boolean appendContextPath(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("ContextPath")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "ContextPath", request.getContextPath());
            return true;
        }
        return false;
    }

    protected boolean appendPathInfo(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("PathInfo")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "PathInfo", request.getPathInfo());
            return true;
        }
        return false;
    }

    protected boolean appendPathTranslated(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("PathTranslated")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "PathTranslated", request.getPathTranslated());
            return true;
        }
        return false;
    }

    protected boolean appendQuery(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Query")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Query", request.getQueryString());
            return true;
        }
        return false;
    }

    protected boolean appendSessionId(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("SessionId")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "SessionId", request.getRequestedSessionId());
            if (request.isRequestedSessionIdFromCookie()) {
                buf.append("(").append("From Cookie").append(")");
            } else if (request.isRequestedSessionIdFromURL()) {
                buf.append("(").append("From URL").append(")");
            }
            return true;
        }
        return false;
    }

    protected boolean appendMethod(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Method")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Method", request.getMethod());
            return true;
        }
        return false;
    }

    protected boolean appendAuthType(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("AuthType")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "AuthType", request.getAuthType());
            return true;
        }
        return false;
    }

    protected boolean appendRemoteUser(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("RemoteUser")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "RemoteUser", request.getRemoteUser());
            return true;
        }
        return false;
    }

    protected boolean appendUserPrincipal(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("UserPrincipal")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "UserPrincipal", request.getUserPrincipal());
            return true;
        }
        return false;
    }

    protected boolean appendHeaders(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Headers")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Headers");
            buf.append(":");
            buf.append("{");
            boolean isOutput = false;
            Enumeration names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!this.isOutputHeader(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                if (this.isSecretHeader(name)) {
                    this.appendValue(buf, finder, null, this.secretString);
                    continue;
                }
                this.appendArray(buf, finder, request.getHeaders(name));
            }
            buf.append("}");
            return true;
        }
        return false;
    }

    protected boolean appendCookies(StringBuffer buf, EditorFinder finder, HttpServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Headers")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Headers");
            buf.append(":");
            buf.append("{");
            boolean isOutput = false;
            Cookie[] cookies = request.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                String name = cookie.getName();
                if (!this.isOutputCookie(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                boolean isOutputCookie = false;
                buf.append("{");
                if (this.isOutputProperty("CookieValue")) {
                    if (this.isSecretCookie(name)) {
                        this.appendProperty(buf, finder, "CookieValue", this.secretString);
                    } else {
                        this.appendProperty(buf, finder, "CookieValue", cookie.getValue());
                    }
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieComment")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieComment", cookie.getComment());
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieDomain")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieDomain", cookie.getDomain());
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieMaxAge")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieMaxAge", new Integer(cookie.getMaxAge()));
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookiePath")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookiePath", cookie.getPath());
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieSecure")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieSecure", cookie.getSecure() ? Boolean.TRUE : Boolean.FALSE);
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieVersion")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieVersion", new Integer(cookie.getVersion()));
                    isOutputCookie = true;
                }
                buf.append("}");
            }
            buf.append("}");
            return true;
        }
        return false;
    }
}

