/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DynaClassJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class DynaClassJournalEditorService
extends BlockJournalEditorServiceBase
implements DynaClassJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 1824967470335975074L;
    private static final String NAME_HEADER = "Name : ";
    private static final String DYNA_PROPERTIES_HEADER = "DynaProperties : ";
    protected static final String HEADER = "[DynaClass]";
    private boolean isOutputName = true;
    private boolean isOutputDynaProperties = true;

    public DynaClassJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setOutputName(boolean isOutput) {
        this.isOutputName = isOutput;
    }

    public boolean isOutputName() {
        return this.isOutputName;
    }

    public void setOutputDynaProperties(boolean isOutput) {
        this.isOutputDynaProperties = isOutput;
    }

    public boolean isOutputDynaProperties() {
        return this.isOutputDynaProperties;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        DynaClass dynaClass = (DynaClass)value;
        boolean isMake = false;
        if (this.isOutputName()) {
            this.makeNameFormat(finder, key, dynaClass, buf);
            isMake = true;
        }
        if (this.isOutputDynaProperties()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeDynaPropertiesFormat(finder, key, dynaClass, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeNameFormat(EditorFinder finder, Object key, DynaClass dynaClass, StringBuffer buf) {
        return buf.append(NAME_HEADER).append(dynaClass.getName());
    }

    protected StringBuffer makeDynaPropertiesFormat(EditorFinder finder, Object key, DynaClass dynaClass, StringBuffer buf) {
        buf.append(DYNA_PROPERTIES_HEADER);
        DynaProperty[] props = dynaClass.getDynaProperties();
        if (props == null || props.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        int max = props.length;
        for (int i = 0; i < max; ++i) {
            this.makeObjectFormat(finder, null, props[i], subBuf);
            if (i == max - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

