/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.journal.editor.DataSetJSONJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class DataSetJSONJournalEditorService
extends ImmutableJournalEditorServiceBase
implements DataSetJSONJournalEditorServiceMBean {
    private static final long serialVersionUID = 3264007026021831179L;
    private static final String STRING_ENCLOSURE = "\"";
    private static final String ARRAY_SEPARATOR = ",";
    private static final String ARRAY_ENCLOSURE_START = "[";
    private static final String ARRAY_ENCLOSURE_END = "]";
    private static final String OBJECT_ENCLOSURE_START = "{";
    private static final String OBJECT_ENCLOSURE_END = "}";
    private static final String PROPERTY_SEPARATOR = ":";
    private static final String NULL_VALUE = "null";
    private static final String BOOLEAN_VALUE_TRUE = "true";
    private static final String BOOLEAN_VALUE_FALSE = "false";
    private static final String NAME_SCHEMA = "schema";
    private static final String NAME_HEADER = "header";
    private static final String NAME_RECORD_LIST = "recordList";
    private static final String NAME_NESTED_RECORD_LIST = "nestedRecordList";
    private static final String NAME_NESTED_RECORD = "nestedRecord";
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char BACK_SLASH = '\\';
    private static final char SLASH = '/';
    private static final char BACK_SPACE = '\b';
    private static final char CHANGE_PAGE = '\f';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char TAB = '\t';
    private static final String ESCAPE_QUOTE = "\\\"";
    private static final String ESCAPE_BACK_SLASH = "\\\\";
    private static final String ESCAPE_SLASH = "\\/";
    private static final String ESCAPE_BACK_SPACE = "\\b";
    private static final String ESCAPE_CHANGE_PAGE = "\\f";
    private static final String ESCAPE_LF = "\\n";
    private static final String ESCAPE_CR = "\\r";
    private static final String ESCAPE_TAB = "\\b";
    private boolean isOutputSchema = true;
    private boolean isOutputPropertyNameOfHeader = true;
    private boolean isOutputPropertyNameOfRecordList = true;

    public void setOutputSchema(boolean isOutput) {
        this.isOutputSchema = isOutput;
    }

    public boolean isOutputSchema() {
        return this.isOutputSchema;
    }

    public void setOutputPropertyNameOfHeader(boolean isOutput) {
        this.isOutputPropertyNameOfHeader = isOutput;
    }

    public boolean isOutputPropertyNameOfHeader() {
        return this.isOutputPropertyNameOfHeader;
    }

    public void setOutputPropertyNameOfRecordList(boolean isOutput) {
        this.isOutputPropertyNameOfRecordList = isOutput;
    }

    public boolean isOutputPropertyNameOfRecordList() {
        return this.isOutputPropertyNameOfRecordList;
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        String[] recListNames;
        String[] headerNames;
        DataSet dataSet = (DataSet)value;
        String dsName = dataSet.getName();
        if (dsName == null) {
            dsName = "";
        }
        buf.append(OBJECT_ENCLOSURE_START);
        this.appendName(buf, dsName);
        buf.append(PROPERTY_SEPARATOR);
        buf.append(OBJECT_ENCLOSURE_START);
        boolean isOutput = false;
        if (this.isOutputSchema) {
            RecordSchema recSchema;
            String[] recNames;
            String[] recListNames2;
            this.appendName(buf, NAME_SCHEMA);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            headerNames = dataSet.getHeaderNames();
            if (headerNames != null && headerNames.length > 0) {
                this.appendName(buf, NAME_HEADER);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                int imax = headerNames.length;
                for (int i = 0; i < imax; ++i) {
                    Header header = dataSet.getHeader(headerNames[i]);
                    this.appendName(buf, headerNames[i] == null ? "" : headerNames[i]);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, header.getSchema());
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                isOutput = true;
            }
            if ((recListNames2 = dataSet.getRecordListNames()) != null && recListNames2.length > 0) {
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendName(buf, NAME_RECORD_LIST);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                int imax = recListNames2.length;
                for (int i = 0; i < imax; ++i) {
                    RecordList recList = dataSet.getRecordList(recListNames2[i]);
                    this.appendName(buf, recListNames2[i] == null ? "" : recListNames2[i]);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, recList.getSchema());
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                isOutput = true;
            }
            if ((recNames = dataSet.getNestedRecordSchemaNames()) != null && recNames.length > 0) {
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendName(buf, NAME_NESTED_RECORD);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                int imax = recNames.length;
                for (int i = 0; i < imax; ++i) {
                    recSchema = dataSet.getNestedRecordSchema(recNames[i]);
                    this.appendName(buf, recNames[i]);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, recSchema.getSchema());
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                isOutput = true;
            }
            if ((recListNames2 = dataSet.getNestedRecordListSchemaNames()) != null && recListNames2.length > 0) {
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendName(buf, NAME_NESTED_RECORD_LIST);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                int imax = recListNames2.length;
                for (int i = 0; i < imax; ++i) {
                    recSchema = dataSet.getNestedRecordListSchema(recListNames2[i]);
                    this.appendName(buf, recListNames2[i]);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, recSchema.getSchema());
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                isOutput = true;
            }
            buf.append(OBJECT_ENCLOSURE_END);
        }
        if ((headerNames = dataSet.getHeaderNames()) != null && headerNames.length > 0) {
            if (isOutput) {
                buf.append(ARRAY_SEPARATOR);
            }
            this.appendName(buf, NAME_HEADER);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            int imax = headerNames.length;
            for (int i = 0; i < imax; ++i) {
                Header header = dataSet.getHeader(headerNames[i]);
                this.appendName(buf, headerNames[i] == null ? "" : headerNames[i]);
                buf.append(PROPERTY_SEPARATOR);
                this.appendValue(buf, null, header);
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
            buf.append(OBJECT_ENCLOSURE_END);
            isOutput = true;
        }
        if ((recListNames = dataSet.getRecordListNames()) != null && recListNames.length > 0) {
            if (isOutput) {
                buf.append(ARRAY_SEPARATOR);
            }
            this.appendName(buf, NAME_RECORD_LIST);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            int imax = recListNames.length;
            for (int i = 0; i < imax; ++i) {
                RecordList recList = dataSet.getRecordList(recListNames[i]);
                this.appendName(buf, recListNames[i] == null ? "" : recListNames[i]);
                buf.append(PROPERTY_SEPARATOR);
                this.appendArray(buf, recList);
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
            buf.append(OBJECT_ENCLOSURE_END);
            isOutput = true;
        }
        buf.append(OBJECT_ENCLOSURE_END);
        buf.append(OBJECT_ENCLOSURE_END);
        return buf.toString();
    }

    private StringBuffer appendName(StringBuffer buf, String name) {
        buf.append(STRING_ENCLOSURE);
        buf.append(this.escape(name));
        buf.append(STRING_ENCLOSURE);
        return buf;
    }

    private StringBuffer appendValue(StringBuffer buf, Class type, Object value) {
        if (type == null && value != null) {
            type = value.getClass();
        }
        if (value == null) {
            if (type == null) {
                buf.append(NULL_VALUE);
            } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
                buf.append('0');
            } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                buf.append(BOOLEAN_VALUE_FALSE);
            } else {
                buf.append(NULL_VALUE);
            }
        } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            if (((Boolean)value).booleanValue()) {
                buf.append(BOOLEAN_VALUE_TRUE);
            } else {
                buf.append(BOOLEAN_VALUE_FALSE);
            }
        } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
            buf.append(value);
        } else if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            this.appendArray(buf, value);
        } else if (Record.class.isAssignableFrom(type)) {
            Record rec = (Record)value;
            RecordSchema schema = rec.getRecordSchema();
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            boolean isOutputPropertyName = true;
            if (rec instanceof Header && !this.isOutputPropertyNameOfHeader || !(rec instanceof Header) && !this.isOutputPropertyNameOfRecordList) {
                isOutputPropertyName = false;
            }
            if (isOutputPropertyName) {
                buf.append(OBJECT_ENCLOSURE_START);
            } else {
                buf.append(ARRAY_ENCLOSURE_START);
            }
            int imax = propSchemata.length;
            for (int i = 0; i < imax; ++i) {
                Object prop = rec.getProperty(i);
                PropertySchema propSchema = propSchemata[i];
                boolean hasConverter = false;
                if (propSchema instanceof DefaultPropertySchema) {
                    boolean bl = hasConverter = ((DefaultPropertySchema)propSchema).getFormatConverter() != null;
                }
                if (isOutputPropertyName) {
                    this.appendName(buf, propSchema.getName());
                    buf.append(PROPERTY_SEPARATOR);
                }
                if (prop == null) {
                    this.appendValue(buf, propSchema.getType(), null);
                } else {
                    Class<?> propType = propSchema.getType();
                    if (propType == null) {
                        propType = prop.getClass();
                    }
                    if (propType.isArray() || (class$java$util$Collection == null ? DataSetJSONJournalEditorService.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(propType)) {
                        this.appendArray(buf, rec.getProperty(i));
                    } else if ((class$java$lang$Number == null ? DataSetJSONJournalEditorService.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(propType) || propType.isPrimitive() && (Byte.TYPE.equals(propType) || Short.TYPE.equals(propType) || Integer.TYPE.equals(propType) || Long.TYPE.equals(propType) || Float.TYPE.equals(propType) || Double.TYPE.equals(propType) || Boolean.TYPE.equals(propType)) || (class$java$lang$Boolean == null ? DataSetJSONJournalEditorService.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(propType)) {
                        this.appendValue(buf, propType, hasConverter ? rec.getFormatProperty(i) : rec.getProperty(i));
                    } else {
                        this.appendValue(buf, null, rec.getFormatProperty(i));
                    }
                }
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
            if (isOutputPropertyName) {
                buf.append(OBJECT_ENCLOSURE_END);
            } else {
                buf.append(ARRAY_ENCLOSURE_END);
            }
        } else {
            buf.append(STRING_ENCLOSURE);
            buf.append(this.escape(value.toString()));
            buf.append(STRING_ENCLOSURE);
        }
        return buf;
    }

    private StringBuffer appendArray(StringBuffer buf, Object array) {
        buf.append(ARRAY_ENCLOSURE_START);
        if (array.getClass().isArray()) {
            int imax = Array.getLength(array);
            for (int i = 0; i < imax; ++i) {
                this.appendValue(buf, null, Array.get(array, i));
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (List.class.isAssignableFrom(array.getClass())) {
            List list = (List)array;
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                this.appendValue(buf, null, list.get(i));
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (Collection.class.isAssignableFrom(array.getClass())) {
            Iterator itr = ((Collection)array).iterator();
            while (itr.hasNext()) {
                this.appendValue(buf, null, itr.next());
                if (!itr.hasNext()) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        }
        buf.append(ARRAY_ENCLOSURE_END);
        return buf;
    }

    private String escape(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean isEscape = false;
        StringBuffer buf = new StringBuffer();
        int imax = str.length();
        block10: for (int i = 0; i < imax; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append(ESCAPE_QUOTE);
                    isEscape = true;
                    continue block10;
                }
                case '\\': {
                    buf.append(ESCAPE_BACK_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '/': {
                    buf.append(ESCAPE_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '\b': {
                    buf.append("\\b");
                    isEscape = true;
                    continue block10;
                }
                case '\f': {
                    buf.append(ESCAPE_CHANGE_PAGE);
                    isEscape = true;
                    continue block10;
                }
                case '\n': {
                    buf.append(ESCAPE_LF);
                    isEscape = true;
                    continue block10;
                }
                case '\r': {
                    buf.append(ESCAPE_CR);
                    isEscape = true;
                    continue block10;
                }
                case '\t': {
                    buf.append("\\b");
                    isEscape = true;
                    continue block10;
                }
                default: {
                    if (!(c == ' ' || c == '!' || '#' <= c && c <= '[' || ']' <= c && c <= '~')) {
                        isEscape = true;
                        this.toUnicode(c, buf);
                        continue block10;
                    }
                    buf.append(c);
                }
            }
        }
        return isEscape ? buf.toString() : str;
    }

    private StringBuffer toUnicode(char c, StringBuffer buf) {
        buf.append('\\');
        buf.append('u');
        int mask = 61440;
        block18: for (int i = 0; i < 4; ++i) {
            mask = 61440 >> i * 4;
            int val = c & mask;
            switch (val <<= i * 4) {
                case 0: {
                    buf.append('0');
                    continue block18;
                }
                case 4096: {
                    buf.append('1');
                    continue block18;
                }
                case 8192: {
                    buf.append('2');
                    continue block18;
                }
                case 12288: {
                    buf.append('3');
                    continue block18;
                }
                case 16384: {
                    buf.append('4');
                    continue block18;
                }
                case 20480: {
                    buf.append('5');
                    continue block18;
                }
                case 24576: {
                    buf.append('6');
                    continue block18;
                }
                case 28672: {
                    buf.append('7');
                    continue block18;
                }
                case 32768: {
                    buf.append('8');
                    continue block18;
                }
                case 36864: {
                    buf.append('9');
                    continue block18;
                }
                case 40960: {
                    buf.append('a');
                    continue block18;
                }
                case 45056: {
                    buf.append('b');
                    continue block18;
                }
                case 49152: {
                    buf.append('c');
                    continue block18;
                }
                case 53248: {
                    buf.append('d');
                    continue block18;
                }
                case 57344: {
                    buf.append('e');
                    continue block18;
                }
                case 61440: {
                    buf.append('f');
                    continue block18;
                }
            }
        }
        return buf;
    }
}

