/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import jp.ossc.nimbus.service.jms.JMSMessageProducerCreateException;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactoryService;

public class JMSTopicPublisherFactoryService
extends JMSMessageProducerFactoryService {
    private static final long serialVersionUID = 1024878767143611449L;

    public MessageProducer createProducer(Session session, Destination dest) throws JMSMessageProducerCreateException {
        if (session == null) {
            throw new JMSMessageProducerCreateException("Session is null.");
        }
        if (!(session instanceof TopicSession)) {
            throw new JMSMessageProducerCreateException("Session is not TopicSession.");
        }
        if (dest == null) {
            throw new JMSMessageProducerCreateException("Destination is null.");
        }
        if (!(dest instanceof Topic)) {
            throw new JMSMessageProducerCreateException("Destination is not topic.");
        }
        try {
            TopicPublisher mp = ((TopicSession)session).createPublisher((Topic)dest);
            mp.setDeliveryMode(this.deliveryMode);
            mp.setPriority(this.priority);
            mp.setTimeToLive(this.timeToLive);
            return mp;
        }
        catch (JMSException e) {
            throw new JMSMessageProducerCreateException(e);
        }
    }
}

