/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactoryService;
import jp.ossc.nimbus.service.jms.ReconnectableTopicConnection;

public class JMSTopicConnectionFactoryService
extends JMSConnectionFactoryService {
    private static final long serialVersionUID = 4478969024228778648L;

    protected Connection createConnection(String user, String pwd) throws JMSException, JMSConnectionCreateException {
        if (!(this.connectionFactory instanceof TopicConnectionFactory)) {
            throw new JMSConnectionCreateException("ConnectionFactory is not TopicConnectionFactory.");
        }
        if (this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_RECOVER || this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_DEAD) {
            ReconnectableTopicConnection con = null;
            con = user == null ? new ReconnectableTopicConnection(this.connectionFactory) : new ReconnectableTopicConnection(this.connectionFactory, user, pwd);
            con.setKeepAliveChecker(this.jndiKeepAliveChecker);
            con.setReconnectMode(this.autoReconnectMode);
            if (this.autoReconnectErrorLogMessageId != null) {
                con.setReconnectErrorLogMessageId(this.autoReconnectErrorLogMessageId);
                con.setLogger(this.getLogger());
            }
            con.setReconnectMaxRetryCount(this.autoReconnectMaxRetryCount);
            con.setReconnectRetryInterval(this.autoReconnectRetryInterval);
            return con;
        }
        if (user != null) {
            return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(user, pwd);
        }
        return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
    }
}

