/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.io.SerializableExternalizerServiceMBean;

public class SerializableExternalizerService
extends ServiceBase
implements SerializableExternalizerServiceMBean,
Externalizer,
Serializable {
    private static final long serialVersionUID = -2894857230847782064L;
    protected int compressMode = 0;
    protected int compressLevel = -1;
    protected int compressMethod = 8;
    protected int compressThreshold = -1;
    protected int bufferSize;
    protected Class objectOutputClass;
    protected transient Constructor objectOutputConstructor;
    protected Class objectInputClass;
    protected transient Constructor objectInputConstructor;

    public void setCompressMode(int mode) {
        this.compressMode = mode;
    }

    public int getCompressMode() {
        return this.compressMode;
    }

    public void setCompressLevel(int level) {
        this.compressLevel = level;
    }

    public int getCompressLevel() {
        return this.compressLevel;
    }

    public void setCompressMethod(int method) {
        this.compressMethod = method;
    }

    public int getCompressMethod() {
        return this.compressMethod;
    }

    public void setCompressThreshold(int threshold) {
        this.compressThreshold = threshold;
    }

    public int getCompressThreshold() {
        return this.compressThreshold;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setObjectOutputClass(Class clazz) {
        if (clazz == null) {
            this.objectOutputConstructor = null;
            this.objectOutputClass = null;
        } else {
            try {
                this.objectOutputConstructor = clazz.getConstructor(OutputStream.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No support ObjectOutputClass." + clazz);
            }
            this.objectOutputClass = clazz;
        }
    }

    public Class getObjectOutputClass() {
        return this.objectOutputClass;
    }

    public void setObjectInputClass(Class clazz) {
        if (clazz == null) {
            this.objectInputConstructor = null;
            this.objectInputClass = null;
        } else {
            try {
                this.objectInputConstructor = clazz.getConstructor(InputStream.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No support ObjectInputClass." + clazz);
            }
            this.objectInputClass = clazz;
        }
    }

    public Class getObjectInputClass() {
        return this.objectInputClass;
    }

    protected ObjectOutput createObjectOutput(OutputStream out) throws IOException {
        ObjectOutput output = null;
        if (this.objectOutputClass == null) {
            output = new ObjectOutputStream(out);
        } else {
            try {
                output = (ObjectOutput)this.objectOutputConstructor.newInstance(out);
            }
            catch (InstantiationException e) {
                throw new IOException("ObjectOutput can not instanciate." + this.objectOutputClass.getName() + " cause " + e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IOException("ObjectOutput can not instanciate." + this.objectOutputClass.getName() + " cause " + e.toString());
            }
            catch (InvocationTargetException e) {
                throw new IOException("ObjectOutput can not instanciate." + this.objectOutputClass.getName() + " cause " + e.getTargetException().toString());
            }
        }
        return output;
    }

    public void writeExternal(Object obj, OutputStream out) throws IOException {
        ObjectOutput output = this.createObjectOutput(out);
        this.writeExternal(obj, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Object obj, ObjectOutput out) throws IOException {
        try {
            byte[] compressedBytes;
            byte[] noCompressedBytes;
            ByteArrayOutputStream baos;
            block24: {
                DeflaterOutputStream dos;
                block23: {
                    if (this.compressMode == 0) {
                        this.writeInternal(obj, out);
                        return;
                    }
                    if (obj == null) {
                        out.writeBoolean(false);
                        this.writeInternal(obj, out);
                        return;
                    }
                    baos = this.bufferSize > 0 ? new ByteArrayOutputStream(this.bufferSize) : new ByteArrayOutputStream();
                    ObjectOutput tmpOut = this.createObjectOutput(baos);
                    this.writeInternal(obj, tmpOut);
                    tmpOut.flush();
                    noCompressedBytes = baos.toByteArray();
                    if (this.compressThreshold >= noCompressedBytes.length) {
                        out.writeBoolean(false);
                        out.write(noCompressedBytes);
                        return;
                    }
                    baos.reset();
                    dos = null;
                    Deflater deflater = null;
                    compressedBytes = null;
                    switch (this.compressMode) {
                        case 1: {
                            deflater = new Deflater(this.compressLevel);
                            dos = this.bufferSize > 0 ? new DeflaterOutputStream((OutputStream)baos, deflater, this.bufferSize) : new DeflaterOutputStream((OutputStream)baos, deflater);
                            break;
                        }
                        case 2: {
                            ZipOutputStream zos = new ZipOutputStream(baos);
                            zos.setLevel(this.compressLevel);
                            zos.setMethod(this.compressMethod);
                            zos.putNextEntry(new ZipEntry("a"));
                            dos = zos;
                            break;
                        }
                        case 3: {
                            dos = this.bufferSize > 0 ? new GZIPOutputStream((OutputStream)baos, this.bufferSize) : new GZIPOutputStream(baos);
                            break;
                        }
                        default: {
                            throw new IOException("Unknown compress mode : " + this.compressMode);
                        }
                    }
                    try {
                        dos.write(noCompressedBytes, 0, noCompressedBytes.length);
                        if (this.compressMode == 2) {
                            ((ZipOutputStream)dos).closeEntry();
                        }
                        dos.finish();
                        Object var11_10 = null;
                        if (deflater == null) break block23;
                        deflater.end();
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        if (deflater != null) {
                            deflater.end();
                        }
                        try {
                            dos.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        baos.close();
                        throw throwable;
                    }
                }
                try {
                    dos.close();
                    break block24;
                }
                catch (IOException e) {
                    // empty catch block
                }
                {
                }
            }
            baos.close();
            compressedBytes = baos.toByteArray();
            if (noCompressedBytes.length <= compressedBytes.length) {
                out.writeBoolean(false);
                out.write(noCompressedBytes);
            } else {
                out.writeBoolean(true);
                out.writeInt(compressedBytes.length);
                out.write(compressedBytes);
            }
        }
        finally {
            out.flush();
        }
    }

    protected void writeInternal(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    public Object readExternal(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInput input = this.createObjectInput(in);
        return this.readExternal(input);
    }

    protected ObjectInput createObjectInput(InputStream in) throws IOException {
        ObjectInput input = null;
        if (this.objectInputClass == null) {
            input = new ObjectInputStream(in);
        } else {
            try {
                input = (ObjectInput)this.objectInputConstructor.newInstance(in);
            }
            catch (InstantiationException e) {
                throw new IOException("ObjectInput can not instanciate." + this.objectInputClass.getName() + " cause " + e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IOException("ObjectInput can not instanciate." + this.objectInputClass.getName() + " cause " + e.toString());
            }
            catch (InvocationTargetException e) {
                throw new IOException("ObjectInput can not instanciate." + this.objectInputClass.getName() + " cause " + e.getTargetException().toString());
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object object;
        InflaterInputStream is;
        ByteArrayInputStream bais;
        block14: {
            if (this.compressMode == 0) {
                return this.readInternal(in);
            }
            boolean isCompressed = in.readBoolean();
            if (!isCompressed) {
                return this.readInternal(in);
            }
            int length = in.readInt();
            byte[] bytes = new byte[length];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int readLen = 0;
            int offset = 0;
            while ((readLen = in.read(bytes, offset, length - offset)) != -1) {
                baos.write(bytes, offset, readLen);
                if (length - (offset += readLen) != 0) continue;
            }
            bais = new ByteArrayInputStream(baos.toByteArray());
            is = null;
            Inflater inflater = null;
            switch (this.compressMode) {
                case 1: {
                    inflater = new Inflater();
                    is = this.bufferSize > 0 ? new InflaterInputStream(bais, inflater, this.bufferSize) : new InflaterInputStream(bais);
                    break;
                }
                case 2: {
                    is = new ZipInputStream(bais);
                    ((ZipInputStream)is).getNextEntry();
                    break;
                }
                case 3: {
                    is = this.bufferSize > 0 ? new GZIPInputStream((InputStream)bais, this.bufferSize) : new GZIPInputStream(bais);
                    break;
                }
                default: {
                    throw new IOException("Unknown compress mode : " + this.compressMode);
                }
            }
            ObjectInput oi = this.createObjectInput(is);
            try {
                object = this.readInternal(oi);
                Object var14_13 = null;
                if (inflater == null) break block14;
                inflater.end();
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (inflater != null) {
                    inflater.end();
                }
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                bais.close();
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        bais.close();
        return object;
    }

    protected Object readInternal(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.objectOutputClass != null) {
            this.setObjectOutputClass(this.objectOutputClass);
        }
        if (this.objectInputClass != null) {
            this.setObjectInputClass(this.objectInputClass);
        }
    }
}

