/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.ga.DefaultSeedMatchMakerServiceMBean;
import jp.ossc.nimbus.service.ga.Generation;
import jp.ossc.nimbus.service.ga.Seed;
import jp.ossc.nimbus.service.ga.SeedMatchMaker;

public class DefaultSeedMatchMakerService
extends ServiceBase
implements SeedMatchMaker,
DefaultSeedMatchMakerServiceMBean {
    private static final long serialVersionUID = -6748323121363696276L;
    protected static final int FITNESS_TYPE_LONG = 1;
    protected static final int FITNESS_TYPE_DOUBLE = 2;
    protected static final int FITNESS_TYPE_BIGINTEGER = 3;
    protected static final int FITNESS_TYPE_BIGDECIMAL = 4;
    protected float eliteRate;
    protected float dropRate;
    protected float newRate;
    protected int matchMakeMethod = 1;
    protected boolean isContanisEliteInMatchMake = true;

    public void setEliteRate(float rate) throws IllegalArgumentException {
        if (rate < 0.0f || rate >= 1.0f) {
            throw new IllegalArgumentException("0.0 <= EliteRate < 1.0. rate=" + rate);
        }
        this.eliteRate = rate;
    }

    public float getEliteRate() {
        return this.eliteRate;
    }

    public void setDropRate(float rate) throws IllegalArgumentException {
        if (rate < 0.0f || rate >= 1.0f) {
            throw new IllegalArgumentException("0.0 <= DropRate < 1.0. rate=" + rate);
        }
        this.dropRate = rate;
    }

    public float getDropRate() {
        return this.dropRate;
    }

    public void setNewRate(float rate) throws IllegalArgumentException {
        if (rate < 0.0f || rate >= 1.0f) {
            throw new IllegalArgumentException("0.0 <= NewRate < 1.0. rate=" + rate);
        }
        this.newRate = rate;
    }

    public float getNewRate() {
        return this.newRate;
    }

    public void setMatchMakeMethod(int method) throws IllegalArgumentException {
        switch (method) {
            case 1: 
            case 2: {
                this.matchMakeMethod = method;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method. method=" + method);
            }
        }
    }

    public int getMatchMakeMethod() {
        return this.matchMakeMethod;
    }

    public void setContanisEliteInMatchMake(boolean isContanis) {
        this.isContanisEliteInMatchMake = isContanis;
    }

    public boolean isContanisEliteInMatchMake() {
        return this.isContanisEliteInMatchMake;
    }

    public void startService() throws Exception {
        if (this.dropRate + this.eliteRate > 1.0f) {
            throw new IllegalArgumentException("EliteRate + DropRate <= 1.0. eliteRate=" + this.eliteRate + ", dropRate=" + this.dropRate);
        }
    }

    public SeedMatchMaker.MatchMakeResult matchMake(Random random, Generation generation, int index, SeedMatchMaker.MatchMakeResult result) {
        Seed[] seeds = generation.getSeeds();
        MatchMakeResultImpl resultImpl = (MatchMakeResultImpl)result;
        if (resultImpl == null) {
            resultImpl = new MatchMakeResultImpl();
        }
        int memberSize = seeds.length;
        if (resultImpl.toIndex == -1) {
            resultImpl.toIndex = memberSize;
            int i = seeds.length;
            while (--i >= 0) {
                if (seeds[i].getFitness() == null) continue;
                resultImpl.toIndex = i + 1;
                break;
            }
            if (this.dropRate > 0.0f) {
                resultImpl.toIndex = Math.min(resultImpl.toIndex, memberSize - Math.round((float)memberSize * this.dropRate));
            }
        }
        if (resultImpl.fromIndex == -1) {
            if (this.eliteRate > 0.0f) {
                if (resultImpl.eliteSize == -1) {
                    resultImpl.eliteSize = Math.round((float)memberSize * this.eliteRate);
                }
                if (index < resultImpl.eliteSize) {
                    resultImpl.pair[0] = seeds[index];
                    resultImpl.pair[1] = null;
                    return resultImpl;
                }
                resultImpl.fromIndex = Math.min(resultImpl.toIndex, this.isContanisEliteInMatchMake ? 0 : resultImpl.eliteSize);
            } else {
                resultImpl.fromIndex = 0;
            }
        }
        if (resultImpl.newIndex == -1) {
            resultImpl.newIndex = this.newRate > 0.0f ? memberSize - Math.round((float)memberSize * this.newRate) : 0;
        }
        if (resultImpl.newIndex > 0 && index >= resultImpl.newIndex) {
            resultImpl.pair[0] = seeds[index].cloneSeed();
            resultImpl.pair[0].getGenom().random(random);
            resultImpl.pair[1] = null;
            return resultImpl;
        }
        if (resultImpl.fromIndex < resultImpl.toIndex) {
            switch (this.matchMakeMethod) {
                case 2: {
                    return this.matchMakeRoulette(random, seeds, generation.getFitnessOrder(), resultImpl);
                }
            }
            return this.matchMakeRandom(random, seeds, resultImpl);
        }
        resultImpl.pair = null;
        return resultImpl;
    }

    protected SeedMatchMaker.MatchMakeResult matchMakeRandom(Random random, Seed[] seeds, MatchMakeResultImpl result) {
        int index1 = random.nextInt(result.toIndex - result.fromIndex);
        int index2 = 0;
        while (index1 == (index2 = random.nextInt(result.toIndex - result.fromIndex))) {
        }
        result.pair[0] = seeds[index1 + result.fromIndex];
        result.pair[1] = seeds[index2 + result.fromIndex];
        return result;
    }

    protected SeedMatchMaker.MatchMakeResult matchMakeRoulette(Random random, Seed[] seeds, boolean isAsc, MatchMakeResultImpl result) {
        int i;
        if (result.totalFitness == null) {
            int fitnessType = 1;
            Number fitness = seeds[0].getFitness();
            if (fitness == null) {
                return this.matchMakeRandom(random, seeds, result);
            }
            Number totalFitnessNumber = null;
            Number baseFitnessNumber = null;
            int baseIndex = result.toIndex == seeds.length ? result.toIndex - 1 : (seeds[result.toIndex].getFitness() == null ? result.toIndex - 1 : result.toIndex);
            result.fitnessSumList = new ArrayList();
            if (fitness instanceof Byte || fitness instanceof Short || fitness instanceof Integer || fitness instanceof Long) {
                fitnessType = 1;
                totalFitnessNumber = BigInteger.valueOf(0L);
                baseFitnessNumber = BigInteger.valueOf(seeds[baseIndex].getFitness().longValue());
            } else if (fitness instanceof Float || fitness instanceof Double) {
                fitnessType = 2;
                totalFitnessNumber = new BigDecimal(0.0);
                baseFitnessNumber = new BigDecimal(seeds[baseIndex].getFitness().doubleValue());
            } else if (fitness instanceof BigInteger) {
                fitnessType = 3;
                totalFitnessNumber = BigInteger.valueOf(0L);
                baseFitnessNumber = (BigInteger)seeds[baseIndex].getFitness();
            } else if (fitness instanceof BigDecimal) {
                fitnessType = 4;
                totalFitnessNumber = new BigDecimal(0.0);
                baseFitnessNumber = (BigDecimal)seeds[baseIndex].getFitness();
            }
            block10: for (int i2 = result.fromIndex; i2 < result.toIndex; ++i2) {
                fitness = seeds[i2].getFitness();
                switch (fitnessType) {
                    case 1: {
                        totalFitnessNumber = ((BigInteger)totalFitnessNumber).add(BigInteger.valueOf(Math.abs(fitness.longValue() - baseFitnessNumber.longValue())));
                        result.fitnessSumList.add(new BigDecimal((BigInteger)totalFitnessNumber));
                        continue block10;
                    }
                    case 2: {
                        result.totalFitness = ((BigDecimal)totalFitnessNumber).add(new BigDecimal(Math.abs(fitness.doubleValue() - baseFitnessNumber.doubleValue())));
                        result.fitnessSumList.add((BigDecimal)totalFitnessNumber);
                        continue block10;
                    }
                    case 3: {
                        totalFitnessNumber = ((BigInteger)totalFitnessNumber).add(((BigInteger)fitness).subtract((BigInteger)baseFitnessNumber).abs());
                        result.fitnessSumList.add(new BigDecimal((BigInteger)totalFitnessNumber));
                        continue block10;
                    }
                    case 4: {
                        result.totalFitness = ((BigDecimal)totalFitnessNumber).add(((BigDecimal)fitness).subtract((BigDecimal)baseFitnessNumber).abs());
                        result.fitnessSumList.add((BigDecimal)totalFitnessNumber);
                    }
                }
            }
            switch (fitnessType) {
                case 1: 
                case 3: {
                    result.totalFitness = new BigDecimal((BigInteger)totalFitnessNumber);
                    break;
                }
                case 2: 
                case 4: {
                    result.totalFitness = (BigDecimal)totalFitnessNumber;
                }
            }
        }
        BigDecimal target = new BigDecimal(random.nextDouble()).multiply(result.totalFitness);
        BigDecimal targetFitness = null;
        int targetIndex = 0;
        int imax = result.fitnessSumList.size();
        for (i = 0; i < imax; ++i) {
            BigDecimal sum = (BigDecimal)result.fitnessSumList.get(i);
            if (sum.compareTo(target) < 0) continue;
            result.pair[0] = seeds[i + result.fromIndex];
            targetFitness = i == 0 ? sum : sum.subtract((BigDecimal)result.fitnessSumList.get(i - 1));
            targetIndex = i;
            break;
        }
        target = new BigDecimal(random.nextDouble()).multiply(result.totalFitness.subtract(targetFitness));
        imax = result.fitnessSumList.size();
        for (i = 0; i < imax; ++i) {
            BigDecimal sum = (BigDecimal)result.fitnessSumList.get(i);
            if (i == targetIndex) continue;
            if (i > targetIndex) {
                sum = sum.subtract(targetFitness);
            }
            if (sum.compareTo(target) < 0) continue;
            result.pair[1] = seeds[i + result.fromIndex];
            break;
        }
        return result;
    }

    protected class MatchMakeResultImpl
    implements SeedMatchMaker.MatchMakeResult {
        public Seed[] pair = new Seed[2];
        public int eliteSize = -1;
        public int fromIndex = -1;
        public int toIndex = -1;
        public int newIndex = -1;
        public BigDecimal totalFitness;
        public List fitnessSumList;

        protected MatchMakeResultImpl() {
        }

        public Seed[] getPair() {
            return this.pair;
        }
    }
}

