/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.service.context.SharedContextIndex;

public class SharedContextIndexManager
implements Externalizable,
Cloneable {
    protected Map nameIndexMap = new HashMap();
    protected Map singleIndexMap = new HashMap();
    protected Map complexIndexMap = new HashMap();
    protected Set keySet = new HashSet();

    public void setIndex(String name, String[] props) {
        SharedContextIndex index = new SharedContextIndex(name, props);
        this.setIndexInternal(name, index, false);
    }

    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        SharedContextIndex index = new SharedContextIndex(name, keyFactory);
        this.setIndexInternal(name, index, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setIndexInternal(String name, SharedContextIndex index, boolean containsDummyProp) {
        Set indexedPropertyNames = index.getIndexedPropertyNames();
        if (indexedPropertyNames.size() == 1) {
            String propName = (String)indexedPropertyNames.iterator().next();
            if (this.singleIndexMap.containsKey(propName)) {
                SharedContextIndex singleIndex = (SharedContextIndex)this.singleIndexMap.get(propName);
                if (singleIndex.getName() != null) throw new IllegalArgumentException("Duplicate index. newIndex=" + name + ", duplicateIndex=" + singleIndex.getName());
                singleIndex.setName(name);
                index = singleIndex;
            } else {
                this.singleIndexMap.put(propName, index);
            }
        } else {
            if (this.complexIndexMap.containsKey(indexedPropertyNames)) {
                throw new IllegalArgumentException("Duplicate index. newIndex=" + name + ", duplicateIndex=" + ((SharedContextIndex)this.complexIndexMap.get(indexedPropertyNames)).getName());
            }
            this.complexIndexMap.put(indexedPropertyNames, index);
            Iterator itr = indexedPropertyNames.iterator();
            while (itr.hasNext()) {
                String propName = (String)itr.next();
                SharedContextIndex singleIndex = (SharedContextIndex)this.singleIndexMap.get(propName);
                if (singleIndex == null) {
                    singleIndex = new SharedContextIndex(new String[]{propName});
                    this.singleIndexMap.put(propName, singleIndex);
                }
                singleIndex.addLinkedIndex(name);
            }
        }
        this.nameIndexMap.put(name, index);
    }

    public void removeIndex(String name) {
        SharedContextIndex index = (SharedContextIndex)this.nameIndexMap.remove(name);
        if (index == null) {
            return;
        }
        Set indexedPropertyNames = index.getIndexedPropertyNames();
        if (indexedPropertyNames.size() == 1) {
            String propName = (String)indexedPropertyNames.iterator().next();
            SharedContextIndex singleIndex = (SharedContextIndex)this.singleIndexMap.get(propName);
            if (singleIndex.getLinkedIndexSet().size() == 0) {
                this.singleIndexMap.remove(propName);
            } else {
                singleIndex.setName(null);
            }
        } else {
            this.complexIndexMap.remove(indexedPropertyNames);
            Iterator itr = indexedPropertyNames.iterator();
            while (itr.hasNext()) {
                String propName = (String)itr.next();
                SharedContextIndex singleIndex = (SharedContextIndex)this.singleIndexMap.get(propName);
                singleIndex.removeLinkedIndex(name);
                if (singleIndex.getName() != null || singleIndex.getLinkedIndexSet().size() != 0) continue;
                this.singleIndexMap.remove(propName);
            }
        }
    }

    public SharedContextIndex getIndex(String name) {
        return (SharedContextIndex)this.nameIndexMap.get(name);
    }

    public SharedContextIndex getIndexBy(String[] propNames) {
        if (propNames.length == 1) {
            return (SharedContextIndex)this.singleIndexMap.get(propNames[0]);
        }
        HashSet<String> keys = new HashSet<String>(5);
        for (int i = 0; i < propNames.length; ++i) {
            keys.add(propNames[i]);
        }
        return (SharedContextIndex)this.complexIndexMap.get(keys);
    }

    public SharedContextIndex getIndexBy(Set propNames) {
        if (propNames.size() == 1) {
            return (SharedContextIndex)this.singleIndexMap.get(propNames.iterator().next());
        }
        return (SharedContextIndex)this.complexIndexMap.get(propNames);
    }

    public boolean hasIndex(String name, String propName) {
        return this.hasIndex(name, new String[]{propName});
    }

    public boolean hasIndex(String name, String[] propNames) {
        if (this.getIndex(name) != null) {
            return true;
        }
        return this.getIndexBy(propNames) != null;
    }

    public boolean hasIndex() {
        return !this.nameIndexMap.isEmpty();
    }

    public synchronized boolean add(Object key, Object value) throws IndexPropertyAccessException {
        SharedContextIndex index;
        if (!this.keySet.add(key)) {
            return false;
        }
        Iterator itr = this.singleIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.add(key, value);
        }
        itr = this.complexIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.add(key, value);
        }
        return true;
    }

    public synchronized void remove(Object key, Object value) throws IndexPropertyAccessException {
        SharedContextIndex index;
        Iterator itr = this.singleIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.remove(key, value);
        }
        itr = this.complexIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.remove(key, value);
        }
        this.keySet.remove(key);
    }

    public synchronized void replace(Object key, Object oldValue, Object newValue) throws IndexPropertyAccessException {
        SharedContextIndex index;
        Iterator itr = this.singleIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.replace(key, oldValue, newValue);
        }
        itr = this.complexIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.replace(key, oldValue, newValue);
        }
    }

    public synchronized boolean addAll(Map c) {
        boolean modify = false;
        Iterator entries = c.entrySet().iterator();
        while (entries.hasNext()) {
            SharedContextIndex index;
            Map.Entry entry = entries.next();
            if (!this.keySet.add(entry.getKey())) continue;
            Iterator itr = this.singleIndexMap.values().iterator();
            while (itr.hasNext()) {
                index = (SharedContextIndex)itr.next();
                index.add(entry.getKey(), entry.getValue());
            }
            itr = this.complexIndexMap.values().iterator();
            while (itr.hasNext()) {
                index = (SharedContextIndex)itr.next();
                index.add(entry.getKey(), entry.getValue());
            }
            modify |= true;
        }
        return modify;
    }

    public synchronized void retainAll(Map c) {
        Iterator keys = this.keySet.iterator();
        while (keys.hasNext()) {
            SharedContextIndex index;
            Object key = keys.next();
            if (c.containsKey(key)) continue;
            Iterator itr = this.singleIndexMap.values().iterator();
            while (itr.hasNext()) {
                index = (SharedContextIndex)itr.next();
                index.remove(key, c.get(key));
            }
            itr = this.complexIndexMap.values().iterator();
            while (itr.hasNext()) {
                index = (SharedContextIndex)itr.next();
                index.remove(key, c.get(key));
            }
            keys.remove();
        }
    }

    public synchronized void clear() {
        SharedContextIndex index;
        Iterator itr = this.singleIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.clear();
        }
        itr = this.complexIndexMap.values().iterator();
        while (itr.hasNext()) {
            index = (SharedContextIndex)itr.next();
            index.clear();
        }
        this.keySet.clear();
    }

    public Set keySet() {
        return this.keySet(null);
    }

    public synchronized Set keySet(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(this.keySet);
        return result;
    }

    public Set searchNull(String indexName, String propName) throws IndexNotFoundException {
        return this.searchNull(null, indexName, propName);
    }

    public Set searchNull(Set result, String indexName, String propName) throws IndexNotFoundException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchNull(result);
    }

    public Set searchNotNull(String indexName, String propName) throws IndexNotFoundException {
        return this.searchNotNull(null, indexName, propName);
    }

    public Set searchNotNull(Set result, String indexName, String propName) throws IndexNotFoundException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchNotNull(result);
    }

    public Set searchKey(String indexName, String[] propNames) throws IndexNotFoundException {
        return this.searchKey(null, indexName, propNames);
    }

    public Set searchKey(Set result, String indexName, String[] propNames) throws IndexNotFoundException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchKey(result);
    }

    public Object searchByPrimary(Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchByPrimary(value);
    }

    public Set searchBy(Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchBy(null, value, indexName, propNames);
    }

    public Set searchBy(Set result, Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchBy(result, value);
    }

    public Set searchIn(String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchIn(null, indexName, propNames, values);
    }

    public Set searchIn(Set result, String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchIn(result, values);
    }

    public Set searchByProperty(Object prop, String indexName, String propName) {
        return this.searchByProperty(null, prop, indexName, propName);
    }

    public Set searchByProperty(Set result, Object prop, String indexName, String propName) {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchByProperty(result, prop);
    }

    public Set searchInProperty(String indexName, String propName, Object[] props) {
        return this.searchInProperty(null, indexName, propName, props);
    }

    public Set searchInProperty(Set result, String indexName, String propName, Object[] props) {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchInProperty(result, props);
    }

    public Set searchByProperty(Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException {
        return this.searchByProperty(null, props, indexName);
    }

    public Set searchByProperty(Set result, Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(props.keySet()) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchByProperty(result, props);
    }

    public Set searchInProperty(String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException {
        return this.searchInProperty((Set)null, indexName, props);
    }

    public Set searchInProperty(Set result, String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(props[0].keySet()) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchInProperty(result, props);
    }

    public Set searchFrom(Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchFrom(null, fromValue, indexName, propName);
    }

    public Set searchFrom(Set result, Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchFrom(result, fromValue);
    }

    public Set searchFromProperty(Object fromProp, String indexName, String propName) throws IndexNotFoundException {
        return this.searchFromProperty(null, fromProp, indexName, propName);
    }

    public Set searchFromProperty(Set result, Object fromProp, String indexName, String propName) throws IndexNotFoundException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchFromProperty(result, fromProp);
    }

    public Set searchTo(Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchTo(null, toValue, indexName, propName);
    }

    public Set searchTo(Set result, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchTo(result, toValue);
    }

    public Set searchToProperty(Object toProp, String indexName, String propName) throws IndexNotFoundException {
        return this.searchToProperty(null, toProp, indexName, propName);
    }

    public Set searchToProperty(Set result, Object toProp, String indexName, String propName) throws IndexNotFoundException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchToProperty(result, toProp);
    }

    public Set searchRange(Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchRange(null, fromValue, toValue, indexName, propName);
    }

    public Set searchRange(Set result, Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchRange(result, fromValue, toValue);
    }

    public Set searchRangeProperty(Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException {
        return this.searchRangeProperty(null, fromProp, toProp, indexName, propName);
    }

    public Set searchRangeProperty(Set result, Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException {
        SharedContextIndex index;
        SharedContextIndex sharedContextIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchRangeProperty(result, fromProp, toProp);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out, boolean writeValue) throws IOException {
        SharedContextIndexManager sharedContextIndexManager = this;
        synchronized (sharedContextIndexManager) {
            Map.Entry entry;
            out.writeInt(this.nameIndexMap.size());
            Iterator<Object> itr = this.nameIndexMap.values().iterator();
            while (itr.hasNext()) {
                SharedContextIndex index = (SharedContextIndex)itr.next();
                index.writeExternal(out, writeValue);
            }
            out.writeInt(this.singleIndexMap.size());
            itr = this.singleIndexMap.entrySet().iterator();
            while (itr.hasNext()) {
                entry = (Map.Entry)itr.next();
                out.writeObject(entry.getKey());
                ((SharedContextIndex)entry.getValue()).writeExternal(out, writeValue);
            }
            out.writeInt(this.complexIndexMap.size());
            itr = this.complexIndexMap.entrySet().iterator();
            while (itr.hasNext()) {
                entry = (Map.Entry)itr.next();
                out.writeObject(entry.getKey());
                ((SharedContextIndex)entry.getValue()).writeExternal(out, writeValue);
            }
            if (writeValue) {
                out.writeObject(this.keySet);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, true);
    }

    public void readExternal(ObjectInput in, boolean readValue) throws IOException, ClassNotFoundException {
        SharedContextIndex index;
        int i;
        this.nameIndexMap = new HashMap();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            index = new SharedContextIndex();
            index.readExternal(in, readValue);
            this.nameIndexMap.put(index.getName(), index);
        }
        this.singleIndexMap = new HashMap();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            index = new SharedContextIndex();
            String propName = (String)in.readObject();
            index.readExternal(in, readValue);
            this.singleIndexMap.put(propName, index);
        }
        this.complexIndexMap = new HashMap();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            index = new SharedContextIndex();
            Set propNames = (Set)in.readObject();
            index.readExternal(in, readValue);
            this.complexIndexMap.put(propNames, index);
        }
        this.keySet = readValue ? (HashSet)in.readObject() : new HashSet();
    }

    public SharedContextIndexManager cloneEmpty() {
        SharedContextIndexManager clone = null;
        try {
            clone = (SharedContextIndexManager)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.nameIndexMap = new HashMap();
        clone.singleIndexMap = new HashMap();
        clone.complexIndexMap = new HashMap();
        Iterator itr = this.nameIndexMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            clone.setIndexInternal((String)entry.getKey(), ((SharedContextIndex)entry.getValue()).cloneEmpty(), true);
        }
        clone.keySet = new HashSet();
        return clone;
    }

    public SharedContextIndexManager clone(Map c) {
        SharedContextIndexManager clone = this.cloneEmpty();
        clone.addAll(c);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceIndex(String name, Map c) {
        SharedContextIndex index = this.getIndex(name);
        if (index == null) {
            return;
        }
        Set linkedNames = index.getLinkedIndexSet();
        if (linkedNames.size() != 0) {
            Iterator itr = linkedNames.iterator();
            while (itr.hasNext()) {
                SharedContextIndex linkedIndex;
                String linkedName = (String)itr.next();
                SharedContextIndex sharedContextIndex = linkedIndex = (SharedContextIndex)this.complexIndexMap.get(linkedName);
                synchronized (sharedContextIndex) {
                    linkedIndex.clear();
                    linkedIndex.addAll(c);
                }
            }
        }
        SharedContextIndex sharedContextIndex = index;
        synchronized (sharedContextIndex) {
            index.clear();
            index.addAll(c);
        }
    }

    public SharedContextIndex createTemporaryIndex(Set resultSet, String indexName, String propName) throws IndexNotFoundException {
        return this.createTemporaryIndex(resultSet, indexName, new String[]{propName});
    }

    public SharedContextIndex createTemporaryIndex(Set resultSet, String indexName, String[] propNames) throws IndexNotFoundException {
        SharedContextIndex index = null;
        if (indexName != null) {
            index = this.getIndex(indexName);
        }
        if (index == null && propNames != null && propNames.length != 0) {
            index = this.getIndexBy(propNames);
        }
        if (index == null) {
            throw new IndexNotFoundException();
        }
        index = index.clone(resultSet);
        return index;
    }
}

