/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.io.Externalizer;

public class FileCachedReference
extends DefaultCachedReference
implements Serializable {
    private static final long serialVersionUID = -1164595696487398731L;
    private transient Externalizer externalizer;

    public FileCachedReference(File file) {
        super(file);
    }

    public FileCachedReference(File file, Externalizer ext) {
        super(file);
        this.externalizer = ext;
    }

    public FileCachedReference(File file, Object obj) throws IOException {
        super(file);
        this.serializeObject(file, obj);
    }

    public FileCachedReference(File file, Object obj, Externalizer ext) throws IOException {
        super(file);
        this.externalizer = ext;
        this.serializeObject(file, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serializeObject(File file, Object obj) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            if (this.externalizer == null) {
                ObjectOutputStream oos = new ObjectOutputStream(os);
                if (obj != null) {
                    Object object = obj;
                    synchronized (object) {
                        oos.writeObject(obj);
                    }
                } else {
                    oos.writeObject(obj);
                }
                oos.flush();
            } else if (obj != null) {
                Object object = obj;
                synchronized (object) {
                    this.externalizer.writeExternal(obj, os);
                }
            } else {
                this.externalizer.writeExternal(obj, os);
            }
            Object var9_9 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (os == null) throw throwable;
            try {
                ((OutputStream)os).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)os).close();
            return;
        }
        catch (IOException e) {}
    }

    public Object deserializeObject() throws IOException, ClassNotFoundException {
        return this.deserializeObject(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserializeObject(File file) throws IOException, ClassNotFoundException {
        Object entry = null;
        FileInputStream is = new FileInputStream(file);
        try {
            if (this.externalizer == null) {
                ObjectInputStream ois = new ObjectInputStream(is);
                entry = ois.readObject();
            } else {
                entry = this.externalizer.readExternal(is);
            }
            Object var6_5 = null;
            if (is == null) return entry;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)is).close();
            return entry;
        }
        catch (IOException ex) {}
        return entry;
    }

    public File getFile() {
        return (File)super.get(null, false);
    }

    public Object get(Object source, boolean notify) {
        Object obj = super.get(source, notify);
        if (obj instanceof File) {
            File file = (File)obj;
            if (file.exists() && file.canRead()) {
                try {
                    return this.deserializeObject(file);
                }
                catch (IOException e) {
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }
        return obj;
    }

    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        if (obj != null) {
            try {
                this.serializeObject((File)this.cacheObj, obj);
            }
            catch (IOException e) {
                throw new IllegalCachedReferenceException(e);
            }
        } else {
            ((File)this.cacheObj).delete();
        }
    }

    public void remove(Object source) {
        if (this.cacheObj != null) {
            this.notifyRemoved(source);
            File file = (File)this.cacheObj;
            if (file.exists() && file.canRead()) {
                ((File)this.cacheObj).delete();
            }
            this.cacheObj = null;
            if (this.linkedReferences != null) {
                this.linkedReferences.clear();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeSet(out, this.linkedReferences);
        this.writeSet(out, this.removeListeners);
        this.writeSet(out, this.accessListeners);
        this.writeSet(out, this.changeListeners);
        ServiceName name = null;
        if (this.externalizer != null) {
            name = this.getServiceName(this.externalizer);
        }
        if (name != null) {
            out.writeObject(name);
        } else {
            out.writeObject(this.externalizer);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.linkedReferences = this.readSet(in);
        this.removeListeners = this.readSet(in);
        this.accessListeners = this.readSet(in);
        this.changeListeners = this.readSet(in);
        Object obj = in.readObject();
        if (obj != null) {
            this.externalizer = obj instanceof ServiceName ? (Externalizer)ServiceManagerFactory.getServiceObject((ServiceName)obj) : (Externalizer)obj;
        }
    }
}

