/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MetricsInfo;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestMetricsInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class HttpServletRequestMetricsInterceptorService
extends ServletFilterInterceptorService
implements DaemonRunnable,
HttpServletRequestMetricsInterceptorServiceMBean {
    private static final long serialVersionUID = -8746150658855433357L;
    private static final Comparator COMP = new MetricsInfoComparator();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Map metricsInfos;
    private boolean isEnabled = true;
    private boolean isCalculateOnlyNormal;
    private String dateFormat = "HH:mm:ss.SSS";
    private long outputInterval = 60000L;
    private boolean isResetByOutput;
    private Properties pathAndCategoryServiceNameMapping;
    private Map pathAndCategoryMap;
    private Daemon writerDaemon;
    private ServiceName categoryServiceName;
    private Category metricsCategory;
    private boolean isOutputTimestamp = false;
    private boolean isOutputCount = true;
    private boolean isOutputExceptionCount = false;
    private boolean isOutputErrorCount = false;
    private boolean isOutputLastTime = false;
    private boolean isOutputLastExceptionTime = false;
    private boolean isOutputLastErrorTime = false;
    private boolean isOutputBestPerformance = true;
    private boolean isOutputBestPerformanceTime = false;
    private boolean isOutputWorstPerformance = true;
    private boolean isOutputWorstPerformanceTime = false;
    private boolean isOutputAveragePerformance = true;

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setCalculateOnlyNormal(boolean isCalc) {
        this.isCalculateOnlyNormal = isCalc;
    }

    public boolean isCalculateOnlyNormal() {
        return this.isCalculateOnlyNormal;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String displayMetricsInfo() {
        MetricsInfo[] infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
        Arrays.sort(infos, COMP);
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        StringBuffer buf = new StringBuffer();
        buf.append("\"No.\"");
        if (this.isOutputCount) {
            buf.append(",\"Count\"");
        }
        if (this.isOutputExceptionCount) {
            buf.append(",\"ExceptionCount\"");
        }
        if (this.isOutputErrorCount) {
            buf.append(",\"ErrorCount\"");
        }
        if (this.isOutputLastTime) {
            buf.append(",\"LastTime\"");
        }
        if (this.isOutputLastExceptionTime) {
            buf.append(",\"LastExceptionTime\"");
        }
        if (this.isOutputLastErrorTime) {
            buf.append(",\"LastErrorTime\"");
        }
        if (this.isOutputBestPerformance) {
            buf.append(",\"Best performance[ms]\"");
        }
        if (this.isOutputBestPerformanceTime) {
            buf.append(",\"Best performance time\"");
        }
        if (this.isOutputWorstPerformance) {
            buf.append(",\"Worst performance[ms]\"");
        }
        if (this.isOutputWorstPerformanceTime) {
            buf.append(",\"Worst performance time\"");
        }
        if (this.isOutputAveragePerformance) {
            buf.append(",\"Average performance[ms]\"");
        }
        buf.append(",\"Path\"");
        buf.append(LINE_SEP);
        for (int i = 0; i < infos.length; ++i) {
            buf.append('\"').append(i + 1).append('\"');
            if (this.isOutputCount) {
                buf.append(',').append('\"').append(infos[i].getCount()).append('\"');
            }
            if (this.isOutputExceptionCount) {
                buf.append(',').append('\"').append(infos[i].getExceptionCount()).append('\"');
            }
            if (this.isOutputErrorCount) {
                buf.append(',').append('\"').append(infos[i].getErrorCount()).append('\"');
            }
            if (this.isOutputLastTime) {
                if (infos[i].getLastTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getLastTime()))).append('\"');
                }
            }
            if (this.isOutputLastExceptionTime) {
                if (infos[i].getLastExceptionTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getLastExceptionTime()))).append('\"');
                }
            }
            if (this.isOutputLastErrorTime) {
                if (infos[i].getLastErrorTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append('\"').append(',').append(format.format(new Date(infos[i].getLastErrorTime()))).append('\"');
                }
            }
            if (this.isOutputBestPerformance) {
                buf.append(',').append('\"').append(infos[i].getBestPerformance()).append('\"');
            }
            if (this.isOutputBestPerformanceTime) {
                if (infos[i].getBestPerformanceTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getBestPerformanceTime()))).append('\"');
                }
            }
            if (this.isOutputWorstPerformance) {
                buf.append(',').append('\"').append(infos[i].getWorstPerformance()).append('\"');
            }
            if (this.isOutputWorstPerformanceTime) {
                if (infos[i].getWorstPerformanceTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getWorstPerformanceTime()))).append('\"');
                }
            }
            if (this.isOutputAveragePerformance) {
                buf.append(',').append('\"').append(infos[i].getAveragePerformance()).append('\"');
            }
            buf.append(',').append('\"').append(infos[i].getKey()).append('\"');
            buf.append(LINE_SEP);
        }
        if (this.isOutputTimestamp) {
            buf.append(format.format(new Date())).append(LINE_SEP);
        }
        return buf.toString();
    }

    public void reset() {
        this.metricsInfos.clear();
    }

    public MetricsInfo getMetricsInfo(String path) {
        return (MetricsInfo)this.metricsInfos.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMetricsInfos() {
        if (this.metricsInfos == null) {
            return new HashMap();
        }
        Map map = this.metricsInfos;
        synchronized (map) {
            return new HashMap(this.metricsInfos);
        }
    }

    public void setOutputInterval(long interval) {
        this.outputInterval = interval;
    }

    public long getOutputInterval() {
        return this.outputInterval;
    }

    public void setResetByOutput(boolean isReset) {
        this.isResetByOutput = isReset;
    }

    public boolean isResetByOutput() {
        return this.isResetByOutput;
    }

    public void setPathAndCategoryServiceNameMapping(Properties mapping) {
        this.pathAndCategoryServiceNameMapping = mapping;
    }

    public Properties getPathAndCategoryServiceNameMapping() {
        return this.pathAndCategoryServiceNameMapping;
    }

    public void setCategoryServiceName(ServiceName name) {
        this.categoryServiceName = name;
    }

    public ServiceName getCategoryServiceName() {
        return this.categoryServiceName;
    }

    public void setOutputTimestamp(boolean isOutput) {
        this.isOutputTimestamp = isOutput;
    }

    public boolean isOutputTimestamp() {
        return this.isOutputTimestamp;
    }

    public void setOutputCount(boolean isOutput) {
        this.isOutputCount = isOutput;
    }

    public boolean isOutputCount() {
        return this.isOutputCount;
    }

    public void setOutputExceptionCount(boolean isOutput) {
        this.isOutputExceptionCount = isOutput;
    }

    public boolean isOutputExceptionCount() {
        return this.isOutputExceptionCount;
    }

    public void setOutputErrorCount(boolean isOutput) {
        this.isOutputErrorCount = isOutput;
    }

    public boolean isOutputErrorCount() {
        return this.isOutputErrorCount;
    }

    public void setOutputLastTime(boolean isOutput) {
        this.isOutputLastTime = isOutput;
    }

    public boolean isOutputLastTime() {
        return this.isOutputLastTime;
    }

    public void setOutputLastExceptionTime(boolean isOutput) {
        this.isOutputLastExceptionTime = isOutput;
    }

    public boolean isOutputLastExceptionTime() {
        return this.isOutputLastExceptionTime;
    }

    public void setOutputLastErrorTime(boolean isOutput) {
        this.isOutputLastErrorTime = isOutput;
    }

    public boolean isOutputLastErrorTime() {
        return this.isOutputLastErrorTime;
    }

    public void setOutputBestPerformance(boolean isOutput) {
        this.isOutputBestPerformance = isOutput;
    }

    public boolean isOutputBestPerformance() {
        return this.isOutputBestPerformance;
    }

    public void setOutputBestPerformanceTime(boolean isOutput) {
        this.isOutputBestPerformanceTime = isOutput;
    }

    public boolean isOutputBestPerformanceTime() {
        return this.isOutputBestPerformanceTime;
    }

    public void setOutputWorstPerformance(boolean isOutput) {
        this.isOutputWorstPerformance = isOutput;
    }

    public boolean isOutputWorstPerformance() {
        return this.isOutputWorstPerformance;
    }

    public void setOutputWorstPerformanceTime(boolean isOutput) {
        this.isOutputWorstPerformanceTime = isOutput;
    }

    public boolean isOutputWorstPerformanceTime() {
        return this.isOutputWorstPerformanceTime;
    }

    public void setOutputAveragePerformance(boolean isOutput) {
        this.isOutputAveragePerformance = isOutput;
    }

    public boolean isOutputAveragePerformance() {
        return this.isOutputAveragePerformance;
    }

    public void createService() throws Exception {
        this.metricsInfos = Collections.synchronizedMap(new HashMap());
        this.pathAndCategoryMap = new HashMap();
    }

    public void startService() throws Exception {
        this.metricsInfos.clear();
        if (this.pathAndCategoryServiceNameMapping != null && this.pathAndCategoryServiceNameMapping.size() != 0) {
            ServiceNameEditor nameEditor = new ServiceNameEditor();
            nameEditor.setServiceManagerName(this.getServiceManagerName());
            Iterator<Object> paths = this.pathAndCategoryServiceNameMapping.keySet().iterator();
            while (paths.hasNext()) {
                String path = (String)paths.next();
                String nameStr = this.pathAndCategoryServiceNameMapping.getProperty(path);
                nameEditor.setAsText(nameStr);
                ServiceName name = (ServiceName)nameEditor.getValue();
                Category category = (Category)ServiceManagerFactory.getServiceObject(name);
                this.pathAndCategoryMap.put(path, category);
            }
        }
        if (this.categoryServiceName != null) {
            this.metricsCategory = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceName);
        }
        if (this.pathAndCategoryMap != null && this.pathAndCategoryMap.size() != 0 || this.metricsCategory != null) {
            this.writerDaemon = new Daemon(this);
            this.writerDaemon.setName("Nimbus MetricsWriteDaemon " + this.getServiceNameObject());
            this.writerDaemon.start();
        }
    }

    public void stopService() throws Exception {
        System.out.println(this.displayMetricsInfo());
        if (this.writerDaemon != null) {
            this.writerDaemon.stop();
            this.writerDaemon = null;
        }
        this.pathAndCategoryMap.clear();
    }

    public void destroyService() throws Exception {
        this.metricsInfos = null;
        this.pathAndCategoryMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        Object object;
        long start = 0L;
        boolean isError = false;
        boolean isException = false;
        if (this.getState() == 3 && this.isEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                object = chain.invokeNext(context);
                Object var9_9 = null;
            }
            catch (Exception e) {
                isException = true;
                throw e;
            }
            catch (Error err) {
                isError = true;
                throw err;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.getState() != 3) throw throwable;
            if (!this.isEnabled()) throw throwable;
            long end = System.currentTimeMillis();
            ServletRequest sr = context.getServletRequest();
            if (!(sr instanceof HttpServletRequest)) throw throwable;
            HttpServletRequest hsr = (HttpServletRequest)sr;
            String path = hsr.getPathInfo();
            if (path == null) {
                path = hsr.getServletPath();
            }
            MetricsInfo metricsInfo = null;
            Map map = this.metricsInfos;
            synchronized (map) {
                metricsInfo = (MetricsInfo)this.metricsInfos.get(path);
                if (metricsInfo == null) {
                    metricsInfo = new MetricsInfo(path, this.isCalculateOnlyNormal);
                    this.metricsInfos.put(path, metricsInfo);
                }
                metricsInfo.calculate(end - start, isException, isError);
                throw throwable;
            }
        }
        if (this.getState() != 3) return object;
        if (!this.isEnabled()) return object;
        long end = System.currentTimeMillis();
        ServletRequest sr = context.getServletRequest();
        if (!(sr instanceof HttpServletRequest)) return object;
        HttpServletRequest hsr = (HttpServletRequest)sr;
        String path = hsr.getPathInfo();
        if (path == null) {
            path = hsr.getServletPath();
        }
        MetricsInfo metricsInfo = null;
        Map map = this.metricsInfos;
        synchronized (map) {
            metricsInfo = (MetricsInfo)this.metricsInfos.get(path);
            if (metricsInfo == null) {
                metricsInfo = new MetricsInfo(path, this.isCalculateOnlyNormal);
                this.metricsInfos.put(path, metricsInfo);
            }
            metricsInfo.calculate(end - start, isException, isError);
            return object;
        }
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        try {
            Thread.sleep(this.outputInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public void consume(Object dequeued, DaemonControl ctrl) {
        MetricsInfo[] infos;
        Date timestamp = new Date();
        if (this.pathAndCategoryMap != null && this.pathAndCategoryMap.size() != 0) {
            Iterator paths = this.pathAndCategoryMap.keySet().iterator();
            while (paths.hasNext()) {
                String path = (String)paths.next();
                Category category = (Category)this.pathAndCategoryMap.get(path);
                MetricsInfo info = (MetricsInfo)this.metricsInfos.get(path);
                if (info == null || category == null) continue;
                try {
                    category.write(this.createRecord(timestamp, info));
                }
                catch (MessageWriteException e) {}
            }
        }
        if (this.metricsCategory != null) {
            infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
            Arrays.sort(infos, COMP);
            for (int i = 0; i < infos.length; ++i) {
                try {
                    this.metricsCategory.write(this.createRecord(timestamp, i + 1, infos[i]));
                    continue;
                }
                catch (MessageWriteException e) {
                    // empty catch block
                }
            }
        }
        if (this.isResetByOutput) {
            infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
            for (int i = 0; i < infos.length; ++i) {
                infos[i].reset();
            }
        }
    }

    private Map createRecord(Date timestamp, MetricsInfo info) {
        return this.createRecord(timestamp, -1, info);
    }

    private Map createRecord(Date timestamp, int order, MetricsInfo info) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        if (this.isOutputTimestamp) {
            record.put("Timestamp", timestamp);
        }
        if (order > 0) {
            record.put("Order", new Integer(order));
        }
        record.put("Path", info.getKey());
        if (this.isOutputCount) {
            record.put("Count", new Long(info.getCount()));
        }
        if (this.isOutputExceptionCount) {
            record.put("ExceptionCount", new Long(info.getExceptionCount()));
        }
        if (this.isOutputErrorCount) {
            record.put("ErrorCount", new Long(info.getErrorCount()));
        }
        if (this.isOutputLastTime) {
            record.put("LastTime", info.getLastTime() == 0L ? null : new Date(info.getLastTime()));
        }
        if (this.isOutputLastExceptionTime) {
            record.put("LastExceptionTime", info.getLastExceptionTime() == 0L ? null : new Date(info.getLastExceptionTime()));
        }
        if (this.isOutputLastErrorTime) {
            record.put("LastErrorTime", info.getLastErrorTime() == 0L ? null : new Date(info.getLastErrorTime()));
        }
        if (this.isOutputBestPerformance) {
            record.put("BestPerformance", new Long(info.getBestPerformance()));
        }
        if (this.isOutputBestPerformanceTime) {
            record.put("BestPerformanceTime", info.getBestPerformanceTime() == 0L ? null : new Date(info.getBestPerformanceTime()));
        }
        if (this.isOutputWorstPerformance) {
            record.put("WorstPerformance", new Long(info.getWorstPerformance()));
        }
        if (this.isOutputWorstPerformanceTime) {
            record.put("WorstPerformanceTime", info.getWorstPerformanceTime() == 0L ? null : new Date(info.getWorstPerformanceTime()));
        }
        if (this.isOutputAveragePerformance) {
            record.put("AveragePerformance", new Long(info.getAveragePerformance()));
        }
        return record;
    }

    public void garbage() {
    }

    private static class MetricsInfoComparator
    implements Comparator {
        private MetricsInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            long sortKey2;
            MetricsInfo info1 = (MetricsInfo)o1;
            MetricsInfo info2 = (MetricsInfo)o2;
            long sortKey1 = info1.getAveragePerformance() * info1.getCount();
            if (sortKey1 > (sortKey2 = info2.getAveragePerformance() * info2.getCount())) {
                return -1;
            }
            if (sortKey1 < sortKey2) {
                return 1;
            }
            return 0;
        }
    }
}

