/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.recset.RecordSet;
import jp.ossc.nimbus.recset.RowData;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.BlockadeException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.BlockadeInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.BlockadeProcessException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.context.Context;

public class BlockadeInterceptorService
extends ServletFilterInterceptorService
implements BlockadeInterceptorServiceMBean {
    private static final long serialVersionUID = -1694588353473833851L;
    private String requestObjectAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    private Map specialUserMapping;
    private ServiceName codeMasterFinderServiceName;
    private CodeMasterFinder codeMasterFinder;
    private ServiceName threadContextServiceName;
    private Context threadContext;
    private String blockadeCodeMasterKey;
    private String specialUserCodeMasterKey;
    private String pathPropertyName = "path";
    private String statePropertyName = "state";
    private String messagePropertyName = "message";
    private PropertyAccess propertyAccess;
    private Map pathPatternMap;

    public void setRequestObjectAttributeName(String name) {
        this.requestObjectAttributeName = name;
    }

    public String getRequestObjectAttributeName() {
        return this.requestObjectAttributeName;
    }

    public void setSpecialUserMapping(Map mapping) {
        this.specialUserMapping = mapping;
    }

    public Map getSpecialUserMapping() {
        return this.specialUserMapping;
    }

    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setBlockadeCodeMasterKey(String key) {
        this.blockadeCodeMasterKey = key;
    }

    public String getBlockadeCodeMasterKey() {
        return this.blockadeCodeMasterKey;
    }

    public void setSpecialUserCodeMasterKey(String key) {
        this.specialUserCodeMasterKey = key;
    }

    public String getSpecialUserCodeMasterKey() {
        return this.specialUserCodeMasterKey;
    }

    public void setPathPropertyName(String name) {
        this.pathPropertyName = name;
    }

    public String getPathPropertyName() {
        return this.pathPropertyName;
    }

    public void setStatePropertyName(String name) {
        this.statePropertyName = name;
    }

    public String getStatePropertyName() {
        return this.statePropertyName;
    }

    public void setMessagePropertyName(String name) {
        this.messagePropertyName = name;
    }

    public String getMessagePropertyName() {
        return this.messagePropertyName;
    }

    public void setCodeMasterFinder(CodeMasterFinder finder) {
        this.codeMasterFinder = finder;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public void createService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(true);
    }

    public void startService() throws Exception {
        if (this.codeMasterFinderServiceName == null && this.codeMasterFinder == null && this.threadContextServiceName == null && this.threadContext == null) {
            throw new IllegalArgumentException("CodeMasterFinder or ThreadContext must be specified.");
        }
        if (this.blockadeCodeMasterKey == null) {
            throw new IllegalArgumentException("BlockadeCodeMasterKey must be specified.");
        }
        if (this.specialUserCodeMasterKey != null && (this.specialUserMapping == null || this.specialUserMapping.size() == 0)) {
            throw new IllegalArgumentException("SpecialUserMapping must be specified.");
        }
        if (this.codeMasterFinderServiceName != null) {
            this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        this.pathPatternMap = null;
    }

    public void destroyService() throws Exception {
        this.propertyAccess = null;
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
        String reqPath = request.getPathInfo();
        if (reqPath == null) {
            reqPath = request.getServletPath();
        }
        Map codeMasters = null;
        codeMasters = this.codeMasterFinder != null ? this.codeMasterFinder.getCodeMasters() : (Map)this.threadContext.get("CODE_MASTER");
        if (codeMasters == null) {
            throw new BlockadeProcessException("CodeMaster is null.");
        }
        Object blockadeCodeMaster = codeMasters.get(this.blockadeCodeMasterKey);
        if (blockadeCodeMaster == null) {
            throw new BlockadeProcessException("BlockadeCodeMaster is null. key=" + this.blockadeCodeMasterKey);
        }
        Object specialUserCodeMaster = null;
        if (this.specialUserCodeMasterKey != null) {
            specialUserCodeMaster = codeMasters.get(this.specialUserCodeMasterKey);
        }
        boolean isSpecialUser = false;
        String userKey = null;
        if (specialUserCodeMaster != null) {
            Cloneable primaryKey;
            Object requestObject = request.getAttribute(this.requestObjectAttributeName);
            if (requestObject == null) {
                throw new BlockadeProcessException("RequestObject is null.");
            }
            if (specialUserCodeMaster instanceof RecordList) {
                RecordList list = (RecordList)specialUserCodeMaster;
                primaryKey = list.createRecord();
                this.applySpecialUserMapping(requestObject, primaryKey);
                userKey = ((Record)primaryKey).toString();
                isSpecialUser = list.searchByPrimaryKey((Record)primaryKey) != null;
            } else if (specialUserCodeMaster instanceof RecordSet) {
                RecordSet recset = (RecordSet)specialUserCodeMaster;
                primaryKey = recset.createNewRecord();
                this.applySpecialUserMapping(requestObject, primaryKey);
                userKey = ((RowData)primaryKey).getKey();
                isSpecialUser = recset.get((RowData)primaryKey) != null;
            } else {
                throw new BlockadeProcessException("Unsupported type of SpecialUserCodeMaster. type=" + specialUserCodeMaster.getClass());
            }
        }
        if (this.pathPatternMap == null) {
            this.initPathPatternMap(blockadeCodeMaster);
        }
        if (blockadeCodeMaster instanceof List) {
            List list = (List)blockadeCodeMaster;
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                this.checkBlockade(reqPath, list.get(i), isSpecialUser, userKey);
            }
        } else if (blockadeCodeMaster instanceof RecordSet) {
            RecordSet recset = (RecordSet)blockadeCodeMaster;
            int imax = recset.size();
            for (int i = 0; i < imax; ++i) {
                this.checkBlockade(reqPath, recset.get(i), isSpecialUser, userKey);
            }
        } else {
            throw new BlockadeProcessException("Unsupported type of BlockadeCodeMaster. type=" + blockadeCodeMaster.getClass());
        }
        return chain.invokeNext(context);
    }

    private Object applySpecialUserMapping(Object requestObject, Object primaryKey) throws BlockadeProcessException {
        Iterator entries = this.specialUserMapping.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object key = null;
            try {
                key = this.propertyAccess.get(requestObject, (String)entry.getKey());
            }
            catch (IllegalArgumentException e) {
                throw new BlockadeProcessException("SpecialUserCodeMaster value '" + entry.getKey() + "' cannot acquire from a request.", e);
            }
            catch (NoSuchPropertyException e) {
                throw new BlockadeProcessException("SpecialUserCodeMaster value '" + entry.getKey() + "' cannot acquire from a request.", e);
            }
            catch (InvocationTargetException e) {
                throw new BlockadeProcessException("SpecialUserCodeMaster value '" + entry.getKey() + "' cannot acquire from a request.", e.getTargetException());
            }
            try {
                this.propertyAccess.set(primaryKey, (String)entry.getValue(), key);
            }
            catch (IllegalArgumentException e) {
                throw new BlockadeProcessException("SpecialUserCodeMaster value '" + entry.getKey() + "' cannot set to a record.", e);
            }
            catch (NoSuchPropertyException e) {
                throw new BlockadeProcessException("SpecialUserCodeMaster value '" + entry.getKey() + "' cannot set to a record.", e);
            }
            catch (InvocationTargetException e) {
                throw new BlockadeProcessException("SpecialUserCodeMaster value '" + entry.getKey() + "' cannot set to a record.", e.getTargetException());
            }
        }
        return primaryKey;
    }

    private synchronized void initPathPatternMap(Object blockadeCodeMaster) throws BlockadeProcessException {
        if (this.pathPatternMap != null) {
            return;
        }
        this.pathPatternMap = new HashMap();
        if (blockadeCodeMaster instanceof List) {
            List list = (List)blockadeCodeMaster;
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                this.initPathPatternMap(this.pathPatternMap, list.get(i));
            }
        } else if (blockadeCodeMaster instanceof RecordSet) {
            RecordSet recset = (RecordSet)blockadeCodeMaster;
            int imax = recset.size();
            for (int i = 0; i < imax; ++i) {
                this.initPathPatternMap(this.pathPatternMap, recset.get(i));
            }
        } else {
            throw new BlockadeProcessException("Unsupported type of BlockadeCodeMaster. type=" + blockadeCodeMaster.getClass());
        }
    }

    private synchronized void initPathPatternMap(Map map, Object blockade) throws BlockadeProcessException {
        String path = null;
        try {
            path = (String)this.propertyAccess.get(blockade, this.pathPropertyName);
        }
        catch (ClassCastException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e);
        }
        catch (IllegalArgumentException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e);
        }
        catch (InvocationTargetException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e.getTargetException());
        }
        if (path == null) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' is null from a record.");
        }
        this.initPathPatternMap(map, path);
    }

    private synchronized void initPathPatternMap(Map map, String path) throws BlockadeProcessException {
        if (map.get(path) != null) {
            return;
        }
        try {
            map.put(path, Pattern.compile(path));
        }
        catch (PatternSyntaxException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot compile.", e);
        }
    }

    private void checkBlockade(String reqPath, Object blockade, boolean isSpecialUser, String userKey) throws BlockadeException, BlockadeProcessException {
        int state = 0;
        try {
            Object stateObject = this.propertyAccess.get(blockade, this.statePropertyName);
            if (stateObject == null) {
                throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.statePropertyName + "' is null from a record.");
            }
            if (stateObject instanceof Number) {
                state = ((Number)stateObject).intValue();
            } else if (stateObject instanceof String) {
                state = Integer.parseInt((String)stateObject);
            } else if (stateObject instanceof Boolean) {
                state = (Boolean)stateObject != false ? 1 : 0;
            }
        }
        catch (NumberFormatException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.statePropertyName + "' cannot acquire from a record.", e);
        }
        catch (IllegalArgumentException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.statePropertyName + "' cannot acquire from a record.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.statePropertyName + "' cannot acquire from a record.", e);
        }
        catch (InvocationTargetException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.statePropertyName + "' cannot acquire from a record.", e.getTargetException());
        }
        if (state == 0) {
            return;
        }
        String path = null;
        try {
            path = (String)this.propertyAccess.get(blockade, this.pathPropertyName);
        }
        catch (ClassCastException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e);
        }
        catch (IllegalArgumentException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e);
        }
        catch (InvocationTargetException e) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' cannot acquire from a record.", e.getTargetException());
        }
        if (path == null) {
            throw new BlockadeProcessException("BlockadeCodeMaster value '" + this.pathPropertyName + "' is null from a record.");
        }
        boolean isMatch = false;
        if (reqPath.equals(path)) {
            isMatch = true;
        } else {
            Pattern pattern = (Pattern)this.pathPatternMap.get(path);
            if (pattern == null) {
                this.initPathPatternMap(this.pathPatternMap, path);
                pattern = (Pattern)this.pathPatternMap.get(path);
            }
            isMatch = pattern.matcher(reqPath).matches();
        }
        if (!isMatch) {
            return;
        }
        switch (state) {
            case 2: {
                if (isSpecialUser) {
                    return;
                }
                throw new BlockadeException("Blockade because of not special user. user=" + userKey);
            }
        }
        throw new BlockadeException("Blockade.");
    }
}

