/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.RequestProcessCheckInterceptorServiceMBean;
import jp.ossc.nimbus.service.log.Logger;

public class RequestProcessCheckInterceptorService
extends ServiceBase
implements Interceptor,
DaemonRunnable,
Serializable,
RequestProcessCheckInterceptorServiceMBean {
    private static final long serialVersionUID = -3680171846086643525L;
    protected ServiceName reportingLoggerServiceName;
    protected Logger reportingLogger;
    protected Map thresholdMap;
    protected Map thresholdLogMap;
    protected transient List requests;
    protected long checkInterval = 1000L;
    protected transient Daemon checker;

    public void setReportingLoggerServiceName(ServiceName name) {
        this.reportingLoggerServiceName = name;
    }

    public ServiceName getReportingLoggerServiceName() {
        return this.reportingLoggerServiceName;
    }

    public void setThreshold(Map threshold) {
        this.thresholdMap = threshold;
    }

    public Map getThreshold() {
        return this.thresholdMap;
    }

    public void setCheckInterval(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("CheckInterval must be larger than 0.");
        }
        this.checkInterval = interval;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public String displayCurrentReport() {
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        ArrayList requestList = new ArrayList(this.requests);
        long now = System.currentTimeMillis();
        int imax = requestList.size();
        for (int i = 0; i < imax; ++i) {
            Request request = (Request)requestList.get(i);
            if (request.isEnd) continue;
            pw.println('{');
            Object[] reports = this.createReport(request, now - request.time);
            pw.print("startTime=");
            pw.println(reports[0]);
            pw.print("processTime=");
            pw.println(reports[1]);
            pw.print("thread=");
            pw.println(reports[2]);
            pw.print("context=");
            pw.println(reports[3]);
            pw.print("stacktrace=");
            pw.println(reports[4]);
            pw.println('}');
        }
        pw.flush();
        return buf.toString();
    }

    public void suspendChecker() {
        if (this.checker != null) {
            this.checker.suspend();
        }
    }

    public void resumeChecker() {
        if (this.checker != null) {
            this.checker.resume();
        }
    }

    public boolean interruptRequest(String groupName, String threadName) {
        ArrayList requestList = new ArrayList(this.requests);
        boolean isInterrupt = false;
        int imax = requestList.size();
        for (int i = 0; i < imax; ++i) {
            Request request = (Request)requestList.get(i);
            if (request.isEnd || request.thread == null || !groupName.equals(request.thread.getThreadGroup().getName()) || !threadName.equals(request.thread.getName()) || request.isEnd) continue;
            request.thread.interrupt();
            isInterrupt = true;
        }
        return isInterrupt;
    }

    public boolean removeRequest(String groupName, String threadName) {
        ArrayList requestList = new ArrayList(this.requests);
        boolean isRemove = false;
        int imax = requestList.size();
        for (int i = 0; i < imax; ++i) {
            Request request = (Request)requestList.get(i);
            if (request.isEnd || request.thread == null || !groupName.equals(request.thread.getThreadGroup().getName()) || !threadName.equals(request.thread.getName())) continue;
            this.requests.remove(request);
            isRemove = true;
        }
        return isRemove;
    }

    public void clearRequest() {
        this.requests.clear();
    }

    public int getRequestCount() {
        return this.requests == null ? 0 : this.requests.size();
    }

    public void startService() throws Exception {
        this.requests = Collections.synchronizedList(new ArrayList());
        if (this.thresholdMap != null) {
            TreeMap<Long, String> map = new TreeMap<Long, String>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    long comp = (Long)o2 - (Long)o1;
                    if (comp == 0L) {
                        return 0;
                    }
                    return comp > 0L ? 1 : -1;
                }
            });
            Iterator entries = this.thresholdMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                long threshold = -1L;
                try {
                    threshold = Long.parseLong(entry.getKey().toString().trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (threshold < 0L) {
                    throw new IllegalArgumentException("Threshold must be 'threshold performance[ms]=MessageId' : " + entry.getKey());
                }
                map.put(new Long(threshold), entry.getValue().toString().trim());
            }
            this.thresholdLogMap = map;
            this.checker = new Daemon(this);
            this.checker.setName("Nimbus PerformanceCheckInterceptorDaemon " + this.getServiceNameObject());
            this.checker.setDaemon(true);
            this.checker.start();
        }
    }

    public void stopService() throws Exception {
        if (this.checker != null) {
            this.checker.stop();
            this.checker = null;
        }
    }

    public void setReportingLogger(Logger log) {
        this.reportingLogger = this.logger;
    }

    public Logger getReportingLogger() {
        if (this.reportingLogger != null) {
            return this.reportingLogger;
        }
        if (this.reportingLoggerServiceName != null) {
            try {
                return (Logger)ServiceManagerFactory.getServiceObject(this.reportingLoggerServiceName);
            }
            catch (ServiceNotFoundException e) {
                return super.getLogger();
            }
        }
        return super.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        Request request = new Request(context);
        try {
            this.requests.add(request);
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            request.isEnd = true;
            this.requests.remove(request);
        }
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Throwable {
        Thread.sleep(this.checkInterval);
        return this.requests.size() == 0 ? null : new ArrayList(this.requests);
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        List requestList = (List)paramObj;
        if (requestList == null || requestList.size() == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        Object[] thresholds = this.thresholdLogMap.keySet().toArray();
        for (int i = 0; i < thresholds.length; ++i) {
            long threshold = (Long)thresholds[i];
            Iterator itr = requestList.iterator();
            while (itr.hasNext()) {
                Request request = (Request)itr.next();
                if (request.isEnd) {
                    itr.remove();
                    continue;
                }
                if (now - request.time <= threshold) continue;
                itr.remove();
                if (request.isEnd) continue;
                this.getReportingLogger().write((String)this.thresholdLogMap.get(thresholds[i]), this.createReport(request, now - request.time));
            }
        }
    }

    protected Object[] createReport(Request request, long performance) {
        String stackTrace = null;
        if (request.thread != null) {
            try {
                StackTraceElement[] elements = (StackTraceElement[])Thread.class.getMethod("getStackTrace", null).invoke((Object)request.thread, (Object[])null);
                StringWriter buf = new StringWriter();
                PrintWriter pw = new PrintWriter(buf);
                for (int i = 0; i < elements.length; ++i) {
                    pw.println(elements[i]);
                }
                pw.flush();
                stackTrace = buf.toString();
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return new Object[]{new Date(request.time), new Long(performance), request.thread, request.context, stackTrace};
    }

    public void garbage() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.checker = new Daemon(this);
        this.checker.setName("Nimbus PerformanceCheckInterceptorDaemon " + this.getServiceNameObject());
        this.checker.setDaemon(true);
        this.checker.start();
    }

    protected static class Request {
        public final Thread thread;
        public final InvocationContext context;
        public final long time;
        public boolean isEnd = false;

        public Request(InvocationContext context) {
            this.context = context;
            this.thread = Thread.currentThread();
            this.time = System.currentTimeMillis();
        }
    }
}

