/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.interceptor.CheckPoint;
import jp.ossc.nimbus.service.aop.interceptor.CheckPointTracerServiceMBean;

public class CheckPointTracerService
extends ServiceBase
implements CheckPointTracerServiceMBean {
    private static final long serialVersionUID = -5613434425756392467L;
    private boolean isEnabled = true;
    private Map checkPointTraceMap;

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void createService() throws Exception {
        this.checkPointTraceMap = Collections.synchronizedMap(new HashMap());
    }

    public void stopService() throws Exception {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckPoint[] getCheckPointTrace(String threadName) {
        if (this.getState() != 3) {
            return new CheckPoint[0];
        }
        List checkPointTrace = (List)this.checkPointTraceMap.get(threadName);
        if (checkPointTrace == null) {
            return new CheckPoint[0];
        }
        List list = checkPointTrace;
        synchronized (list) {
            return checkPointTrace.toArray(new CheckPoint[checkPointTrace.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String threadName) {
        if (this.getState() != 3) {
            return;
        }
        List checkPointTrace = (List)this.checkPointTraceMap.get(threadName);
        if (checkPointTrace == null) {
            return;
        }
        List list = checkPointTrace;
        synchronized (list) {
            checkPointTrace.clear();
        }
    }

    public void clear() {
        if (this.getState() != 3) {
            return;
        }
        this.checkPointTraceMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passedCheckPoint(String threadName, CheckPoint point) {
        if (this.getState() != 3 || !this.isEnabled) {
            return;
        }
        ArrayList<CheckPoint> checkPointTrace = (ArrayList<CheckPoint>)this.checkPointTraceMap.get(threadName);
        if (checkPointTrace == null) {
            checkPointTrace = new ArrayList<CheckPoint>();
            this.checkPointTraceMap.put(threadName, checkPointTrace);
        }
        ArrayList<CheckPoint> arrayList = checkPointTrace;
        synchronized (arrayList) {
            checkPointTrace.add(point);
        }
    }
}

