/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.lang;

import java.io.PrintWriter;
import java.io.StringWriter;

public class BaseRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 8589752315764599712L;
    private String mErrorCode;
    private Throwable mCause = null;
    private boolean mIsRetry = false;
    private static final String C_NONE = "";
    private static final String C_CAUSE = "Caused by: ";

    public BaseRuntimeException() {
        this.mErrorCode = C_NONE;
    }

    public BaseRuntimeException(String errCode, String errMsg, Throwable cause) {
        super(errMsg);
        this.mErrorCode = errCode;
        this.mCause = cause;
    }

    public BaseRuntimeException(String errCode, String errMsg) {
        super(errMsg);
        this.mErrorCode = errCode;
    }

    public BaseRuntimeException(String errCode, String errMsg, Throwable cause, boolean isRetry) {
        super(errMsg);
        this.mErrorCode = errCode;
        this.mCause = cause;
        this.mIsRetry = isRetry;
    }

    public BaseRuntimeException(String errCode, String errMsg, boolean isRetry) {
        super(errMsg);
        this.mErrorCode = errCode;
        this.mIsRetry = isRetry;
    }

    public boolean IsRetry() {
        return this.mIsRetry;
    }

    public String getErrCode() {
        return this.mErrorCode;
    }

    public Throwable getCause() {
        return this.mCause == this ? null : this.mCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                s.println(C_CAUSE + ourCause);
                ourCause.printStackTrace(s);
            }
        }
    }

    public void printStackTrace() {
        PrintWriter pw = new PrintWriter(System.err, true);
        this.printStackTrace(pw);
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        pw.close();
        String tmp = sw.toString();
        return tmp;
    }
}

