/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.io.FLVReader;
import jp.ossc.nimbus.util.converter.PaddingStringConverter;

public class FLVRecordReader
extends FLVReader {
    private RecordSchema schema;
    private List workList;

    public FLVRecordReader() {
    }

    public FLVRecordReader(int[] fieldLen) {
        super(fieldLen);
    }

    public FLVRecordReader(int[] fieldLen, String encoding) {
        super(fieldLen, encoding);
    }

    public FLVRecordReader(int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        super(fieldLen, convs, encoding);
    }

    public FLVRecordReader(int[] fieldLen, String encoding, RecordSchema schema) {
        super(fieldLen, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(int[] fieldLen, PaddingStringConverter[] convs, String encoding, RecordSchema schema) {
        super(fieldLen, convs, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(Reader reader) {
        super(reader);
    }

    public FLVRecordReader(Reader reader, int[] fieldLen) {
        super(reader, fieldLen);
    }

    public FLVRecordReader(Reader reader, int[] fieldLen, String encoding) {
        super(reader, fieldLen, encoding);
    }

    public FLVRecordReader(Reader reader, int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        super(reader, fieldLen, convs, encoding);
    }

    public FLVRecordReader(Reader reader, int[] fieldLen, String encoding, RecordSchema schema) {
        super(reader, fieldLen, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(Reader reader, int[] fieldLen, PaddingStringConverter[] convs, String encoding, RecordSchema schema) {
        super(reader, fieldLen, convs, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(int size) {
        super(size);
    }

    public FLVRecordReader(int size, int[] fieldLen) {
        super(size, fieldLen);
    }

    public FLVRecordReader(int size, int[] fieldLen, String encoding) {
        super(size, fieldLen, encoding);
    }

    public FLVRecordReader(int size, int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        super(size, fieldLen, convs, encoding);
    }

    public FLVRecordReader(int size, int[] fieldLen, String encoding, RecordSchema schema) {
        super(size, fieldLen, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(int size, int[] fieldLen, PaddingStringConverter[] convs, String encoding, RecordSchema schema) {
        super(size, fieldLen, convs, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(Reader reader, int size) {
        super(reader, size);
    }

    public FLVRecordReader(Reader reader, int size, int[] fieldLen) {
        super(reader, size, fieldLen);
    }

    public FLVRecordReader(Reader reader, int size, int[] fieldLen, String encoding) {
        super(reader, size, fieldLen, encoding);
    }

    public FLVRecordReader(Reader reader, int size, int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        super(reader, size, fieldLen, convs, encoding);
    }

    public FLVRecordReader(Reader reader, int size, int[] fieldLen, String encoding, RecordSchema schema) {
        super(reader, size, fieldLen, encoding);
        this.setRecordSchema(schema);
    }

    public FLVRecordReader(Reader reader, int size, int[] fieldLen, PaddingStringConverter[] convs, String encoding, RecordSchema schema) {
        super(reader, size, fieldLen, convs, encoding);
        this.setRecordSchema(schema);
    }

    public void setRecordSchema(RecordSchema schema) {
        this.schema = schema;
        this.workList = new ArrayList(schema.getPropertySize());
    }

    public RecordSchema getRecordSchema() {
        return this.schema;
    }

    public Record readRecord() throws IOException, PropertySetException {
        return this.readRecord(null);
    }

    public Record readRecord(Record record) throws IOException, PropertySetException {
        List flv;
        if (this.workList == null) {
            this.workList = new ArrayList();
        }
        if ((flv = this.readFLVLineList(this.workList)) == null) {
            return null;
        }
        if (record == null) {
            record = new Record(this.getRecordSchema());
        } else {
            record.clear();
        }
        int imax = Math.min(flv.size(), record.size());
        for (int i = 0; i < imax; ++i) {
            String element = (String)flv.get(i);
            record.setParseProperty(i, (Object)element);
        }
        return record;
    }

    public FLVReader cloneReader() {
        return this.cloneReader(new FLVRecordReader());
    }

    protected FLVReader cloneReader(FLVReader clone) {
        clone = super.cloneReader(clone);
        ((FLVRecordReader)clone).schema = this.schema;
        return clone;
    }
}

