/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import jp.ossc.nimbus.core.GenericsServiceProxy;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceProxy;

public class ServiceProxyFactory {
    private static final long serialVersionUID = 4530900231794013688L;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$ServiceBase;

    private ServiceProxyFactory() {
    }

    public static ServiceBase createServiceBaseProxy(ServiceBaseSupport support) throws Exception {
        return new GenericsServiceProxy(support);
    }

    public static ServiceBase createServiceBaseProxy(Object obj) throws Exception {
        ServiceBaseSupport support = null;
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            support = new ServiceBaseSupportAdapter(obj);
        } else {
            Class[] newInterfaces = new Class[interfaces.length + 2];
            newInterfaces[0] = ServiceBaseSupport.class;
            newInterfaces[1] = ServiceProxy.class;
            System.arraycopy(interfaces, 0, newInterfaces, 2, interfaces.length);
            support = (ServiceBaseSupport)Proxy.newProxyInstance(NimbusClassLoader.getInstance(), newInterfaces, (InvocationHandler)new ServiceBaseSupportProxyHandler(obj));
        }
        return ServiceProxyFactory.createServiceBaseProxy(support);
    }

    private static class ServiceBaseSupportAdapter
    implements ServiceBaseSupport,
    ServiceProxy,
    Serializable {
        private static final long serialVersionUID = -6078404516516929266L;
        private static final String SET_SERVICEBASE = "setServiceBase";
        private static final String CREATE = "create";
        private static final String START = "start";
        private static final String STOP = "stop";
        private static final String DESTROY = "destroy";
        private final Method setServiceBase;
        private final Method create;
        private final Method start;
        private final Method stop;
        private final Method destroy;
        private final Object obj;

        public ServiceBaseSupportAdapter(Object obj) {
            this.obj = obj;
            Class<?> clazz = obj.getClass();
            this.setServiceBase = this.findMethod(clazz, SET_SERVICEBASE, new Class[]{class$jp$ossc$nimbus$core$ServiceBase == null ? (class$jp$ossc$nimbus$core$ServiceBase = ServiceProxyFactory.class$("jp.ossc.nimbus.core.ServiceBase")) : class$jp$ossc$nimbus$core$ServiceBase});
            this.create = this.findMethod(clazz, CREATE, null);
            this.start = this.findMethod(clazz, START, null);
            this.stop = this.findMethod(clazz, STOP, null);
            this.destroy = this.findMethod(clazz, DESTROY, null);
        }

        private Method findMethod(Class clazz, String name, Class[] params) {
            try {
                return clazz.getMethod(name, params);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setServiceBase(ServiceBase service) {
            if (this.setServiceBase == null) {
                return;
            }
            try {
                this.setServiceBase.invoke(this.obj, service);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw (Error)th;
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void createService() throws Exception {
            if (this.create == null) {
                return;
            }
            try {
                this.create.invoke(this.obj, (Object[])null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw (Error)th;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void startService() throws Exception {
            if (this.start == null) {
                return;
            }
            try {
                this.start.invoke(this.obj, (Object[])null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw (Error)th;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void stopService() throws Exception {
            if (this.stop == null) {
                return;
            }
            try {
                this.stop.invoke(this.obj, (Object[])null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw (Error)th;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void destroyService() throws Exception {
            if (this.destroy == null) {
                return;
            }
            try {
                this.destroy.invoke(this.obj, (Object[])null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw (Error)th;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public Object getTarget() {
            return this.obj;
        }
    }

    private static class ServiceBaseSupportProxyHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 4726647102748613673L;
        private static final String GET_TARGET = "getTarget";
        private final Object targetObj;

        public ServiceBaseSupportProxyHandler(Object target) {
            this.targetObj = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (GET_TARGET.equals(method.getName()) && method.getParameterTypes().length == 0) {
                return this.targetObj;
            }
            try {
                Method targetMethod = this.findTargetMethod(this.targetObj.getClass(), method);
                if (targetMethod == null) {
                    return null;
                }
                return targetMethod.invoke(this.targetObj, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Method findTargetMethod(Class targetClass, Method method) {
            Method targetMethod = null;
            if (this.isAccessableClass(targetClass)) {
                try {
                    targetMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
                    if (Modifier.isNative(targetMethod.getModifiers())) {
                        targetMethod = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
            if (targetMethod == null) {
                Class<?>[] interfaces = targetClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!this.isAccessableClass(interfaces[i]) || (targetMethod = this.findTargetMethod(interfaces[i], method)) == null) continue;
                    return targetMethod;
                }
                Class superClass = targetClass.getSuperclass();
                if (superClass == null) {
                    return null;
                }
                return this.findTargetMethod(superClass, method);
            }
            return targetMethod;
        }

        private boolean isAccessableClass(Class clazz) {
            int modifier = clazz.getModifiers();
            return Modifier.isPublic(modifier);
        }

        public Object getTarget() {
            return this.targetObj;
        }
    }
}

