/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import org.w3c.dom.Element;

public class ServiceNameMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 3198561088823261679L;
    protected static final String MANAGER_NAME_ATTRIBUTE_NAME = "manager-name";
    protected String tagName;
    protected String managerName;
    protected String serviceName;

    public ServiceNameMetaData(MetaData parent) {
        super(parent);
    }

    public ServiceNameMetaData(MetaData parent, String manager) {
        super(parent);
        this.managerName = manager;
    }

    public ServiceNameMetaData(MetaData parent, String manager, String service) {
        super(parent);
        this.managerName = manager;
        this.serviceName = service;
    }

    public ServiceNameMetaData(MetaData parent, String name, String manager, String service) {
        super(parent);
        this.tagName = name;
        this.managerName = manager;
        this.serviceName = service;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String name) {
        this.managerName = name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        this.tagName = element.getTagName();
        this.managerName = ServiceNameMetaData.getOptionalAttribute(element, MANAGER_NAME_ATTRIBUTE_NAME, this.managerName == null ? "Nimbus" : this.managerName);
        String content = ServiceNameMetaData.getElementContent(element);
        if (content != null && content.length() != 0) {
            if (content != null) {
                ServiceMetaData serviceData;
                ObjectMetaData objData;
                content = Utility.replaceSystemProperty(content);
                MetaData parent = this.getParent();
                if (parent != null && parent instanceof ObjectMetaData && (objData = (ObjectMetaData)parent).getServiceLoader() != null) {
                    content = Utility.replaceServiceLoderConfig(content, objData.getServiceLoader().getConfig());
                }
                if (parent != null && parent instanceof ServiceMetaData && (serviceData = (ServiceMetaData)parent).getManager() != null) {
                    content = Utility.replaceManagerProperty(serviceData.getManager(), content);
                }
                content = Utility.replaceServerProperty(content);
            }
            if (content.indexOf(35) != -1) {
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setServiceManagerName(this.managerName);
                editor.setAsText(content);
                ServiceName editName = (ServiceName)editor.getValue();
                if (!editName.getServiceManagerName().equals(this.managerName)) {
                    this.managerName = editName.getServiceManagerName();
                }
                this.serviceName = editName.getServiceName();
            } else {
                this.serviceName = content;
            }
        } else {
            throw new DeploymentException("Content of '" + this.tagName + "' element must not be null.");
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(this.tagName).append('>');
        if (this.managerName != null) {
            buf.append(this.managerName);
        }
        if (this.serviceName != null) {
            buf.append('#').append(this.serviceName);
        }
        buf.append("</").append(this.tagName).append('>');
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceNameMetaData) {
            ServiceNameMetaData name = (ServiceNameMetaData)obj;
            if (this.managerName == null && name.managerName != null || this.managerName != null && name.managerName == null) {
                return false;
            }
            if (this.managerName != null && name.managerName != null && !this.managerName.equals(name.managerName)) {
                return false;
            }
            if (this.serviceName == null && name.serviceName != null || this.serviceName != null && name.serviceName == null) {
                return false;
            }
            return this.serviceName == null || name.serviceName == null || this.serviceName.equals(name.serviceName);
        }
        return false;
    }

    public int hashCode() {
        return (this.managerName != null ? this.managerName.hashCode() : 0) + (this.serviceName != null ? this.serviceName.hashCode() : 0);
    }
}

