/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceControlServiceMBean;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;

public class ServiceControlService
extends ServiceBase
implements ServiceControlServiceMBean {
    private static final long serialVersionUID = -6687538751630369946L;
    private ServiceName[] serviceNames;
    private Set services;
    private boolean isUseServiceManager;

    public void setUseServiceManager(boolean isUse) {
        this.isUseServiceManager = isUse;
    }

    public boolean isUseServiceManager() {
        return this.isUseServiceManager;
    }

    public void setServiceNames(ServiceName[] names) {
        this.serviceNames = names;
    }

    public ServiceName[] getServiceNames() {
        return this.serviceNames;
    }

    public void addService(Service service) {
        this.services.add(service);
    }

    public void removeService(Service service) {
        this.services.remove(service);
    }

    public void clearServices() {
        this.services.clear();
    }

    public Set getServiceSet() {
        return this.services;
    }

    public void createService() throws Exception {
        this.services = new LinkedHashSet();
    }

    public void destroyService() throws Exception {
        this.services = null;
    }

    public void createServices() throws Exception {
        this.controlServices(0);
    }

    public void startServices() throws Exception {
        this.controlServices(2);
    }

    public void stopServices() throws Exception {
        this.controlServices(4);
    }

    public void destroyServices() throws Exception {
        this.controlServices(6);
    }

    public void restartServices() throws Exception {
        this.controlServices(4);
        this.controlServices(2);
    }

    private void controlServices(int state) throws Exception {
        if (this.serviceNames != null) {
            block24: for (int i = 0; i < this.serviceNames.length; ++i) {
                if (this.isUseServiceManager) {
                    ServiceManager manager = ServiceManagerFactory.findManager(this.serviceNames[i].getServiceManagerName());
                    if (manager == null) continue;
                    switch (state) {
                        case 0: {
                            manager.createService(this.serviceNames[i].getServiceName());
                            break;
                        }
                        case 2: {
                            manager.startService(this.serviceNames[i].getServiceName());
                            break;
                        }
                        case 4: {
                            manager.stopService(this.serviceNames[i].getServiceName());
                            break;
                        }
                        case 6: {
                            manager.destroyService(this.serviceNames[i].getServiceName());
                        }
                    }
                    continue;
                }
                switch (state) {
                    case 0: {
                        ServiceManagerFactory.getService(this.serviceNames[i]).create();
                        continue block24;
                    }
                    case 2: {
                        ServiceManagerFactory.getService(this.serviceNames[i]).start();
                        continue block24;
                    }
                    case 4: {
                        ServiceManagerFactory.getService(this.serviceNames[i]).stop();
                        continue block24;
                    }
                    case 6: {
                        ServiceManagerFactory.getService(this.serviceNames[i]).destroy();
                    }
                }
            }
        }
        if (this.services != null) {
            Iterator itr = this.services.iterator();
            while (itr.hasNext()) {
                Service service = (Service)itr.next();
                if (this.isUseServiceManager) {
                    ServiceManager manager = ServiceManagerFactory.findManager(service.getServiceManagerName());
                    if (manager == null) continue;
                    switch (state) {
                        case 0: {
                            manager.createService(service.getServiceName());
                            break;
                        }
                        case 2: {
                            manager.startService(service.getServiceName());
                            break;
                        }
                        case 4: {
                            manager.stopService(service.getServiceName());
                            break;
                        }
                        case 6: {
                            manager.destroyService(service.getServiceName());
                        }
                    }
                    continue;
                }
                switch (state) {
                    case 0: {
                        service.create();
                        break;
                    }
                    case 2: {
                        service.start();
                        break;
                    }
                    case 4: {
                        service.stop();
                        break;
                    }
                    case 6: {
                        service.destroy();
                    }
                }
            }
        }
    }
}

