/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.core.DefaultLogMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.IfDefMetaData;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.PropertyEditorsMetaData;
import jp.ossc.nimbus.core.RefURLMetaData;
import jp.ossc.nimbus.core.ServerPropertyMetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import jp.ossc.nimbus.core.Utility;
import org.w3c.dom.Element;

public class ServerMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = -5309966428718081110L;
    public static final String SERVER_TAG_NAME = "server";
    private static final String REPOSITORY_TAG_NAME = "manager-repository";
    private static final String LOG_TAG_NAME = "log";
    private static final String MESSAGE_TAG_NAME = "message";
    private final Map managers = new LinkedHashMap();
    private final Set referenceURL = new LinkedHashSet();
    private PropertyEditorsMetaData propertyEditors;
    private final URL myUrl;
    private ServiceNameMetaData repository;
    private ServiceNameMetaData log;
    private ServiceNameMetaData message;
    private DefaultLogMetaData defaultLog;
    private ServiceLoader myLoader;
    private Map properties = new LinkedHashMap();
    private String encoding;
    private String docType;
    private List ifDefMetaDataList;

    public ServerMetaData(ServiceLoader loader, URL url) {
        this.myUrl = url;
        this.myLoader = loader;
    }

    public URL getURL() {
        return this.myUrl;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public void setServiceLoader(ServiceLoader loader) {
        this.myLoader = loader;
    }

    public ManagerMetaData getManager(String name) {
        return (ManagerMetaData)this.managers.get(name);
    }

    public Collection getManagers() {
        return this.managers.values();
    }

    public void addManager(ManagerMetaData manager) {
        manager.setParent(this);
        manager.setServiceLoader(this.getServiceLoader());
        this.managers.put(manager.getName(), manager);
    }

    public void removeManager(String name) {
        this.managers.remove(name);
    }

    public void clearManagers() {
        this.managers.clear();
    }

    public Set getReferenceURL() {
        HashSet<String> urls = new HashSet<String>();
        Iterator itr = this.referenceURL.iterator();
        while (itr.hasNext()) {
            urls.add(((RefURLMetaData)itr.next()).getURL());
        }
        return urls;
    }

    public void addReferenceURL(String urlStr) {
        RefURLMetaData data = new RefURLMetaData(this);
        data.setURL(urlStr);
        this.referenceURL.add(data);
    }

    public Map getPropertyEditors() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.propertyEditors == null) {
            return result;
        }
        Iterator types = this.propertyEditors.getPropertyEditorTypes().iterator();
        while (types.hasNext()) {
            String type = (String)types.next();
            result.put(type, this.propertyEditors.getPropertyEditor(type));
        }
        return result;
    }

    public void addPropertyEditor(String type, String editor) {
        if (this.propertyEditors == null) {
            this.propertyEditors = new PropertyEditorsMetaData(this);
        }
        this.propertyEditors.setPropertyEditor(type, editor);
    }

    public void removePropertyEditor(String type) {
        if (this.propertyEditors == null) {
            return;
        }
        this.propertyEditors.removePropertyEditor(type);
    }

    public void clearPropertyEditors() {
        this.propertyEditors.clearPropertyEditors();
    }

    public ServiceNameMetaData getRepository() {
        return this.repository;
    }

    public void setRepository(ServiceNameMetaData data) {
        this.repository = data;
    }

    public ServiceNameMetaData getLog() {
        return this.log;
    }

    public void setLog(ServiceNameMetaData data) {
        this.log = data;
    }

    public ServiceNameMetaData getMessage() {
        return this.message;
    }

    public void setMessage(ServiceNameMetaData data) {
        this.message = data;
    }

    public DefaultLogMetaData getDefaultLog() {
        return this.defaultLog;
    }

    public void setDefaultLog(DefaultLogMetaData data) {
        this.defaultLog = data;
    }

    public Set getPropertyNameSet() {
        return this.properties.keySet();
    }

    public String getProperty(String property) {
        ServerPropertyMetaData propData = (ServerPropertyMetaData)this.properties.get(property);
        return propData == null ? null : propData.getValue();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        Iterator propDatas = this.properties.values().iterator();
        while (propDatas.hasNext()) {
            ServerPropertyMetaData propData = (ServerPropertyMetaData)propDatas.next();
            props.setProperty(propData.getName(), propData.getValue() == null ? "" : propData.getValue());
        }
        return props;
    }

    public void setProperty(String property, String value) {
        ServerPropertyMetaData propData = (ServerPropertyMetaData)this.properties.get(property);
        if (propData == null) {
            propData = new ServerPropertyMetaData(this);
        }
        propData.setName(property);
        propData.setValue(value);
        this.properties.put(property, propData);
    }

    public void removeProperty(String property) {
        this.properties.remove(property);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public ServiceNameMetaData createRepositoryMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, REPOSITORY_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createLogMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, LOG_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createMessageMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, MESSAGE_TAG_NAME, managerName, serviceName);
    }

    public void setDocType(String str) {
        this.docType = str;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(SERVER_TAG_NAME)) {
            throw new DeploymentException("Root tag must be server : " + element.getTagName());
        }
        this.importXMLInner(element, null);
        Iterator ifDefElements = ServerMetaData.getChildrenByTagName(element, "ifdef");
        while (ifDefElements.hasNext()) {
            if (this.ifDefMetaDataList == null) {
                this.ifDefMetaDataList = new ArrayList();
            }
            IfDefMetaData ifdefData = new IfDefMetaData(this);
            ifdefData.importXML((Element)ifDefElements.next());
            this.ifDefMetaDataList.add(ifdefData);
        }
        if (this.ifDefMetaDataList == null || this.ifDefMetaDataList.size() == 0) {
            return;
        }
        int imax = this.ifDefMetaDataList.size();
        for (int i = 0; i < imax; ++i) {
            IfDefMetaData ifdefData = (IfDefMetaData)this.ifDefMetaDataList.get(i);
            Element ifDefElement = ifdefData.getElement();
            if (ifDefElement == null) continue;
            this.importXMLInner(ifDefElement, ifdefData);
            ifdefData.setElement(null);
        }
    }

    protected void importXMLInner(Element element, IfDefMetaData ifdefData) throws DeploymentException {
        Element editorsElement;
        Element defaultLogElement;
        Element messageElement;
        Element logElement;
        boolean ifdefMatch = ifdefData == null ? true : ifdefData.isMatch();
        Iterator propElements = ServerMetaData.getChildrenByTagName(element, "server-property");
        while (propElements.hasNext()) {
            ServerPropertyMetaData propData = new ServerPropertyMetaData(this);
            if (ifdefData != null) {
                propData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(propData);
            }
            propData.importXML((Element)propElements.next());
            if (!ifdefMatch) continue;
            this.properties.put(propData.getName(), propData);
            String prop = propData.getValue();
            prop = Utility.replaceSystemProperty(prop);
            prop = Utility.replaceServiceLoderConfig(prop, this.myLoader == null ? null : this.myLoader.getConfig());
            prop = Utility.replaceServerProperty(prop);
            propData.setValue(prop);
        }
        Iterator refURLElements = ServerMetaData.getChildrenByTagName(element, "ref-url");
        while (refURLElements.hasNext()) {
            RefURLMetaData refURLData = new RefURLMetaData(this);
            if (ifdefData != null) {
                refURLData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(refURLData);
            }
            refURLData.importXML((Element)refURLElements.next());
            if (!ifdefMatch || refURLData.getURL() == null || refURLData.getURL().length() == 0) continue;
            this.referenceURL.add(refURLData);
        }
        Element repositoryElement = ServerMetaData.getOptionalChild(element, REPOSITORY_TAG_NAME);
        if (repositoryElement != null) {
            if (ifdefMatch && this.repository != null) {
                throw new DeploymentException("Element of manager-repository is duplicated.");
            }
            ServiceNameMetaData tmp = new ServiceNameMetaData(this);
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(repositoryElement);
            if (ifdefMatch) {
                this.repository = tmp;
            }
        }
        if ((logElement = ServerMetaData.getOptionalChild(element, LOG_TAG_NAME)) != null) {
            if (ifdefMatch && this.log != null) {
                throw new DeploymentException("Element of log is duplicated.");
            }
            ServiceNameMetaData tmp = new ServiceNameMetaData(this);
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(logElement);
            if (ifdefMatch) {
                this.log = tmp;
            }
        }
        if ((messageElement = ServerMetaData.getOptionalChild(element, MESSAGE_TAG_NAME)) != null) {
            if (ifdefMatch && this.message != null) {
                throw new DeploymentException("Element of message is duplicated.");
            }
            ServiceNameMetaData tmp = new ServiceNameMetaData(this);
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(messageElement);
            if (ifdefMatch) {
                this.message = tmp;
            }
        }
        if ((defaultLogElement = ServerMetaData.getOptionalChild(element, "default-log")) != null) {
            if (ifdefMatch && this.defaultLog != null) {
                throw new DeploymentException("Element of default-log is duplicated.");
            }
            DefaultLogMetaData tmp = new DefaultLogMetaData(this);
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(defaultLogElement);
            if (ifdefMatch) {
                this.defaultLog = tmp;
            }
        }
        if ((editorsElement = ServerMetaData.getOptionalChild(element, "property-editors")) != null) {
            PropertyEditorsMetaData tmp = null;
            tmp = ifdefMatch ? (this.propertyEditors == null ? new PropertyEditorsMetaData(this) : this.propertyEditors) : new PropertyEditorsMetaData(this);
            if (ifdefData != null) {
                tmp.setIfDefMetaData(ifdefData);
                ifdefData.addChild(tmp);
            }
            tmp.importXML(editorsElement);
            if (ifdefMatch) {
                this.propertyEditors = tmp;
            }
        }
        Iterator managerElements = ServerMetaData.getChildrenByTagName(element, "manager");
        while (managerElements.hasNext()) {
            ManagerMetaData managerData = new ManagerMetaData(this.myLoader, this);
            if (ifdefData != null) {
                managerData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(managerData);
            }
            managerData.importXML((Element)managerElements.next());
            if (ifdefMatch && this.getManager(managerData.getName()) != null) {
                throw new DeploymentException("Name of manager is duplicated. name=" + managerData.getName());
            }
            if (!ifdefMatch) continue;
            this.addManager(managerData);
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        buf.append("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            buf.append(" encoding=\"");
            buf.append(this.encoding);
            buf.append("\"");
        }
        buf.append("?>");
        buf.append(LINE_SEPARATOR);
        if (this.docType != null) {
            buf.append(this.docType);
            buf.append(LINE_SEPARATOR);
            buf.append(LINE_SEPARATOR);
        }
        this.appendComment(buf);
        buf.append('<').append(SERVER_TAG_NAME).append('>');
        if (this.properties.size() != 0) {
            buf.append(LINE_SEPARATOR);
            StringBuffer subBuf = new StringBuffer();
            Iterator props = this.properties.values().iterator();
            while (props.hasNext()) {
                ServerPropertyMetaData propData = (ServerPropertyMetaData)props.next();
                if (propData.getIfDefMetaData() != null) continue;
                propData.toXML(subBuf);
                if (!props.hasNext()) continue;
                subBuf.append(LINE_SEPARATOR);
            }
            buf.append(this.addIndent(subBuf));
        }
        if (this.referenceURL.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator urls = this.referenceURL.iterator();
            while (urls.hasNext()) {
                RefURLMetaData refURLData = (RefURLMetaData)urls.next();
                if (refURLData.getIfDefMetaData() != null) continue;
                refURLData.toXML(buf);
                if (!urls.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        if (this.propertyEditors != null && this.propertyEditors.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            this.propertyEditors.toXML(buf);
        }
        if (this.defaultLog != null && this.defaultLog.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.defaultLog.toXML(new StringBuffer())));
        }
        if (this.repository != null && this.repository.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.repository.toXML(new StringBuffer())));
        }
        if (this.log != null && this.log.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.log.toXML(new StringBuffer())));
        }
        if (this.message != null && this.message.getIfDefMetaData() == null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.message.toXML(new StringBuffer())));
        }
        if (this.managers.size() != 0) {
            Iterator datas = this.managers.values().iterator();
            buf.append(LINE_SEPARATOR);
            while (datas.hasNext()) {
                MetaData managerData = (MetaData)datas.next();
                if (managerData.getIfDefMetaData() != null) continue;
                buf.append(this.addIndent(managerData.toXML(new StringBuffer())));
                if (!datas.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append(LINE_SEPARATOR);
        if (this.ifDefMetaDataList != null && this.ifDefMetaDataList.size() != 0) {
            int imax = this.ifDefMetaDataList.size();
            for (int i = 0; i < imax; ++i) {
                IfDefMetaData ifdefData = (IfDefMetaData)this.ifDefMetaDataList.get(i);
                buf.append(this.addIndent(ifdefData.toXML(new StringBuffer())));
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append("</").append(SERVER_TAG_NAME).append('>');
        return buf;
    }
}

