/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class RefURLMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = -3285049825685418823L;
    public static final String REF_URL_TAG_NAME = "ref-url";
    protected String url;

    public RefURLMetaData(MetaData parent) {
        super(parent);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(REF_URL_TAG_NAME)) {
            throw new DeploymentException("Tag must be ref-url : " + element.getTagName());
        }
        this.url = RefURLMetaData.getElementContent(element);
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(REF_URL_TAG_NAME).append(">");
        if (this.url != null) {
            buf.append(this.url);
        }
        buf.append("</").append(REF_URL_TAG_NAME).append('>');
        return buf;
    }
}

