/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Serializable;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaCheckException;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.Utility;

public class RecordListPropertySchema
implements PropertySchema,
Serializable {
    private static final long serialVersionUID = -4263284765094524721L;
    protected String schema;
    protected String name;
    protected Class type = RecordList.class;
    protected String recordListName;

    public RecordListPropertySchema() {
    }

    public RecordListPropertySchema(String schema) throws PropertySchemaDefineException {
        this.setSchema(schema);
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        List schemata = DefaultPropertySchema.parseCSV(schema);
        if (schemata.size() < 2) {
            throw new PropertySchemaDefineException("Name and Schema must be specified.");
        }
        this.schema = schema;
        this.name = (String)schemata.get(0);
        this.recordListName = (String)schemata.get(1);
        if (schemata.size() > 2) {
            this.parseType(schema, (String)schemata.get(2));
        }
    }

    protected void parseType(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            try {
                this.type = Utility.convertStringToClass(val, false);
            }
            catch (ClassNotFoundException e) {
                throw new PropertySchemaDefineException(schema, "The type is illegal.", e);
            }
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isPrimaryKey() {
        return false;
    }

    public Object set(Object val) throws PropertySetException {
        if (val == null) {
            return null;
        }
        if (!(val instanceof RecordList)) {
            throw new PropertySchemaCheckException((PropertySchema)this, "The type is unmatch. type=" + val.getClass().getName());
        }
        RecordList list = (RecordList)val;
        if (!this.recordListName.equals(list.getName())) {
            throw new PropertySchemaCheckException((PropertySchema)this, "Name of RecordList is unmatch. name=" + list.getName());
        }
        return val;
    }

    public Object get(Object val) throws PropertyGetException {
        return val;
    }

    public Object format(Object val) throws PropertyGetException {
        return val;
    }

    public Object parse(Object val) throws PropertySetException {
        return val;
    }

    public boolean validate(Object val) throws PropertyValidateException {
        if (val != null && val instanceof RecordList) {
            return ((RecordList)val).validate();
        }
        return true;
    }

    public String getRecordListName() {
        return this.recordListName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(",recordListName=").append(this.recordListName);
        buf.append(",type=").append(this.type);
        buf.append('}');
        return buf.toString();
    }
}

