/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;
import jp.ossc.nimbus.core.ServiceName;

public class ServiceNameEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -4707170513324274901L;
    private String managerName;

    public void setServiceManagerName(String name) {
        this.managerName = name;
    }

    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmpText = Utility.replaceSystemProperty(text);
        int index = tmpText.indexOf(35);
        ServiceName serviceName = null;
        if (index == -1) {
            serviceName = new ServiceName(tmpText);
        } else if (index == 0 && tmpText.length() > 1) {
            if (this.managerName == null) {
                throw new IllegalArgumentException("ServiceManagerName is null.");
            }
            serviceName = new ServiceName(this.managerName, tmpText.substring(1));
        } else if (tmpText.length() > index + 1) {
            serviceName = new ServiceName(tmpText.substring(0, index), tmpText.substring(index + 1));
        } else {
            throw new IllegalArgumentException(tmpText);
        }
        this.setValue(serviceName);
    }

    public String getAsText() {
        ServiceName name = (ServiceName)this.getValue();
        if (name == null) {
            return null;
        }
        return name.toString();
    }
}

