/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.SimpleProperty;

public class ConcatenatedProperty
implements Property,
Serializable {
    private static final long serialVersionUID = -7626632324425762277L;
    private static final String MSG_00001 = "Illegal ConcatenatedProperty : ";
    private static final String MSG_00002 = "Arguments is null.";
    protected Property thisProperty;
    protected Property concatProperty;
    protected boolean isIgnoreNullProperty;

    public ConcatenatedProperty() {
    }

    public ConcatenatedProperty(Property prop, Property concatProp) throws IllegalArgumentException {
        if (prop == null || concatProp == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.thisProperty = prop;
        this.concatProperty = concatProp;
    }

    public void setThisProperty(Property prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.thisProperty = prop;
    }

    public Property getFirstThisProperty() {
        return this.getFirstThisProperty(this.thisProperty);
    }

    private Property getFirstThisProperty(Property prop) {
        if (prop instanceof ConcatenatedProperty) {
            return this.getFirstThisProperty(((ConcatenatedProperty)prop).getThisProperty());
        }
        return prop;
    }

    public Property getThisProperty() {
        return this.thisProperty;
    }

    public void setConcatenatedProperty(Property concatProp) throws IllegalArgumentException {
        if (concatProp == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.concatProperty = concatProp;
    }

    public Property getConcatenatedProperty() {
        return this.concatProperty;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int index = prop.indexOf(43);
        if (index == -1 || index == 0 || index == prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.thisProperty = PropertyFactory.createProperty(prop.substring(0, index).trim());
        this.concatProperty = PropertyFactory.createProperty(prop.substring(index + 1).trim());
    }

    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        return String.class;
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return String.class;
    }

    public boolean isReadable(Class clazz) {
        String propName;
        if (this.thisProperty instanceof SimpleProperty ? ((propName = this.thisProperty.getPropertyName()).length() <= 1 || propName.charAt(0) != '\"' && propName.charAt(0) != '\'') && !this.thisProperty.isReadable(clazz) : !this.thisProperty.isReadable(clazz)) {
            return false;
        }
        return !(this.concatProperty instanceof SimpleProperty ? ((propName = this.concatProperty.getPropertyName()).length() <= 1 || propName.charAt(0) != '\"' && propName.charAt(0) != '\'') && !this.concatProperty.isReadable(clazz) : !this.concatProperty.isReadable(clazz));
    }

    public boolean isReadable(Object obj) {
        String propName;
        if (this.thisProperty instanceof SimpleProperty ? ((propName = this.thisProperty.getPropertyName()).length() <= 1 || propName.charAt(0) != '\"' && propName.charAt(0) != '\'') && !this.thisProperty.isReadable(obj) : !this.thisProperty.isReadable(obj)) {
            return false;
        }
        return !(this.concatProperty instanceof SimpleProperty ? ((propName = this.concatProperty.getPropertyName()).length() <= 1 || propName.charAt(0) != '\"' && propName.charAt(0) != '\'') && !this.concatProperty.isReadable(obj) : !this.concatProperty.isReadable(obj));
    }

    public boolean isWritable(Object obj, Class clazz) {
        return false;
    }

    public boolean isWritable(Class targetClass, Class clazz) {
        return false;
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        String propName;
        String propName2;
        StringBuffer buf = new StringBuffer();
        Object thisObj = null;
        thisObj = this.thisProperty instanceof SimpleProperty ? ((propName2 = this.thisProperty.getPropertyName()).length() > 1 && (propName2.charAt(0) == '\"' || propName2.charAt(0) == '\'') ? propName2.substring(1, propName2.length() - 1) : this.thisProperty.getProperty(obj)) : this.thisProperty.getProperty(obj);
        if (thisObj != null) {
            buf.append(thisObj);
        }
        Object concatObj = null;
        concatObj = this.concatProperty instanceof SimpleProperty ? ((propName = this.concatProperty.getPropertyName()).length() > 1 && (propName.charAt(0) == '\"' || propName.charAt(0) == '\'') ? propName.substring(1, propName.length() - 1) : this.concatProperty.getProperty(obj)) : this.concatProperty.getProperty(obj);
        if (concatObj != null) {
            buf.append(concatObj);
        }
        return thisObj == null && concatObj == null && this.isIgnoreNullProperty ? null : buf.toString();
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public String getPropertyName() {
        return this.thisProperty.getPropertyName() + '+' + this.concatProperty.getPropertyName();
    }

    public void setIgnoreNullProperty(boolean isIgnore) {
        this.isIgnoreNullProperty = isIgnore;
        if (this.thisProperty != null) {
            this.thisProperty.setIgnoreNullProperty(this.isIgnoreNullProperty);
        }
        if (this.concatProperty != null) {
            this.concatProperty.setIgnoreNullProperty(this.isIgnoreNullProperty);
        }
    }

    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    public String toString() {
        return "ConcatenatedProperty{" + this.thisProperty.toString() + '+' + this.concatProperty.toString() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConcatenatedProperty)) {
            return false;
        }
        ConcatenatedProperty comp = (ConcatenatedProperty)obj;
        if (this.thisProperty == null && comp.thisProperty != null || this.thisProperty != null && comp.thisProperty == null) {
            return false;
        }
        if (this.thisProperty != null && comp.thisProperty != null && !this.thisProperty.equals(comp.thisProperty)) {
            return false;
        }
        if (this.concatProperty == null && comp.concatProperty == null) {
            return true;
        }
        if (this.concatProperty == null) {
            return false;
        }
        return this.concatProperty.equals(comp.concatProperty);
    }

    public int hashCode() {
        return (this.thisProperty == null ? 0 : this.thisProperty.hashCode()) + (this.concatProperty == null ? 0 : this.concatProperty.hashCode()) + 3;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof ConcatenatedProperty)) {
            return 1;
        }
        ConcatenatedProperty comp = (ConcatenatedProperty)obj;
        if (this.thisProperty == null && comp.thisProperty != null) {
            return -1;
        }
        if (this.thisProperty != null && comp.thisProperty == null) {
            return 1;
        }
        if (this.thisProperty != null && comp.thisProperty != null) {
            if (this.thisProperty instanceof Comparable) {
                int val = ((Comparable)((Object)this.thisProperty)).compareTo(comp.thisProperty);
                if (val != 0) {
                    return val;
                }
            } else {
                return -1;
            }
        }
        if (this.concatProperty == null && comp.concatProperty == null) {
            return 0;
        }
        if (this.concatProperty == null) {
            return -1;
        }
        if (this.concatProperty instanceof Comparable) {
            return ((Comparable)((Object)this.concatProperty)).compareTo(comp.concatProperty);
        }
        return -1;
    }
}

