/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class BooleanEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 1833962710671752692L;
    public static final int AS_TEXT_TYPE_BOOLEAN = 1;
    public static final int AS_TEXT_TYPE_NUMBER = 2;
    public static final int AS_TEXT_TYPE_ON_OFF = 3;
    public static final int AS_TEXT_TYPE_YES_NO = 4;
    private int asTextType = 1;

    public void setAsTextType(int type) {
        this.asTextType = type;
    }

    public int getAsTextType() {
        return this.asTextType;
    }

    public void setAsText(String text) {
        if (text == null) {
            this.setValue(Boolean.FALSE);
            return;
        }
        this.setValue(BooleanEditor.toBoolean(Utility.replaceSystemProperty(text)) ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getAsText() {
        Boolean bool = (Boolean)this.getValue();
        return BooleanEditor.toText(this.asTextType, bool == null ? false : bool);
    }

    public static boolean toBoolean(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes"));
    }

    public static String toText(int asTextType, boolean value) {
        switch (asTextType) {
            case 2: {
                return value ? "1" : "0";
            }
            case 3: {
                return value ? "on" : "off";
            }
            case 4: {
                return value ? "yes" : "no";
            }
        }
        return value ? "true" : "false";
    }
}

