/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.io.CSVWriter;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class RecordListCSVConverter
implements BindingStreamConverter,
StreamStringConverter {
    public static final int RECORDLIST_FROM_CSV = 1;
    public static final int CSV_FROM_RECORDLIST = 2;
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected boolean isExistsSchema;
    protected boolean isExistsHeader;
    protected boolean isIgnoreUnknownProperty;
    protected char separator = (char)44;
    protected char separatorEscape = (char)92;
    protected char enclosure = (char)34;
    protected boolean isEnclose;
    protected String lineSeparator = CSVWriter.DEFAULT_LINE_SEPARATOR;
    protected String nullValue;
    protected boolean isIgnoreEmptyLine;
    protected boolean isIgnoreLineEndSeparator;

    public RecordListCSVConverter() {
        this(1);
    }

    public RecordListCSVConverter(int type) {
        this.convertType = type;
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    @Override
    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public void setExistsSchema(boolean isExists) {
        this.isExistsSchema = isExists;
    }

    public boolean isExistsSchema() {
        return this.isExistsSchema;
    }

    public void setExistsHeader(boolean isExists) {
        this.isExistsHeader = isExists;
    }

    public boolean isExistsHeader() {
        return this.isExistsHeader;
    }

    public void setIgnoreUnknownProperty(boolean isIgnore) {
        this.isIgnoreUnknownProperty = isIgnore;
    }

    public boolean isIgnoreUnknownProperty() {
        return this.isIgnoreUnknownProperty;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparatorEscape(char escape) {
        this.separatorEscape = escape;
    }

    public char getSeparatorEscape() {
        return this.separatorEscape;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setEnclose(boolean isEnclose) {
        this.isEnclose = isEnclose;
    }

    public boolean isEnclose() {
        return this.isEnclose;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setIgnoreEmptyLine(boolean isIgnore) {
        this.isIgnoreEmptyLine = isIgnore;
    }

    public boolean isIgnoreEmptyLine() {
        return this.isIgnoreEmptyLine;
    }

    public void setIgnoreLineEndSeparator(boolean isIgnore) {
        this.isIgnoreLineEndSeparator = isIgnore;
    }

    public boolean isIgnoreLineEndSeparator() {
        return this.isIgnoreLineEndSeparator;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toRecordList((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toRecordList((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    @Override
    public InputStream convertToStream(Object obj) throws ConvertException {
        if (!(obj instanceof RecordList)) {
            throw new ConvertException("Input is not RecordList." + obj);
        }
        RecordList recList = (RecordList)obj;
        RecordSchema schema = recList.getRecordSchema();
        if (schema == null) {
            throw new ConvertException("Schema is null." + recList);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i;
            int imax;
            OutputStreamWriter osw = null;
            osw = this.characterEncodingToStream == null ? new OutputStreamWriter(baos) : new OutputStreamWriter((OutputStream)baos, this.characterEncodingToStream);
            CSVWriter writer = new CSVWriter(osw);
            writer.setSeparator(this.separator);
            writer.setSeparatorEscape(this.separatorEscape);
            writer.setEnclosure(this.enclosure);
            writer.setEnclose(this.isEnclose);
            writer.setLineSeparator(this.lineSeparator);
            writer.setNullValue(this.nullValue);
            if (this.isExistsSchema) {
                writer.writeElement(schema.getSchema());
                writer.newLine();
            } else if (this.isExistsHeader) {
                imax = schema.getPropertySize();
                for (i = 0; i < imax; ++i) {
                    writer.writeElement(schema.getPropertyName(i));
                }
                writer.newLine();
            }
            imax = recList.size();
            for (i = 0; i < imax; ++i) {
                Record record = recList.getRecord(i);
                if (record == null) continue;
                int jmax = schema.getPropertySize();
                for (int j = 0; j < jmax; ++j) {
                    writer.writeElement(record.getFormatProperty(j));
                }
                if (i == imax - 1) continue;
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toRecordList(is);
    }

    protected RecordList toRecordList(File file) throws ConvertException {
        try {
            return this.toRecordList(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected RecordList toRecordList(InputStream is) throws ConvertException {
        return this.toRecordList(is, null);
    }

    protected RecordList toRecordList(InputStream is, RecordList recList) throws ConvertException {
        try {
            InputStreamReader isr = null;
            isr = this.characterEncodingToObject == null ? new InputStreamReader(is) : new InputStreamReader(is, this.characterEncodingToObject);
            CSVReader reader = new CSVReader(isr);
            reader.setSeparator(this.separator);
            reader.setSeparatorEscape(this.separatorEscape);
            reader.setEnclosure(this.enclosure);
            reader.setIgnoreEmptyLine(this.isIgnoreEmptyLine);
            reader.setIgnoreLineEndSeparator(this.isIgnoreLineEndSeparator);
            reader.setEnclosed(this.isEnclose);
            reader.setNullValue(this.nullValue);
            if (recList == null) {
                recList = new RecordList();
            }
            RecordSchema schema = recList.getRecordSchema();
            List csv = new ArrayList();
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (this.isExistsSchema) {
                if ((csv = reader.readCSVLineList(csv)) == null) {
                    return recList;
                }
                if (csv.size() != 0) {
                    if (schema == null) {
                        recList.setSchema((String)csv.get(0));
                        schema = recList.getRecordSchema();
                    } else {
                        schema = RecordSchema.getInstance((String)csv.get(0));
                    }
                }
            } else if (schema == null || this.isExistsHeader) {
                if ((csv = reader.readCSVLineList(csv)) == null) {
                    return recList;
                }
                StringBuffer schemaBuf = new StringBuffer();
                int imax = csv.size();
                for (int i = 0; i < imax; ++i) {
                    schemaBuf.append(':');
                    if (this.isExistsHeader) {
                        schemaBuf.append(csv.get(i));
                    } else {
                        schemaBuf.append(i);
                    }
                    schemaBuf.append(',');
                    schemaBuf.append(String.class.getName());
                    if (i == imax - 1) continue;
                    schemaBuf.append('\n');
                }
                if (schema == null) {
                    recList.setSchema(schemaBuf.toString());
                    schema = recList.getRecordSchema();
                } else if (this.isExistsHeader) {
                    schema = RecordSchema.getInstance(schemaBuf.toString());
                }
                if (!this.isExistsHeader) {
                    Record record = recList.createRecord();
                    int imax2 = csv.size();
                    for (int i = 0; i < imax2; ++i) {
                        record.setProperty(i, csv.get(i));
                    }
                    recList.addRecord(record);
                }
            }
            int imax = schema.getPropertySize();
            for (int i = 0; i < imax; ++i) {
                propertyNames.add(schema.getPropertyName(i));
            }
            RecordSchema targetSchema = recList.getRecordSchema();
            while ((csv = reader.readCSVLineList(csv)) != null) {
                Record record = recList.createRecord();
                int size = csv.size();
                int imax3 = propertyNames.size();
                for (int i = 0; i < imax3; ++i) {
                    String name;
                    if (i >= size || targetSchema.getPropertyIndex(name = (String)propertyNames.get(i)) == -1 && this.isIgnoreUnknownProperty) continue;
                    record.setParseProperty(name, csv.get(i));
                }
                recList.addRecord(record);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return recList;
    }

    @Override
    public Object convertToObject(InputStream is, Object returnType) throws ConvertException {
        if (returnType != null && !(returnType instanceof RecordList)) {
            throw new ConvertException("ReturnType is not RecordList." + returnType);
        }
        return this.toRecordList(is, (RecordList)returnType);
    }
}

