/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.sql.Connection;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.datasource.NimbusJdbcConnection;

public class JdbcConnectionTransactionResource
implements TransactionResource {
    private Connection mCon = null;

    public JdbcConnectionTransactionResource(Connection con) {
        this.mCon = con;
    }

    @Override
    public void commit() throws Exception {
        if (!this.mCon.isClosed() && !this.mCon.getAutoCommit()) {
            this.mCon.commit();
        }
    }

    @Override
    public void rollback() throws Exception {
        if (!this.mCon.isClosed()) {
            this.mCon.rollback();
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.mCon.isClosed()) {
            if (this.mCon instanceof NimbusJdbcConnection) {
                NimbusJdbcConnection tmp = (NimbusJdbcConnection)this.mCon;
                tmp.trueClose();
            } else {
                this.mCon.close();
            }
        }
    }

    @Override
    public Object getObject() {
        return this.mCon;
    }
}

