/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.util.net.GlobalUID;

public class GroupClientConnectionImpl
implements ClientConnection,
Serializable {
    private static final long serialVersionUID = 6130317900119964898L;
    private Map connectionMap = Collections.synchronizedMap(new LinkedHashMap());
    private Object id;
    private transient String serviceManagerName;
    private transient boolean isStartReceive;

    public void addClientConnection(String subject, Pattern keyPattern, ClientConnection connection) {
        ArrayList<ClientConnectionImpl> connections = (ArrayList<ClientConnectionImpl>)this.connectionMap.get(subject);
        if (connections == null) {
            connections = new ArrayList<ClientConnectionImpl>();
            this.connectionMap.put(subject, connections);
        }
        connections.add(new ClientConnectionImpl(subject, keyPattern, connection));
    }

    @Override
    public void setServiceManagerName(String name) {
        this.serviceManagerName = name;
    }

    @Override
    public void connect() throws ConnectException {
        this.connect(null);
    }

    @Override
    public void connect(Object id) throws ConnectException {
        if (id == null) {
            try {
                this.id = new GlobalUID();
            }
            catch (UnknownHostException e) {
                throw new ConnectException(e);
            }
        } else {
            this.id = id;
        }
    }

    private List connect(String subject, String[] keys) throws ConnectException {
        List connections = (List)this.connectionMap.get(subject);
        if (connections == null) {
            throw new ConnectException("ClientConnection not found. subject=" + subject);
        }
        ArrayList<ClientConnectionImpl> result = new ArrayList<ClientConnectionImpl>();
        int imax = connections.size();
        block4: for (int i = 0; i < imax; ++i) {
            ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
            if (keys == null || keys.length == 0) {
                if (!connection.isMatch(subject, null)) continue;
                connection.setServiceManagerName(this.serviceManagerName);
                connection.connect(this.id);
                if (this.isStartReceive) {
                    try {
                        connection.startReceive();
                    }
                    catch (MessageSendException e) {
                        throw new ConnectException(e);
                    }
                }
                result.add(connection);
                continue;
            }
            for (int j = 0; j < keys.length; ++j) {
                if (!connection.isMatch(subject, keys[j])) continue;
                connection.setServiceManagerName(this.serviceManagerName);
                connection.connect(this.id);
                if (this.isStartReceive) {
                    try {
                        connection.startReceive();
                    }
                    catch (MessageSendException e) {
                        throw new ConnectException(e);
                    }
                }
                result.add(connection);
                continue block4;
            }
        }
        if (result.size() == 0) {
            throw new ConnectException("ClientConnection not found. subject=" + subject + ", keys=" + this.concatStringArray(keys));
        }
        return result;
    }

    private String concatStringArray(String[] array) {
        StringBuffer buf = new StringBuffer();
        if (array == null) {
            buf.append((String)null);
        } else {
            buf.append('[');
            for (int i = 0; i < array.length; ++i) {
                buf.append(array[i]);
                if (i == array.length - 1) continue;
                buf.append(", ");
            }
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public void addSubject(String subject) throws MessageSendException {
        List connections = null;
        try {
            connections = this.connect(subject, null);
        }
        catch (ConnectException e) {
            throw new MessageSendException(e);
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
            connection.addSubject(subject);
        }
    }

    @Override
    public void addSubject(String subject, String[] keys) throws MessageSendException {
        List connections = null;
        try {
            connections = this.connect(subject, keys);
        }
        catch (ConnectException e) {
            throw new MessageSendException(e);
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
            connection.addSubject(subject, keys);
        }
    }

    @Override
    public void removeSubject(String subject) throws MessageSendException {
        List connections = null;
        try {
            connections = this.connect(subject, null);
        }
        catch (ConnectException e) {
            throw new MessageSendException(e);
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
            connection.removeSubject(subject);
        }
    }

    @Override
    public void removeSubject(String subject, String[] keys) throws MessageSendException {
        List connections = null;
        try {
            connections = this.connect(subject, keys);
        }
        catch (ConnectException e) {
            throw new MessageSendException(e);
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
            connection.removeSubject(subject, keys);
        }
    }

    @Override
    public void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    @Override
    public void startReceive(long from) throws MessageSendException {
        ArrayList connections = new ArrayList(this.connectionMap.values());
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            List connectionList = (List)connections.get(i);
            int jmax = connectionList.size();
            for (int j = 0; j < jmax; ++j) {
                ClientConnection cc = (ClientConnection)connectionList.get(j);
                if (!cc.isConnected()) continue;
                cc.startReceive(from);
            }
        }
        this.isStartReceive = true;
    }

    @Override
    public boolean isStartReceive() {
        return this.isStartReceive;
    }

    @Override
    public void stopReceive() throws MessageSendException {
        if (!this.isStartReceive) {
            return;
        }
        ArrayList connections = new ArrayList(this.connectionMap.values());
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            List connectionList = (List)connections.get(i);
            int jmax = connectionList.size();
            for (int j = 0; j < jmax; ++j) {
                ((ClientConnection)connectionList.get(j)).stopReceive();
            }
        }
    }

    @Override
    public Set getSubjects() {
        HashSet result = new HashSet();
        ArrayList connections = new ArrayList(this.connectionMap.values());
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            List connectionList = (List)connections.get(i);
            int jmax = connectionList.size();
            for (int j = 0; j < jmax; ++j) {
                result.addAll(((ClientConnection)connectionList.get(j)).getSubjects());
            }
        }
        return result;
    }

    @Override
    public Set getKeys(String subject) {
        HashSet result = new HashSet();
        ArrayList connections = new ArrayList(this.connectionMap.values());
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            List connectionList = (List)connections.get(i);
            int jmax = connectionList.size();
            for (int j = 0; j < jmax; ++j) {
                result.addAll(((ClientConnection)connectionList.get(j)).getKeys(subject));
            }
        }
        return result;
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        for (List connections : this.connectionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
                connection.setMessageListener(listener);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.id != null;
    }

    @Override
    public Object getId() {
        if (this.connectionMap == null || this.connectionMap.size() == 0) {
            return this.id;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (List connections : this.connectionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
                if (connection.getId() == null) continue;
                result.add(connection.getId());
            }
        }
        return result.size() == 0 ? this.id : result;
    }

    @Override
    public void close() {
        for (List connections : this.connectionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ClientConnectionImpl connection = (ClientConnectionImpl)connections.get(i);
                try {
                    connection.close();
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(", connectionMap=").append(this.connectionMap);
        buf.append('}');
        return buf.toString();
    }

    private static class ClientConnectionImpl
    implements ClientConnection,
    Serializable {
        private static final long serialVersionUID = 6390935385333885179L;
        private String subject;
        private Pattern keyPattern;
        private ClientConnection connection;
        private transient String serviceManagerName;

        public ClientConnectionImpl(String subject, Pattern keyPattern, ClientConnection connection) {
            this.subject = subject;
            this.keyPattern = keyPattern;
            this.connection = connection;
        }

        public boolean isMatch(String subject, String key) {
            return !(this.subject == null && subject != null || this.subject != null && subject == null || this.subject != null && !this.subject.equals(subject)) && (this.keyPattern == null || key == null || this.keyPattern.matcher(key).matches());
        }

        @Override
        public void setServiceManagerName(String name) {
            this.serviceManagerName = name;
        }

        @Override
        public void connect() throws ConnectException {
            this.connection.setServiceManagerName(this.serviceManagerName);
            this.connection.connect();
        }

        @Override
        public void connect(Object id) throws ConnectException {
            this.connection.setServiceManagerName(this.serviceManagerName);
            this.connection.connect(id);
        }

        @Override
        public void addSubject(String subject) throws MessageSendException {
            if (this.isMatch(subject, null)) {
                this.connection.addSubject(subject);
            }
        }

        @Override
        public void addSubject(String subject, String[] keys) throws MessageSendException {
            if (keys == null) {
                if (this.isMatch(subject, null)) {
                    this.connection.addSubject(subject, keys);
                }
            } else {
                HashSet<String> keySet = new HashSet<String>();
                for (int i = 0; i < keys.length; ++i) {
                    if (!this.isMatch(subject, keys[i])) continue;
                    keySet.add(keys[i]);
                }
                if (keySet.size() != 0) {
                    this.connection.addSubject(subject, keySet.toArray(new String[keySet.size()]));
                }
            }
        }

        @Override
        public void removeSubject(String subject) throws MessageSendException {
            if (this.isMatch(subject, null)) {
                this.connection.removeSubject(subject);
            }
        }

        @Override
        public void removeSubject(String subject, String[] keys) throws MessageSendException {
            if (keys == null) {
                if (this.isMatch(subject, null)) {
                    this.connection.removeSubject(subject, keys);
                }
            } else {
                HashSet<String> keySet = new HashSet<String>();
                for (int i = 0; i < keys.length; ++i) {
                    if (!this.isMatch(subject, keys[i])) continue;
                    keySet.add(keys[i]);
                }
                if (keySet.size() != 0) {
                    this.connection.removeSubject(subject, keySet.toArray(new String[keySet.size()]));
                }
            }
        }

        @Override
        public void startReceive() throws MessageSendException {
            this.startReceive(-1L);
        }

        @Override
        public void startReceive(long from) throws MessageSendException {
            this.connection.startReceive(from);
        }

        @Override
        public boolean isStartReceive() {
            return this.connection.isStartReceive();
        }

        @Override
        public void stopReceive() throws MessageSendException {
            this.connection.stopReceive();
        }

        @Override
        public Set getSubjects() {
            return this.connection.getSubjects();
        }

        @Override
        public Set getKeys(String subject) {
            return this.connection.getKeys(subject);
        }

        @Override
        public void setMessageListener(MessageListener listener) {
            this.connection.setMessageListener(listener);
        }

        @Override
        public boolean isConnected() {
            return this.connection.isConnected();
        }

        @Override
        public Object getId() {
            return this.connection.getId();
        }

        @Override
        public void close() {
            this.connection.close();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("subject=").append(this.subject);
            buf.append(", key=").append(this.keyPattern == null ? null : this.keyPattern.pattern());
            buf.append(", connection=").append(this.connection);
            buf.append('}');
            return buf.toString();
        }
    }
}

