/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.editor.JSONJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class RequestJournalJSONJournalEditorService
extends JSONJournalEditorService {
    private static final long serialVersionUID = 781127949886313069L;
    public static final String PROPERTY_REQUEST_ID = "RequestId";
    public static final String PROPERTY_START_TIME = "StartTime";
    public static final String PROPERTY_JOURNAL_RECORD = "JournalRecord";
    public static final String PROPERTY_END_TIME = "EndTime";
    public static final String PROPERTY_PERFORMANCE = "Performance";

    @Override
    protected StringBuffer appendUnknownValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        JournalRecord[] records;
        if (!(value instanceof RequestJournal)) {
            return super.appendUnknownValue(buf, finder, type, value);
        }
        RequestJournal request = (RequestJournal)value;
        buf.append("{");
        boolean isOutput = false;
        if (this.isOutputProperty(PROPERTY_REQUEST_ID)) {
            this.appendProperty(buf, finder, PROPERTY_REQUEST_ID, request.getRequestId());
            isOutput = true;
        }
        if (this.isOutputProperty(PROPERTY_START_TIME)) {
            if (isOutput) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, PROPERTY_START_TIME, request.getStartTime());
            isOutput = true;
        }
        if (this.isOutputProperty(PROPERTY_JOURNAL_RECORD) && (records = request.getParamAry()) != null && records.length != 0) {
            if (isOutput) {
                buf.append(",");
            }
            this.appendName(buf, PROPERTY_JOURNAL_RECORD);
            buf.append(":");
            buf.append("[");
            boolean isOutputPre = false;
            for (JournalRecord record : records) {
                isOutput = this.isOutputProperty(record.getKey());
                if (isOutputPre && isOutput) {
                    buf.append(",");
                }
                if (!isOutput) continue;
                Object infoObj = record.toObject(finder);
                JournalEditor editor = record.getJournalEditor();
                if (editor != null && editor instanceof JSONJournalEditorService) {
                    buf.append(infoObj);
                } else {
                    buf.append("{");
                    this.appendProperty(buf, finder, record.getKey(), infoObj);
                    buf.append("}");
                }
                isOutputPre = isOutput;
            }
            buf.append("]");
            isOutput = true;
        }
        if (this.isOutputProperty(PROPERTY_END_TIME)) {
            if (isOutput) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, PROPERTY_END_TIME, request.getEndTime());
            isOutput = true;
        }
        if (this.isOutputProperty(PROPERTY_PERFORMANCE)) {
            if (isOutput) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, PROPERTY_PERFORMANCE, new Long(request.getEndTime().getTime() - request.getStartTime().getTime()));
            isOutput = true;
        }
        buf.append("}");
        return buf;
    }
}

