/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.http.proxy.HttpProcessServiceBaseMBean;
import jp.ossc.nimbus.service.http.proxy.HttpRequest;
import jp.ossc.nimbus.service.http.proxy.HttpResponse;
import jp.ossc.nimbus.service.http.proxy.Process;

public abstract class HttpProcessServiceBase
extends ServiceBase
implements HttpProcessServiceBaseMBean,
Process {
    private static final long serialVersionUID = 7809414473826320613L;
    private boolean isRequestStreamInflate = true;

    @Override
    public void setRequestStreamInflate(boolean isInflate) {
        this.isRequestStreamInflate = isInflate;
    }

    @Override
    public boolean isRequestStreamInflate() {
        return this.isRequestStreamInflate;
    }

    @Override
    public void doProcess(InputStream is, OutputStream os) throws Exception {
        HttpRequest request = null;
        try {
            request = new HttpRequest(is);
            if (request.body != null) {
                request.body.setDecompress(this.isRequestStreamInflate());
            }
        }
        catch (Exception e) {
            HttpResponse response = new HttpResponse();
            response.setStatusCode(400);
            response.setStatusMessage(e.getMessage());
            PrintStream ps = new PrintStream(response.getOutputStream());
            e.printStackTrace(ps);
            ps.flush();
            response.writeResponse(request, os);
            return;
        }
        HttpResponse response = new HttpResponse();
        response.setVersion(request.getHeader().getVersion());
        try {
            this.doProcess(request, response);
        }
        catch (Exception e) {
            response.setStatusCode(500);
            response.setStatusMessage(e.getMessage());
            PrintStream ps = new PrintStream(response.getOutputStream());
            e.printStackTrace(ps);
            ps.flush();
            response.writeResponse(request, os);
            return;
        }
        response.writeResponse(request, os);
    }

    public abstract void doProcess(HttpRequest var1, HttpResponse var2) throws Exception;
}

