/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;

public class PartUpdateRecords
implements Serializable {
    private static final long serialVersionUID = -4013884085932487925L;
    protected List keys;
    protected Map keyMap;
    protected Map records = new LinkedHashMap();
    protected boolean containsAdd;
    protected boolean containsUpdate;
    protected boolean containsRemove;
    protected boolean isFilledRecord = true;

    public void addRecord(CodeMasterUpdateKey key) {
        this.addRecord(key, null);
    }

    public void addRecord(CodeMasterUpdateKey key, Object record) {
        switch (key.getUpdateType()) {
            case 1: {
                this.containsAdd = true;
                if (record != null) break;
                this.isFilledRecord = false;
                break;
            }
            case 2: {
                this.containsUpdate = true;
                if (record != null) break;
                this.isFilledRecord = false;
                break;
            }
            case 3: {
                this.containsRemove = true;
                break;
            }
        }
        this.records.put(key, record);
        if (this.keys != null && !this.keys.contains(key)) {
            this.keys.add(key);
        }
        if (this.keyMap != null && !this.keyMap.containsKey(key)) {
            this.keyMap.put(key, key);
        }
    }

    public Map getRecords() {
        return this.records;
    }

    public Object removeRecord(CodeMasterUpdateKey key) {
        Object record = this.records.remove(key);
        if (this.keys != null) {
            this.keys.remove(key);
        }
        if (this.keyMap != null) {
            this.keyMap.remove(key);
        }
        return record;
    }

    public Iterator getKeys() {
        return new KeyIterator();
    }

    public CodeMasterUpdateKey[] getKeyArray() {
        return this.records.keySet().toArray(new CodeMasterUpdateKey[this.records.size()]);
    }

    public Object getRecord(CodeMasterUpdateKey key) {
        return this.records.get(key);
    }

    public CodeMasterUpdateKey getKey(CodeMasterUpdateKey key) {
        if (this.keys == null) {
            this.keys = new ArrayList();
            this.keys.addAll(this.records.keySet());
        }
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
            int imax = this.keys.size();
            for (int i = 0; i < imax; ++i) {
                Object keyObj = this.keys.get(i);
                this.keyMap.put(keyObj, keyObj);
            }
        }
        return (CodeMasterUpdateKey)this.keyMap.get(key);
    }

    public boolean containsAdd() {
        return this.containsAdd;
    }

    public boolean containsUpdate() {
        return this.containsUpdate;
    }

    public boolean containsRemove() {
        return this.containsRemove;
    }

    public boolean isFilledRecord() {
        return this.size() != 0 && this.isFilledRecord;
    }

    public void setFilledRecord(boolean isFilled) {
        this.isFilledRecord = isFilled;
    }

    public int size() {
        return this.records.size();
    }

    public void clear() {
        this.records.clear();
        if (this.keys != null) {
            this.keys.clear();
        }
        if (this.keyMap != null) {
            this.keyMap.clear();
        }
    }

    private class KeyIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = -4013884085802487925L;
        private Iterator itr;
        private CodeMasterUpdateKey current;

        private KeyIterator() {
            this.itr = PartUpdateRecords.this.records.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            this.current = (CodeMasterUpdateKey)this.itr.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.itr.remove();
            if (PartUpdateRecords.this.keys != null && this.current != null) {
                PartUpdateRecords.this.keys.remove(this.current);
            }
            if (PartUpdateRecords.this.keyMap != null && this.current != null) {
                PartUpdateRecords.this.keyMap.remove(this.current);
            }
        }
    }
}

