/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.Random;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.SleepInterceptorServiceMBean;

public class SleepInterceptorService
extends ServiceBase
implements Interceptor,
SleepInterceptorServiceMBean {
    private static final long serialVersionUID = 4049992073980961148L;
    private long sleepTime;
    private int randomSleepTime;

    @Override
    public void setSleepTime(long time) {
        this.sleepTime = time;
    }

    @Override
    public long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public void setRandomSleepTime(int time) {
        this.randomSleepTime = time;
    }

    @Override
    public int getRandomSleepTime() {
        return this.randomSleepTime;
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            long currentSleepTime = 0L;
            if (this.sleepTime > 0L) {
                currentSleepTime = this.sleepTime;
            } else if (this.randomSleepTime > 0) {
                Random random = new Random(System.currentTimeMillis());
                currentSleepTime = random.nextInt(this.randomSleepTime);
            }
            if (currentSleepTime > 0L) {
                try {
                    Thread.sleep(currentSleepTime);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
        return chain.invokeNext(context);
    }
}

