/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.FormatConverter;

public class DecimalFormatConverter
implements FormatConverter {
    private static final long serialVersionUID = -1183874197480695923L;
    public static final int NUMBER_FROM_STRING = 1;
    public static final int STRING_FROM_NUMBER = 2;
    protected static final String DOUBLE_NAN_STR;
    protected static final String DOUBLE_POSITIVE_INFINITY_STR;
    protected static final String DOUBLE_NEGATIVE_INFINITY_STR;
    protected int convertType;
    protected String format;
    protected boolean isUseNotApplicable;
    protected Byte notApplicableForByte;
    protected Short notApplicableForShort;
    protected Integer notApplicableForInt;
    protected Long notApplicableForLong;
    protected Float notApplicableForFloat;
    protected Double notApplicableForDouble;
    protected BigInteger notApplicableForBigInteger;
    protected BigDecimal notApplicableForBigDecimal;
    protected String notApplicableStringForByte;
    protected String notApplicableStringForShort;
    protected String notApplicableStringForInt;
    protected String notApplicableStringForLong;
    protected String notApplicableStringForFloat;
    protected String notApplicableStringForDouble;
    protected String notApplicableStringForBigInteger;
    protected String notApplicableStringForBigDecimal;

    public DecimalFormatConverter() {
        this(1, "");
    }

    public DecimalFormatConverter(int type, String format) {
        this.convertType = type;
        this.format = format;
        new DecimalFormat(format);
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isUseNotApplicable() {
        return this.isUseNotApplicable;
    }

    public void setUseNotApplicable(boolean isUse) {
        this.isUseNotApplicable = isUse;
    }

    public Byte getNotApplicableForByte() {
        return this.notApplicableForByte;
    }

    public void setNotApplicableForByte(Byte na) {
        this.notApplicableForByte = na;
    }

    public Short getNotApplicableForShort() {
        return this.notApplicableForShort;
    }

    public void setNotApplicableForShort(Short na) {
        this.notApplicableForShort = na;
    }

    public Integer getNotApplicableForInt() {
        return this.notApplicableForInt;
    }

    public void setNotApplicableForInt(Integer na) {
        this.notApplicableForInt = na;
    }

    public Long getNotApplicableForLong() {
        return this.notApplicableForLong;
    }

    public void setNotApplicableForLong(Long na) {
        this.notApplicableForLong = na;
    }

    public Float getNotApplicableForFloat() {
        return this.notApplicableForFloat;
    }

    public void setNotApplicableForFloat(Float na) {
        this.notApplicableForFloat = na;
    }

    public Double getNotApplicableForDouble() {
        return this.notApplicableForDouble;
    }

    public void setNotApplicableForDouble(Double na) {
        this.notApplicableForDouble = na;
    }

    public BigInteger getNotApplicableForBigInteger() {
        return this.notApplicableForBigInteger;
    }

    public void setNotApplicableForBigInteger(BigInteger na) {
        this.notApplicableForBigInteger = na;
    }

    public BigDecimal getNotApplicableForBigDecimal() {
        return this.notApplicableForBigDecimal;
    }

    public void setNotApplicableForBigDecimal(BigDecimal na) {
        this.notApplicableForBigDecimal = na;
    }

    public String getNotApplicableStringForByte() {
        return this.notApplicableStringForByte;
    }

    public void setNotApplicableStringForByte(String na) {
        this.notApplicableStringForByte = na;
    }

    public String getNotApplicableStringForShort() {
        return this.notApplicableStringForShort;
    }

    public void setNotApplicableStringForShort(String na) {
        this.notApplicableStringForShort = na;
    }

    public String getNotApplicableStringForInt() {
        return this.notApplicableStringForInt;
    }

    public void setNotApplicableStringForInt(String na) {
        this.notApplicableStringForInt = na;
    }

    public String getNotApplicableStringForLong() {
        return this.notApplicableStringForLong;
    }

    public void setNotApplicableStringForLong(String na) {
        this.notApplicableStringForLong = na;
    }

    public String getNotApplicableStringForFloat() {
        return this.notApplicableStringForFloat;
    }

    public void setNotApplicableStringForFloat(String na) {
        this.notApplicableStringForFloat = na;
    }

    public String getNotApplicableStringForDouble() {
        return this.notApplicableStringForDouble;
    }

    public void setNotApplicableStringForDouble(String na) {
        this.notApplicableStringForDouble = na;
    }

    public String getNotApplicableStringForBigInteger() {
        return this.notApplicableStringForBigInteger;
    }

    public void setNotApplicableStringForBigInteger(String na) {
        this.notApplicableStringForBigInteger = na;
    }

    public String getNotApplicableStringForBigDecimal() {
        return this.notApplicableStringForBigDecimal;
    }

    public void setNotApplicableStringForBigDecimal(String na) {
        this.notApplicableStringForBigDecimal = na;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        switch (this.convertType) {
            case 1: {
                if (this.isUseNotApplicable) {
                    if (obj instanceof Byte) {
                        if (this.notApplicableForByte == null && obj == null || this.notApplicableForByte != null && this.notApplicableForByte.equals(obj)) {
                            return this.notApplicableStringForByte;
                        }
                    } else if (obj instanceof Short) {
                        if (this.notApplicableForShort == null && obj == null || this.notApplicableForShort != null && this.notApplicableForShort.equals(obj)) {
                            return this.notApplicableStringForShort;
                        }
                    } else if (obj instanceof Integer) {
                        if (this.notApplicableForInt == null && obj == null || this.notApplicableForInt != null && this.notApplicableForInt.equals(obj)) {
                            return this.notApplicableStringForInt;
                        }
                    } else if (obj instanceof Long) {
                        if (this.notApplicableForLong == null && obj == null || this.notApplicableForLong != null && this.notApplicableForLong.equals(obj)) {
                            return this.notApplicableStringForLong;
                        }
                    } else if (obj instanceof Float) {
                        if (this.notApplicableForFloat == null && obj == null || this.notApplicableForFloat != null && this.notApplicableForFloat.equals(obj)) {
                            return this.notApplicableStringForFloat;
                        }
                    } else if (obj instanceof Double) {
                        if (this.notApplicableForDouble == null && obj == null || this.notApplicableForDouble != null && this.notApplicableForDouble.equals(obj)) {
                            return this.notApplicableStringForDouble;
                        }
                    } else if (obj instanceof BigInteger) {
                        if (this.notApplicableForBigInteger == null && obj == null || this.notApplicableForBigInteger != null && this.notApplicableForBigInteger.equals(obj)) {
                            return this.notApplicableStringForBigInteger;
                        }
                    } else if (obj instanceof BigDecimal && (this.notApplicableForBigDecimal == null && obj == null || this.notApplicableForBigDecimal != null && this.notApplicableForBigDecimal.equals(obj))) {
                        return this.notApplicableStringForBigDecimal;
                    }
                }
                if (obj == null) {
                    return new DecimalFormat(this.format).format(new Long(0L));
                }
                return new DecimalFormat(this.format).format(obj);
            }
            case 2: {
                if (this.isUseNotApplicable) {
                    if (this.notApplicableStringForByte == null && obj == null || this.notApplicableStringForByte != null && this.notApplicableStringForByte.equals(obj)) {
                        return this.notApplicableForByte;
                    }
                    if (this.notApplicableStringForShort == null && obj == null || this.notApplicableStringForShort != null && this.notApplicableStringForShort.equals(obj)) {
                        return this.notApplicableForShort;
                    }
                    if (this.notApplicableStringForInt == null && obj == null || this.notApplicableStringForInt != null && this.notApplicableStringForInt.equals(obj)) {
                        return this.notApplicableForInt;
                    }
                    if (this.notApplicableStringForLong == null && obj == null || this.notApplicableStringForLong != null && this.notApplicableStringForLong.equals(obj)) {
                        return this.notApplicableForLong;
                    }
                    if (this.notApplicableStringForFloat == null && obj == null || this.notApplicableStringForFloat != null && this.notApplicableStringForFloat.equals(obj)) {
                        return this.notApplicableForFloat;
                    }
                    if (this.notApplicableStringForDouble == null && obj == null || this.notApplicableStringForDouble != null && this.notApplicableStringForDouble.equals(obj)) {
                        return this.notApplicableForDouble;
                    }
                    if (this.notApplicableStringForBigInteger == null && obj == null || this.notApplicableStringForBigInteger != null && this.notApplicableStringForBigInteger.equals(obj)) {
                        return this.notApplicableForBigInteger;
                    }
                    if (this.notApplicableStringForBigDecimal == null && obj == null || this.notApplicableStringForBigDecimal != null && this.notApplicableStringForBigDecimal.equals(obj)) {
                        return this.notApplicableForBigDecimal;
                    }
                }
                if (obj == null) {
                    return new Long(0L);
                }
                if (obj instanceof String) {
                    String val = (String)obj;
                    if (DOUBLE_NAN_STR.equals(val)) {
                        return new Double(Double.NaN);
                    }
                    if (DOUBLE_NEGATIVE_INFINITY_STR.equals(val)) {
                        return new Double(Double.NEGATIVE_INFINITY);
                    }
                    if (DOUBLE_POSITIVE_INFINITY_STR.equals(val)) {
                        return new Double(Double.POSITIVE_INFINITY);
                    }
                }
                try {
                    return new DecimalFormat(this.format).parse((String)obj);
                }
                catch (ParseException e) {
                    throw new ConvertException(e);
                }
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    static {
        DecimalFormat f = new DecimalFormat("#.#");
        DOUBLE_NAN_STR = f.format(Double.NaN);
        DOUBLE_POSITIVE_INFINITY_STR = f.format(Double.POSITIVE_INFINITY);
        DOUBLE_NEGATIVE_INFINITY_STR = f.format(Double.NEGATIVE_INFINITY);
    }
}

