/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.OneWriteFileMessageWriterServiceMBean;
import jp.ossc.nimbus.service.writer.SimpleElement;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;

public class OneWriteFileMessageWriterService
extends ServiceBase
implements OneWriteFileMessageWriterServiceMBean,
MessageWriter {
    private static final long serialVersionUID = -6432768686393327903L;
    private String encoding;
    private String file;
    private boolean isEveryTimeCloseStream = true;
    private FileName fileName;
    private FileOutputStream fos;
    private boolean isAppend;
    private String filePrefix;
    private String filePostfix;
    private ServiceName contextServiceName;
    private Context context;
    private boolean isOutputKey = true;
    private String separator;
    private String header;

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setAppend(boolean isAppend) {
        this.isAppend = isAppend;
    }

    @Override
    public boolean isAppend() {
        return this.isAppend;
    }

    @Override
    public void setEveryTimeCloseStream(boolean isClose) {
        this.isEveryTimeCloseStream = isClose;
    }

    @Override
    public boolean isEveryTimeCloseStream() {
        return this.isEveryTimeCloseStream;
    }

    @Override
    public void setFilePrefix(String prefix) {
        this.filePrefix = prefix;
    }

    @Override
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    public void setFilePostfix(String postfix) {
        this.filePostfix = postfix;
    }

    @Override
    public String getFilePostfix() {
        return this.filePostfix;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void setOutputKey(boolean isOutput) {
        this.isOutputKey = isOutput;
    }

    @Override
    public boolean isOutputKey() {
        return this.isOutputKey;
    }

    @Override
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void startService() throws Exception {
        if (this.encoding != null) {
            new String().getBytes(this.encoding);
        }
        if (this.file == null || this.file.length() == 0) {
            throw new IllegalArgumentException("file must be specified.");
        }
        File f = new File(this.file);
        if (f.getParentFile() != null && !f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("file is illegal path." + this.file);
        }
        this.fileName = new FileName(this.file, this.filePrefix, this.filePostfix);
        if (!this.isEveryTimeCloseStream) {
            if (!this.fileName.isStatic()) {
                throw new IllegalArgumentException("Dynamic filename!");
            }
            boolean isExistsFile = new File(this.fileName.toString(null)).exists();
            this.fos = new FileOutputStream(this.fileName.toString(null), this.isAppend);
            if (!(this.header == null || isExistsFile && this.isAppend)) {
                WritableRecord headerRecord = new WritableRecord();
                headerRecord.addElement(new SimpleElement(null, this.header));
                this.write(headerRecord);
            }
        }
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.fos != null) {
            this.fos.close();
            this.fos = null;
        }
    }

    @Override
    public void write(WritableRecord rec) throws MessageWriteException {
        FileOutputStream tmpFos = null;
        try {
            if (this.isEveryTimeCloseStream) {
                String path = this.fileName.toString(rec);
                boolean isExistsFile = new File(path).exists();
                tmpFos = new FileOutputStream(path, this.isAppend);
                if (!(this.header == null || isExistsFile && this.isAppend)) {
                    WritableRecord headerRecord = new WritableRecord();
                    headerRecord.addElement(new SimpleElement(null, this.header));
                    this.write(headerRecord);
                }
            } else {
                tmpFos = this.fos;
            }
            if (this.encoding == null) {
                tmpFos.write(rec.toString().getBytes());
                if (this.isAppend && this.separator != null) {
                    tmpFos.write(this.separator.getBytes());
                }
            } else {
                tmpFos.write(rec.toString().getBytes(this.encoding));
                if (this.isAppend && this.separator != null) {
                    tmpFos.write(this.separator.getBytes(this.encoding));
                }
            }
        }
        catch (IOException e) {
            throw new MessageWriteException(e);
        }
        finally {
            if (this.isEveryTimeCloseStream && tmpFos != null) {
                try {
                    tmpFos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class DynamicFileNameElement
    implements FileNameElement,
    Serializable {
        private static final long serialVersionUID = -3199326390559770733L;
        private String elementKey;

        DynamicFileNameElement(String key) {
            this.elementKey = key;
        }

        @Override
        public String toString(WritableRecord rec) {
            Object val;
            if (rec != null) {
                WritableElement element = null;
                element = OneWriteFileMessageWriterService.this.isOutputKey ? (WritableElement)rec.getElementMap().get(this.elementKey) : (WritableElement)rec.getElementMap().remove(this.elementKey);
                if (element != null) {
                    return element.toString();
                }
            }
            if (OneWriteFileMessageWriterService.this.context != null && (val = OneWriteFileMessageWriterService.this.context.get(this.elementKey)) != null) {
                return val.toString();
            }
            return this.elementKey;
        }
    }

    private static class StaticFileNameElement
    implements FileNameElement,
    Serializable {
        private static final long serialVersionUID = 6476024043797533112L;
        private String value;

        StaticFileNameElement(String val) {
            this.value = val;
        }

        @Override
        public String toString(WritableRecord rec) {
            return this.value;
        }
    }

    private static interface FileNameElement {
        public String toString(WritableRecord var1);
    }

    private class FileName
    implements Serializable,
    FileNameElement {
        private static final long serialVersionUID = 8733352570482641858L;
        private List fileNameElements = new ArrayList();
        private boolean isStatic = true;

        FileName(String path, String prefix, String postfix) throws IOException {
            File file = new File(path);
            if (file.getParentFile() != null) {
                String dir = file.getParentFile().getAbsolutePath();
                if (dir.charAt(dir.length() - 1) != '/') {
                    dir = dir + '/';
                }
                this.fileNameElements.add(new StaticFileNameElement(dir));
            }
            this.parse(prefix);
            this.fileNameElements.add(new StaticFileNameElement(file.getName()));
            this.parse(postfix);
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        private void parse(String val) {
            if (val == null || val.length() == 0) {
                return;
            }
            boolean isEscape = false;
            boolean isKey = false;
            StringBuffer buf = new StringBuffer();
            int max = val.length();
            block4: for (int i = 0; i < max; ++i) {
                char c = val.charAt(i);
                switch (c) {
                    case '%': {
                        if (isEscape) {
                            buf.append(c);
                        } else if (isKey) {
                            this.fileNameElements.add(new DynamicFileNameElement(buf.toString()));
                            this.isStatic = false;
                            buf.setLength(0);
                            isKey = false;
                        } else {
                            if (buf.length() != 0) {
                                this.fileNameElements.add(new StaticFileNameElement(buf.toString()));
                                buf.setLength(0);
                            }
                            isKey = true;
                        }
                        isEscape = false;
                        continue block4;
                    }
                    case '\\': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        isEscape = true;
                        continue block4;
                    }
                    default: {
                        buf.append(c);
                        isEscape = false;
                    }
                }
            }
            if (isKey || isEscape) {
                throw new IllegalArgumentException("Illegal format : " + val);
            }
            if (buf.length() != 0) {
                this.fileNameElements.add(new StaticFileNameElement(buf.toString()));
                buf.setLength(0);
            }
        }

        @Override
        public String toString(WritableRecord rec) {
            StringBuffer buf = new StringBuffer();
            Iterator elements = this.fileNameElements.iterator();
            while (elements.hasNext()) {
                buf.append(((FileNameElement)elements.next()).toString(rec));
            }
            return buf.toString();
        }
    }
}

