/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.ArrayList;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler.DateEvaluator;
import jp.ossc.nimbus.service.scheduler.DateKey;
import jp.ossc.nimbus.service.scheduler.DateMappingScheduleFactoryServiceMBean;
import jp.ossc.nimbus.service.scheduler.KeyMappingScheduleFactoryService;
import jp.ossc.nimbus.service.scheduler.Schedule;
import jp.ossc.nimbus.service.scheduler.ScheduleFactory;

public class DateMappingScheduleFactoryService
extends KeyMappingScheduleFactoryService
implements DateMappingScheduleFactoryServiceMBean,
ScheduleFactory {
    private static final long serialVersionUID = 4003381978120630251L;
    protected ServiceName dateEvaluatorServiceName;
    protected DateEvaluator dateEvaluator;

    @Override
    public void setDateEvaluatorServiceName(ServiceName name) {
        this.dateEvaluatorServiceName = name;
    }

    @Override
    public ServiceName getDateEvaluatorServiceName() {
        return this.dateEvaluatorServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.dateEvaluatorServiceName != null) {
            this.dateEvaluator = (DateEvaluator)ServiceManagerFactory.getServiceObject(this.dateEvaluatorServiceName);
        }
        super.startService();
    }

    public void setDateEvaluator(DateEvaluator evaluator) {
        this.dateEvaluator = evaluator;
    }

    @Override
    protected Object createKey(Object key) throws Exception {
        if (key instanceof String) {
            return new DateKey((String)key, this.dateEvaluator);
        }
        if (key instanceof DateKey) {
            DateKey dateKey = (DateKey)key;
            if (dateKey.getDateEvaluator() == null) {
                dateKey.setDateEvaluator(this.dateEvaluator);
            }
            return dateKey;
        }
        throw new IllegalArgumentException("Key should be an instance of String or DateKey." + key.getClass());
    }

    @Override
    public Schedule[] getSchedules(Object key) {
        ScheduleFactory factory = null;
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        if (key instanceof Date) {
            Date date = (Date)key;
            for (DateKey dateKey : this.keyAndScheduleFactory.keySet()) {
                boolean isMatch = false;
                try {
                    isMatch = dateKey.equalsDate(date);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
                if (!isMatch) continue;
                factory = (ScheduleFactory)this.keyAndScheduleFactory.get(dateKey);
                Schedule[] schs = factory.getSchedules(key);
                for (int i = 0; i < schs.length; ++i) {
                    schedules.add(schs[i]);
                }
            }
        }
        if (factory == null && this.defaultScheduleFactory != null) {
            factory = this.defaultScheduleFactory;
            Schedule[] schs = factory.getSchedules(key);
            for (int i = 0; i < schs.length; ++i) {
                schedules.add(schs[i]);
            }
        }
        return factory == null ? new Schedule[]{} : schedules.toArray(new Schedule[schedules.size()]);
    }
}

