/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.scheduler.DatabaseScheduleStateManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler.ScheduleStateManager;

public class DatabaseScheduleStateManagerService
extends ServiceBase
implements ScheduleStateManager,
DatabaseScheduleStateManagerServiceMBean {
    private static final long serialVersionUID = 8555788220745051629L;
    private static final String MSG_ID_00001 = "DBSM_00001";
    private static final String MSG_ID_00002 = "DBSM_00002";
    private static final String MSG_ID_00003 = "DBSM_00002";
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private String scheduleStateInsertQuery;
    private String scheduleStateSelectQuery;
    private String scheduleStateUpdateQuery;
    private String scheduleStateDeleteQuery;
    private String scheduleStateTruncateQuery;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setScheduleStateInsertQuery(String query) {
        this.scheduleStateInsertQuery = query;
    }

    @Override
    public String getScheduleStateInsertQuery() {
        return this.scheduleStateInsertQuery;
    }

    @Override
    public void setScheduleStateSelectQuery(String query) {
        this.scheduleStateSelectQuery = query;
    }

    @Override
    public String getScheduleStateSelectQuery() {
        return this.scheduleStateSelectQuery;
    }

    @Override
    public void setScheduleStateUpdateQuery(String query) {
        this.scheduleStateUpdateQuery = query;
    }

    @Override
    public String getScheduleStateUpdateQuery() {
        return this.scheduleStateUpdateQuery;
    }

    @Override
    public void setScheduleStateDeleteQuery(String query) {
        this.scheduleStateDeleteQuery = query;
    }

    @Override
    public String getScheduleStateDeleteQuery() {
        return this.scheduleStateDeleteQuery;
    }

    @Override
    public void setScheduleStateTruncateQuery(String query) {
        this.scheduleStateTruncateQuery = query;
    }

    @Override
    public String getScheduleStateTruncateQuery() {
        return this.scheduleStateTruncateQuery;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    @Override
    public void startService() throws Exception {
        if (this.scheduleStateSelectQuery == null) {
            throw new IllegalArgumentException("ScheduleStateSelectQuery must be specified.");
        }
        if (this.scheduleStateUpdateQuery == null) {
            throw new IllegalArgumentException("ScheduleStateUpdateQuery must be specified.");
        }
        if (this.scheduleStateTruncateQuery == null) {
            throw new IllegalArgumentException("ScheduleStateTruncateQuery must be specified.");
        }
        if (this.connectionFactoryServiceName == null && this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactoryServiceName or  ConnectionFactory must be specified.");
        }
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeState(String name, int state) {
        Connection con = null;
        PreparedStatement selectPs = null;
        Statement updatePs = null;
        Statement insertPs = null;
        ResultSet rs = null;
        try {
            con = this.connectionFactory.getConnection();
            selectPs = con.prepareStatement(this.scheduleStateSelectQuery);
            selectPs.setString(1, name);
            rs = selectPs.executeQuery();
            if (rs.next()) {
                int oldState = rs.getInt(1);
                if (rs.wasNull()) {
                    oldState = -1;
                }
                if (state != oldState) {
                    updatePs = con.prepareStatement(this.scheduleStateUpdateQuery);
                    updatePs.setInt(1, state);
                    updatePs.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    updatePs.setString(3, name);
                    updatePs.executeUpdate();
                }
            } else {
                insertPs = con.prepareStatement(this.scheduleStateInsertQuery);
                insertPs.setString(1, name);
                insertPs.setInt(2, state);
                insertPs.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                insertPs.executeUpdate();
            }
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().write(MSG_ID_00001, new Object[]{name, new Integer(state)}, (Throwable)e);
        }
        catch (SQLException e) {
            this.getLogger().write(MSG_ID_00001, new Object[]{name, new Integer(state)}, (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (selectPs != null) {
                try {
                    selectPs.close();
                }
                catch (SQLException e) {}
            }
            if (updatePs != null) {
                try {
                    updatePs.close();
                }
                catch (SQLException e) {}
            }
            if (insertPs != null) {
                try {
                    insertPs.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState(String name) {
        Connection con = null;
        PreparedStatement selectPs = null;
        ResultSet rs = null;
        try {
            con = this.connectionFactory.getConnection();
            selectPs = con.prepareStatement(this.scheduleStateSelectQuery);
            selectPs.setString(1, name);
            rs = selectPs.executeQuery();
            if (rs.next()) {
                int state = rs.getInt(1);
                if (rs.wasNull()) {
                    state = -1;
                }
                int n = state;
                return n;
            }
            int state = -1;
            return state;
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().write("DBSM_00002", (Object)name, (Throwable)e);
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            this.getLogger().write("DBSM_00002", (Object)name, (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (selectPs != null) {
                try {
                    selectPs.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearState(String name) {
        Connection con = null;
        Statement updatePs = null;
        Statement deletePs = null;
        try {
            con = this.connectionFactory.getConnection();
            if (this.scheduleStateDeleteQuery == null) {
                updatePs = con.prepareStatement(this.scheduleStateUpdateQuery);
                updatePs.setInt(1, -1);
                updatePs.setString(2, name);
                updatePs.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                updatePs.executeUpdate();
            } else {
                deletePs = con.prepareStatement(this.scheduleStateDeleteQuery);
                deletePs.setString(1, name);
                deletePs.executeUpdate();
            }
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().write(MSG_ID_00001, new Object[]{name, new Integer(-1)}, (Throwable)e);
        }
        catch (SQLException e) {
            this.getLogger().write(MSG_ID_00001, new Object[]{name, new Integer(-1)}, (Throwable)e);
        }
        finally {
            if (updatePs != null) {
                try {
                    updatePs.close();
                }
                catch (SQLException e) {}
            }
            if (deletePs != null) {
                try {
                    deletePs.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllStates() {
        Connection con = null;
        Statement st = null;
        try {
            con = this.connectionFactory.getConnection();
            st = con.createStatement();
            st.executeQuery(this.scheduleStateTruncateQuery);
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().write("DBSM_00002", e);
        }
        catch (SQLException e) {
            this.getLogger().write("DBSM_00002", e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

