/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionTransactionResource;

public class JdbcConnectionFactoryService
extends ServiceBase
implements ResourceFactory,
JdbcConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 5783846296550167721L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactoryServiceName or ConnectionFactory must be specified.");
        }
    }

    @Override
    public void stopService() throws Exception {
        this.connectionFactory = null;
    }

    @Override
    public TransactionResource makeResource(String key) throws Exception {
        if (this.connectionFactory == null) {
            return null;
        }
        return new JdbcConnectionTransactionResource(this.connectionFactory.getConnection());
    }
}

