/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource;

import java.lang.reflect.Constructor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.resource.DefaultPooledTransactionResource;
import jp.ossc.nimbus.service.resource.PooledResourceFactoryServiceMBean;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PooledResourceFactoryService
extends ServiceBase
implements ResourceFactory,
PooledResourceFactoryServiceMBean {
    private static final long serialVersionUID = -4615328544007250967L;
    private Class poolableObjectFactoryClass;
    private ServiceName poolableObjectFactoryServiceName;
    private GenericObjectPool pool;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private long minEvictableIdleTime = 1800000L;
    private int numTestsPerEvictionRun = 3;
    private boolean isTestOnBorrow = false;
    private boolean isTestOnReturn = false;
    private boolean isTestWhileIdle = false;
    private long timeBetweenEvictionRuns = -1L;
    private String whenExhaustedActionName = "WHEN_EXHAUSTED_BLOCK";
    private byte whenExhaustedActionValue = 1;
    private Class pooledTransactionResourceClass = DefaultPooledTransactionResource.class;
    private Constructor transactionResourceConstructor;

    @Override
    public void setPoolableObjectFactoryClass(Class clazz) {
        this.poolableObjectFactoryClass = clazz;
    }

    @Override
    public Class getPoolableObjectFactoryClass() {
        return this.poolableObjectFactoryClass;
    }

    @Override
    public void setPoolableObjectFactoryServiceName(ServiceName name) {
        this.poolableObjectFactoryServiceName = name;
    }

    @Override
    public ServiceName getPoolableObjectFactoryServiceName() {
        return this.poolableObjectFactoryServiceName;
    }

    @Override
    public void setMaxActive(int max) {
        this.maxActive = max;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public void setMaxIdle(int max) {
        this.maxIdle = max;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public void setMinIdle(int min) {
        this.minIdle = min;
    }

    @Override
    public int getMinIdle() {
        return this.minIdle;
    }

    @Override
    public void setMaxWaitTime(long maxMillis) {
        this.maxWait = maxMillis;
    }

    @Override
    public long getMaxWaitTime() {
        return this.maxWait;
    }

    @Override
    public void setMinEvictableIdleTime(long minMillis) {
        this.minEvictableIdleTime = minMillis;
    }

    @Override
    public long getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    @Override
    public void setNumTestsPerEvictionRun(int num) {
        this.numTestsPerEvictionRun = num;
    }

    @Override
    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public void setTestOnBorrow(boolean isTest) {
        this.isTestOnBorrow = isTest;
    }

    @Override
    public boolean isTestOnBorrow() {
        return this.isTestOnBorrow;
    }

    @Override
    public void setTestOnReturn(boolean isTest) {
        this.isTestOnReturn = isTest;
    }

    @Override
    public boolean isTestOnReturn() {
        return this.isTestOnReturn;
    }

    @Override
    public void setTestWhileIdle(boolean isTest) {
        this.isTestWhileIdle = isTest;
    }

    @Override
    public boolean isTestWhileIdle() {
        return this.isTestWhileIdle;
    }

    @Override
    public void setTimeBetweenEvictionRuns(long millis) {
        this.timeBetweenEvictionRuns = millis;
    }

    @Override
    public long getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    @Override
    public void setWhenExhaustedAction(String action) throws IllegalArgumentException {
        if ("WHEN_EXHAUSTED_BLOCK".equals(action)) {
            this.whenExhaustedActionValue = 1;
        } else if ("WHEN_EXHAUSTED_BLOCK".equals(action)) {
            this.whenExhaustedActionValue = 0;
        } else if ("WHEN_EXHAUSTED_BLOCK".equals(action)) {
            this.whenExhaustedActionValue = (byte)2;
        } else {
            throw new IllegalArgumentException(action);
        }
        this.whenExhaustedActionName = action;
    }

    @Override
    public String getWhenExhaustedAction() {
        return this.whenExhaustedActionName;
    }

    @Override
    public void startService() throws Exception {
        PoolableObjectFactory factory = null;
        if (this.poolableObjectFactoryClass != null) {
            factory = (PoolableObjectFactory)this.poolableObjectFactoryClass.newInstance();
        } else if (this.poolableObjectFactoryServiceName != null) {
            factory = (PoolableObjectFactory)ServiceManagerFactory.getServiceObject(this.poolableObjectFactoryServiceName);
        } else {
            throw new IllegalArgumentException("poolableObjectFactoryClass or poolableObjectFactoryServiceName must be specified.");
        }
        if (this.pooledTransactionResourceClass == null) {
            throw new IllegalArgumentException("pooledTransactionResourceClass must be specified.");
        }
        this.transactionResourceConstructor = this.pooledTransactionResourceClass.getConstructor(ObjectPool.class);
        this.pool = new GenericObjectPool(factory);
        this.pool.setMaxActive(this.maxActive);
        this.pool.setMaxIdle(this.maxIdle);
        this.pool.setMinIdle(this.minIdle);
        this.pool.setMaxWait(this.maxWait);
        this.pool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTime);
        this.pool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        this.pool.setTestOnBorrow(this.isTestOnBorrow);
        this.pool.setTestOnReturn(this.isTestOnReturn);
        this.pool.setTestWhileIdle(this.isTestWhileIdle);
        this.pool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRuns);
        this.pool.setWhenExhaustedAction(this.whenExhaustedActionValue);
    }

    @Override
    public void stopService() throws Exception {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
    }

    @Override
    public TransactionResource makeResource(String key) throws Exception {
        return (TransactionResource)this.transactionResourceConstructor.newInstance(this.pool);
    }

    @Override
    public void clear() throws Exception {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    @Override
    public int getActiveNum() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    @Override
    public int getIdleNum() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }
}

